import React from "react";
import { useTranslation } from "next-i18next";
import styled from "styled-components";
import { PublicProfileDto } from "../../../core/models/interfaces/Client/PublicProfileDto";

interface HeaderProfileProps {
  publicProfile?: PublicProfileDto;
}

function HeaderProfile(props: HeaderProfileProps) {
  const { publicProfile: profile } = props;
  const { t } = useTranslation("common");

  return (
    <Wrapper>
      <ProfileImage url={profile?.urlFoto || "/assets/perfil-default.png"} />
      <InfosContainer>
        <BoldText>{profile?.nome}</BoldText>
        <Text>{t("performed") + " " + (profile?.quantidadeAventuras || 0) + " " + t("adventures")}</Text>
        <FollowsContainer>
          <div>
            <BoldText>{profile?.quantidadeSeguindo || 0}</BoldText>
            <Text>{t("following")}</Text>
          </div>
          <div>
            <BoldText>{profile?.quantidadeSeguidores || 0}</BoldText>
            <Text>{t("followers")}</Text>
          </div>
        </FollowsContainer>
      </InfosContainer>
    </Wrapper>
  );
}

export default React.memo(HeaderProfile);

const Wrapper = styled.div`
  width: 100%;
  color: ${(p) => p.theme.activeElementForeground};
  display: flex;
  flex-direction: row;
  align-items: center;
  margin-bottom: 20px;
`;

const InfosContainer = styled.div`
  height: 100%;
  display: flex;
  flex-direction: column;
  max-width: 300px;
  flex: 1;
  margin-left: 10px;
`;

const BoldText = styled.text`
  font: normal normal 600 20px/30px Poppins;
`;

const Text = styled.text`
  font: normal normal normal 11px/20px Poppins;
`;

const FollowsContainer = styled.div`
  display: flex;
  justify-content: space-between;
  min-width: 100px;

  div {
    display: flex;
    flex-direction: column;
    text-align: center;
  }
`;

const ProfileImage = styled.div<{ url: string }>`
  width: 92px;
  height: 92px;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
`;
