import React from "react";
import styled from "styled-components";
import { transparentize } from "polished";
import Logo from "../Logo";
import NavBar from "../NavBar";
import { CONTAINER_WIDTH, HEADER_HEIGHT } from "../../../_constants";

function Header() {
  return (
    <Wrapper>
      <Container>
        <Logo />
        <NavBar />
      </Container>
    </Wrapper>
  );
}

export default React.memo(Header);

const Container = styled.div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  max-width: ${CONTAINER_WIDTH}px;
  margin: auto;
  height: 100%;
  padding: 0px 16px;
`;

const Wrapper = styled.div`
  background-color: ${(p) => p.theme.activeElementBackground};
  color: ${(p) => p.theme.activeElementForeground};
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  width: 100%;
  height: ${HEADER_HEIGHT}px;
`;
