import { transparentize } from "polished";
import styled from "styled-components";

interface FormLoadingProps {
  show?: boolean;
}

export default function FormLoading(props: FormLoadingProps) {
  return <Loading show={props.show} />;
}

const Loading = styled.div<{ show?: boolean }>`
  height: 100%;
  width: 100%;
  position: absolute;
  display: ${(p) => (p.show ? "block" : "none")};
  z-index: ${(p) => (p.show ? 10 : -5)};

  background-color: ${(p) => transparentize(0.3, p.theme.activeElementBackground)};
`;
