import React from "react";
import styled from "styled-components";
import { useTheme } from "styled-components";
import { FOOTER_HEIGHT } from "../../../_constants";
import { FaInstagram, FaFacebook } from "react-icons/fa";
import { useTranslation } from "next-i18next";

function Footer() {
  const theme = useTheme();
  const { t } = useTranslation("common");

  return (
    <Wrapper>
      <Container>
        <HalfLeft>
          <text>{t("followSocialMedia")}</text>
          <ContainerIcons>
            <a href={"https://www.instagram.com/reltyapp/"} target="_blank" rel="noreferrer">
              <FaInstagram size={35} color={theme.primaryForeground} />
            </a>
            <a href={"https://m.facebook.com/reltyapp/"} target="_blank" rel="noreferrer">
              <FaFacebook size={35} color={theme.primaryForeground} />
            </a>
          </ContainerIcons>
        </HalfLeft>
        <HalfRight>
          <text>{t("contactUs")}</text>
          <ContainerIcons>
            <text>contato@reltyapp.com</text>
          </ContainerIcons>
        </HalfRight>
      </Container>
      <HalfBottom>
        <text>{t("copyright")}</text>
      </HalfBottom>
    </Wrapper>
  );
}

export default React.memo(Footer);

const Container = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: row;
  max-width: 848px;
  margin: auto;
  height: 80%;
  text-align: center;

  text {
    font-size: 22px;
  }

  @media screen and (max-width: 767px) {
    flex-direction: column;
    padding-top: 20px;
  }
`;

const Wrapper = styled.footer`
  background-color: ${(p) => p.theme.primaryBackground};
  color: ${(p) => p.theme.primaryForeground};
  width: 100%;
  height: ${FOOTER_HEIGHT}px;
`;

const HalfLeft = styled.div`
  height: 50%;
  width: 50%;
`;

const ContainerIcons = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  a {
    text-decoration: none;
    margin: 0 10px;
  }
  text {
    font-size: 18px;
  }
`;

const HalfRight = styled.div`
  height: 50%;
  width: 50%;
`;

const HalfBottom = styled.div`
  height: 20%;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;
  max-width: 848px;
  margin: auto;
`;
