import React from "react";
import styled from "styled-components";
import { useField } from "formik";

function Field(props: any) {
  const [inputProps, meta] = useField(props);

  return <Input {...inputProps} {...props} />;
}

export default Field;

const Input = styled.input`
  display: block;
  width: 400px;
  padding: 6px 12px;
  font-size: 14px;
  line-height: 1.42857143;
  color: #555;
  background-color: #fff;
  background-image: none;
  border: 1px solid #ccc;
  border-radius: 4px;
`;
