import { transparentize } from "polished";
import React from "react";
import styled from "styled-components";
import { AdventureType } from "../../../core/models/enums/AdventureType";
import { Util } from "../../../core/utils/util";
import { useTranslation } from "next-i18next";

interface ElementTagProps extends React.HTMLProps<HTMLDivElement> {
  adventureType: AdventureType;
}

function ElementTag(props: ElementTagProps) {
  const { t } = useTranslation("common");

  return (
    <Element>
      <ElementCircle color={Util.getColorByAdventureType(props.adventureType)}></ElementCircle>
      <Text>{t(Util.getNameByAdventureType(props.adventureType))}</Text>
    </Element>
  );
}

export default React.memo(ElementTag);

const Element = styled.div`
  cursor: pointer;
  display: flex;
  z-index: 10;
  width: 100%;
  height: 20px;
  flex-direction: row;
  justify-content: space-around;
  align-items: center;
  background-color: ${(p) => p.theme.activeElementBackground};
  border-radius: ${(p) => p.theme.borderRadius};
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  position: relative;

  text {
    font: normal normal normal 12px/14px Poppins;
  }
`;
export const ElementCircle = styled.div<{ color: string }>`
  width: 14px;
  height: 14px;
  border-radius: ${(p) => p.theme.borderRadius};
  background-color: ${(p) => p.color};
  position: absolute;
  left: 2px;
`;

export const Text = styled.text`
  width: 100%;
  text-align: left;
  font: normal normal normal 14px/18px Poppins;
  margin-left: 18px;
  letter-spacing: 0.2px;
  line-height: 1.1;
  color: ${(p) => p.theme.pageForeground};
`;
