import { DataTable } from "primereact/datatable";
import { Column } from "primereact/column";
import styled from "styled-components";
import Button from '../Button';
import { FaStore, FaUserAlt, FaUserCog } from 'react-icons/fa';
import MaterialModal from '../MaterialModal';
import { useState } from 'react';
import DeleteModalCategory from "../CategoryModal/DeleteModal";
import DeleteModalMaterial from '../MaterialModal/DeleteModal'
import CategoryModal from "../CategoryModal";
import SupplierModalComission from '../SupplierModalComission'
import SubscribedModal from '../SubscribedModal'
import ChangeUserPasswordModal from '../UserModal/ChangeUserPasswordModal';
import Air from "../SvgIcons/air";
import Earth from '../SvgIcons/earth'
import Water from '../SvgIcons/water'
import router from "next/router";
import ModalClosedClasse from '../ClosedClasseModal'
import ModalMakeAdmin from '../ModalMakeAdmin'

/**
 * Types of data that this component supports:
 * - string: plain text
 * - textLong: for long text
 * - image: for image
 * - buttonAction: this data type follows an example to be followed to correctly work the component
 * example of the buttonAaction
 * { field: 'buttonAction', header: '', type: 'buttonAction', typeButton: [
        {
            page: 'establishment',
            label: 'Detalhes'
        },
        {
            page: 'establishment'
            label: 'Alterar comissão',
        }
    ]}
 *  the "buttonActionValidatorPage" function
 *   the logic of each page is applied to be able to work these events
 */

type column = {
  type: any;
  field: any;
  typeButton: any[];
};
interface DataTableCustomProps {
  values: any;
  columns: column;
}

export default function DataTableCustom(props: DataTableCustomProps) {

  const [visibleModalMaterial, setVisibleModalMaterial] = useState(false)
  const [visibleModalCategory, setVisibleModalCategory] = useState(false)
  const [visibleModalMaterialDelete, setVisibleModalMaterialDelete] = useState(false)
  const [visibleModalCategoryDelete, setVisibleModalCategoryDelete] = useState(false)
  const [dataModalMaterial, setDataModalMaterial] = useState({})
  const [dataModalCategory, setDataModalCategory] = useState({})
  const [dataModalSupplierComission, setDataModalSupplierComission] = useState({})
  const [visibleModalSupplierComission, setVisibleModalSupplierComission] = useState(false)
  const [visibleModalSubscribed, setVisibleModalSubscribed] = useState(false)
  const [visibleModalChangePassword, setVisibleModalChangePassword] = useState(false)
  const [visibleModalTurnUserAdmin, setVisibleModalTurnUserAdmin] = useState(false)
  const [dataModalUser, setDataModalUser] = useState({})
  const [dataModalSubscribed, setDataModalSubscribed] = useState({})
  const [visibleModalClosedClasse, setVisibleModalClosedClasse] = useState(false)
  const [dataModalClosedClasse, setDataModalClosedClasse] = useState({})
  const [dataModalMakeAdmin, setDataModalMakeAdmin] = useState({})
  const [visibleModalMakkeAdmin, setVisibleModalMakeAdmin] = useState(false)

  const typeData = Object.values(props.columns).map(i => {
      return { field: i.field, type: i.type, typeButton: i.typeButton || [] }
  })

  const buttonActionValidatorPage = (rowData: any, typeButton: any) => {

    // Page list client
    if (typeButton.page.includes("clients")) {
      if (typeButton.label.includes("Detalhes")) {
        router.push(`/profiles/supplier/clients/${rowData.idCliente}`)
      }
    }

    // Page list establishment
    if (typeButton.page.includes("establishment")) {
      if (typeButton.label.includes("Detalhes")) {
        router.push(`/profiles/admin/supplier/${rowData.id}`)
      }

      if (typeButton.label.includes("Alterar comissão")) {
        setDataModalSupplierComission(rowData)
        setVisibleModalSupplierComission(!visibleModalSupplierComission)
      }
    }

    //Page list user
    if (typeButton.page.includes("user")){
      if(typeButton.label.includes('Alterar senha')){
        setVisibleModalChangePassword(!visibleModalChangePassword)
      }
      if (typeButton.label.includes("Tornar admin") || typeButton.label.includes("Remover admin")) {
        setDataModalMakeAdmin(rowData)
        setVisibleModalMakeAdmin(!visibleModalMakkeAdmin)
      }
    }

    // Page list category
    if(typeButton.page.includes('category')){
      setDataModalCategory(rowData)

      if(typeButton.label.includes('Editar categoria')){
        setVisibleModalCategory(!visibleModalCategory)
      }

      if(typeButton.label.includes('Apagar categoria')){
        setVisibleModalCategoryDelete(!visibleModalCategoryDelete)
      }
      return;
    }

    // Page list material
    if(typeButton.page.includes('material')){
        setDataModalMaterial(rowData)

        if(typeButton.label.includes("Editar material")){
          setVisibleModalMaterial(!visibleModalMaterial)
        }

        if(typeButton.label.includes("Apagar material")){
          setVisibleModalMaterialDelete(!visibleModalMaterialDelete)
        }
        return;
    }

    // Page list classes
    if(typeButton.page.includes('classes')){
      if(typeButton.label.includes("Inscritos")){
        router.push(`/profiles/supplier/classes/${rowData.aventuraId}/subscribed/${rowData.id}`)
      }

      if(typeButton.label.includes("Alterar status")){
        setDataModalClosedClasse(rowData)
        setVisibleModalClosedClasse(!visibleModalClosedClasse)
      }
      return;
    }

  // Page list subscribed
  if(typeButton.page.includes('subscribed')){
    setDataModalSubscribed(rowData)
    if(typeButton.label.includes("Alterar status")){
      setVisibleModalSubscribed(!visibleModalSubscribed)
    }
    return;
  }

};

  const imageBodyTemplate = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("image")) {
        if (rowData[i.field]) {
          return <ImageRadius key={i.field} url={rowData[i.field]} />;
        }
        return <ImageRadius key={i.field} url={"/assets/perfil-default.png"} />;
      }
    });
    return listItemRender;
  };

  const textLongBodyTemplate = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("textLong")) {
        if (rowData[i.field]) {
          return (
            <p key={i.field} title={rowData[i.field]}>
              {" "}
              {rowData[i.field].slice(0, 50) + "..."}{" "}
            </p>
          );
        }
        return <p key={i.field}> - </p>;
      }
    });
    return listItemRender;
  };

  const buttonActionBodyTemplate = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("buttonAction")) {
        return (
          <div key={i.field}>
            {/* @ts-ignore */}
            {i.typeButton.map((y, index) => {
              if(y.page === 'user' && y.label.includes('Tornar admin') || y.label.includes('Remover admin')){
                if(rowData.perfis.includes('adm')){
                  y.label = "Remover admin"
                } else {
                  y.label = "Tornar admin"
                }
              }

              return (
                <Button
                  style={{ padding: "2px 2px 0px 2px", margin: "2px" }}
                  key={index}
                  onClick={() => buttonActionValidatorPage(rowData, y)}
                  text={y.label}
                  sizeText={13}
                />
              );
            })}
          </div>
        );
      }
    });
    return listItemRender;
  };

  const iconStrBodyTemplatePageDepends = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("iconStr")) {
        let typeIconRender = rowData[i.field].split(",");

        // @ts-ignore
        return typeIconRender.map((i, index) => {
          if (i.includes("estabelecimento")) {
            return (
              <span key={index}>
                <FaStore color={"#006993"} size={18} title={i} /> &nbsp;
              </span>
            );
          }

          if (i.includes("cliente")) {
            return (
              <span key={index}>
                <FaUserAlt color={"#006993"} size={18} title={i} /> &nbsp;
              </span>
            );
          }

          if (i.includes("adm")) {
            return (
              <span key={index}>
                <FaUserCog color={"#006993"} size={18} title={i} />
              </span>
            );
          }
        });
      }
    });
    return listItemRender;
  };

  const dateBodyTemplate = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("date")) {
        if (rowData[i.field]) {
          return <p key={i.field}> {rowData[i.field].split("-").reverse().join("/")} </p>;
        }
        return <p key={i.field}> - </p>;
      }
    });
    return listItemRender;
  };

  const iconStrBodyTemplateElement = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("elementIcon")) {
        
        if(rowData[i.field]?.includes('T')){
          return <Earth width={55} height={55} active={true}/>;
        
        } else if(rowData[i.field]?.includes('G')){  
          return <Water width={55} height={55} active={true}/>;

        } if(rowData[i.field]?.includes('A')){
          return <Air width={55} height={55} active={true} />
        
        }

        return '-'
      }
    });
    return listItemRender;
  }

  const labelStrBodyTemplate = (rowData: any) => {
    const listItemRender = typeData.map((i) => {
      if (i.type.includes("labelData")) {
        if(rowData[i.field] && rowData[i.field] === 'PENDENTE' || rowData[i.field] === 'FECHADA'){
          return (
            <div style={{ backgroundColor: '#FBCB20', padding: '5px', borderRadius: '100px', color: 'white' }}>
              { rowData[i.field] }
            </div>
          )
        }

        if(rowData[i.field] && rowData[i.field] === 'PRESENTE' || rowData[i.field] === 'ABERTA'){
          return (
            <div style={{ backgroundColor: '#4CD964', padding: '5px', borderRadius: '100px', color: 'white' }}>
              { rowData[i.field] }
            </div>
          )
        }

        if(rowData[i.field]){
          return (
            <div style={{ backgroundColor: '#D5403B', padding: '5px', borderRadius: '100px', color: 'white' }}>
              { rowData[i.field] }
            </div>
          )
        }
        return '-'
      }
    });
    return listItemRender;
  }
{/* @ts-ignore */}
  const dynamicColumns = props.columns?.map((col: any, i: any) => {
      if(col.type.includes('image')){
        {/* @ts-ignore */}
          return <Column key={col.field} field={col.field} header={col.header} body={imageBodyTemplate} />;
      }

      if(col.type.includes('textLong')){
        {/* @ts-ignore */}
          return <Column key={col.field} field={col.field} header={col.header} body={textLongBodyTemplate}/>; 
      }

      if(col.type.includes('buttonAction')){
        {/* @ts-ignore */}
          return <Column key={col.field} field={col.field} header={col.header} body={buttonActionBodyTemplate}/>; 
      }

      if(col.type.includes('iconStr')){
        {/* @ts-ignore */}
          return <Column key={col.field} field={col.field} header={col.header} body={iconStrBodyTemplatePageDepends} />
      }

      if(col.type.includes('elementIcon')){
        {/* @ts-ignore */}
        return <Column key={col.field} field={col.field} header={col.header} body={iconStrBodyTemplateElement} />
      }

      if(col.type.includes('date')){
        {/* @ts-ignore */}
          return <Column key={col.field} field={col.field} header={col.header} body={dateBodyTemplate} />
      }

      if(col.type.includes('labelData')){
        {/* @ts-ignore */}
        return <Column key={col.field} field={col.field} header={col.header} body={labelStrBodyTemplate} />
      }
      {/* @ts-ignore */}
      return <Column key={col.field} field={col.field} header={col.header}/>
  });

    return (
        <>
          {/* Modal page material */}
          <MaterialModal visible={visibleModalMaterial} data={dataModalMaterial} onHide={() => { setVisibleModalMaterial(!visibleModalMaterial) }}/>
          <DeleteModalMaterial visible={visibleModalMaterialDelete} data={dataModalMaterial} onHide={() => { setVisibleModalMaterialDelete(!visibleModalMaterialDelete) } } />

          {/* Modal page category */}
          <CategoryModal visible={visibleModalCategory} data={dataModalCategory} onHide={() => { setVisibleModalCategory(!visibleModalCategory) }}/>
          <DeleteModalCategory visible={visibleModalCategoryDelete} data={dataModalCategory} onHide={() => { setVisibleModalCategoryDelete(!visibleModalCategoryDelete) } }/>
          
          {/* Modal page supplier comission */}
          <SupplierModalComission visible={visibleModalSupplierComission} data={dataModalSupplierComission} onHide={() => { setVisibleModalSupplierComission(!visibleModalSupplierComission) } }/>

          {/*Modal page user*/}
          <ModalMakeAdmin visible={visibleModalMakkeAdmin} data={dataModalMakeAdmin} onHide={() => { setVisibleModalMakeAdmin(!visibleModalMakkeAdmin) } }/>

          {/* Modal page subscribed */}
          <SubscribedModal visible={visibleModalSubscribed} data={dataModalSubscribed} onHide={() => { setVisibleModalSubscribed(!visibleModalSubscribed) } }/>
          
          {/* Modal closed classe */}
          <ModalClosedClasse visible={visibleModalClosedClasse} data={dataModalClosedClasse}  onHide={() => { setVisibleModalClosedClasse(!visibleModalClosedClasse) } }/>
          
          {/* Modal page change user password */}
          <ChangeUserPasswordModal visible={visibleModalChangePassword} data={dataModalUser} onHide={() => { setVisibleModalChangePassword(!visibleModalChangePassword) }} />

          <div className="datatable-responsive">
            {/* @ts-ignore */}
              <DataTable value={props.values} className="p-datatable-responsive">
                  {dynamicColumns}
              </DataTable>
          </div>
        </>
    );
}

const ImageRadius = styled.div<{ url: string }>`
  width: 40px;
  height: 40px;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  margin-inline: auto;
`;