import styled from "styled-components";

import InputMask from "react-input-mask";

export const Container = styled.div`
  display: flex;
  width: 100%;
  flex-direction: column;

  .select {
    background: url(data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0Ljk1IDEwIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2ZmZjt9LmNscy0ye2ZpbGw6IzQ0NDt9PC9zdHlsZT48L2RlZnM+PHRpdGxlPmFycm93czwvdGl0bGU+PHJlY3QgY2xhc3M9ImNscy0xIiB3aWR0aD0iNC45NSIgaGVpZ2h0PSIxMCIvPjxwb2x5Z29uIGNsYXNzPSJjbHMtMiIgcG9pbnRzPSIxLjQxIDQuNjcgMi40OCAzLjE4IDMuNTQgNC42NyAxLjQxIDQuNjciLz48cG9seWdvbiBjbGFzcz0iY2xzLTIiIHBvaW50cz0iMy41NCA1LjMzIDIuNDggNi44MiAxLjQxIDUuMzMgMy41NCA1LjMzIi8+PC9zdmc+)
      no-repeat 95% 50%;
  }
`;

export const Input = styled.input<{ error: any }>`
  -moz-appearance: none;
  -webkit-appearance: none;
  display: block;
  width: 100%;
  border: none;
  border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.inactiveElementBackground)};
  padding: 6px 12px;
  padding-left: 24px;
  font-size: 14px;
  line-height: 1.42857143;
  outline: none;
  font-family: Poppins;
  background-color: transparent;
  resize: vertical;

  :focus {
    border: none;
    border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.primaryBackground)};
  }
`;

export const MaskedInput = styled(InputMask)<{ error: any }>`
  display: block;
  width: 100%;
  border: none;
  border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.inactiveElementBackground)};
  padding: 6px 12px;
  padding-left: 24px;
  font-size: 14px;
  line-height: 1.42857143;
  outline: none;
  font-family: Poppins;
  background-color: transparent;

  :focus {
    border: none;
    border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.primaryBackground)};
  }
`;

export const InputContainer = styled.div`
  width: 100%;
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: center;
  position: relative;

  svg {
    position: absolute;
    left: 0;
  }

  input {
    ${Input}
  }
`;

export const Label = styled.text`
  width: 100%;
  color: ${(p) => p.theme.pageForeground};
  font-size: 14px;
  text-align: left;
  font-weight: 600;
`;

export const ErrorLabel = styled.text`
  width: 100%;
  color: ${(p) => p.theme.red};
  position: absolute;
  font-size: 10px;
  text-align: left;
  bottom: -18px;
`;
