import React, { useRef } from "react";
import { useField } from "formik";
import { ErrorMessage } from "formik";
import { Container, Label, InputContainer, ErrorLabel, Input, MaskedInput } from "./styles";

function CustomInput(props: any) {
  const [inputProps] = useField(props);
  const inputRef = useRef<any>();

  const { label, name, options, icon, as, error, ...rest } = props;

  const TextError = ({ children }: any) => {
    return <ErrorLabel>{children}</ErrorLabel>;
  };

  return (
    <Container className="form-control">
      {label && <Label>{label}</Label>}

      <InputContainer>
        {icon}
        {
          props.mask ? (
            <MaskedInput error={error} ref={inputRef} {...inputProps} {...rest} />
          ) : 
          <Input as={as || "input"} error={error} ref={inputRef} {...inputProps} {...rest}>
            {options &&
              options.map((option: any) => {
                return (
                  <option key={option.value} value={option.value}>
                    {option.key}
                  </option>
                );
              })}
          </Input>
        }
        {/* @ts-ignore */}
        <ErrorMessage name={name} component={TextError} />
      </InputContainer>
    </Container>
  );
}

export default CustomInput;
