import { Dialog } from "primereact/dialog"
import { useEffect, useReducer, useRef, useState } from "react"
import Button from "../Button"
import { InputGroup } from './styles'
import { Toast } from "primereact/toast"
import useClient from "../../../core/hooks/useClient"

export default function ClosedClasseModal(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const [classe, setClasse] = useState({})
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);
    const { saveDataCloseClasse } = useClient();


    useEffect(() => {
        setVisible(props.visible)
        setClasse(props.data)
    }, [props.visible])

    const serviceClosedClasse = async (classe: object) => {
        {/* @ts-ignore */}
        const response = await saveDataCloseClasse(classe.id)
        if(response.status === 200){
            if(props.data.situacaoTurma === 'ABERTA'){
                props.data.situacaoTurma = 'FECHADA'
            } else {
                props.data.situacaoTurma = 'ABERTA'
            }
            props.onHide()
            forceUpdate()
        }
    }

    return (
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />

        {/* @ts-ignore */}
        <Dialog header="Atenção" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            <div>
                Você deve informar se a turma vai está aberta ou fechada
            </div>
            <br/>
            <InputGroup inputs={2}>
                <Button type="button" color="#495057a3" onClick={() => props.onHide() } text="Cancelar" ></Button>
                {props.data.situacaoTurma == 'ABERTA' ? 
                    (<Button type="button" text="Fechar turma" onClick={() => serviceClosedClasse(classe) } ></Button> )
                        : 
                    (<Button type="button" text="Abrir turma" onClick={() => serviceClosedClasse(classe) } ></Button> )
                }
            </InputGroup>
        </Dialog>
        </>
    )
}