import { Dialog } from "primereact/dialog"
import { Formik, Form } from "formik";
import Button from "../Button";
import { useEffect, useReducer, useRef, useState } from "react";
import Input  from "../CustomInput";
import { InputGroup, InputContainer } from "./styles";
import useCategory from "../../../core/hooks/useCategory";
import { Util } from "../../../core/utils/util";
import { Toast } from "primereact/toast";

export default function CategoryModal(props: any) {
    const toast = useRef(null);
    const { saveDataCategory } = useCategory()
    const [visible, setVisible] = useState(false)
    const [category, setCategory] = useState({
        nome: null,
        nomePt: null,
        nomeEn: null,
        nomeEs: null,
        tipoAventura: null
    })
    const dropdownOptions = [
        { key: "Selecione um elemento", value: null },
        { key: "Ar", value: "A" },
        { key: "Água", value: "G" },
        { key: "Terra", value: "T" },
    ];
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);

    const saveCategoryDataDto = async () => {
        if(props.data && props.data.id){
            setCategory(prevState => {
                return { ...prevState, id: props.data.id }
            })
            props.data.nomePt = category.nomePt
            props.data.nomeEn = category.nomeEn
            props.data.nomeEs = category.nomeEs
            props.data.tipoAventura = category.tipoAventura
        }
        
        if(category && category.nomePt && category.nomeEn && category.nomeEs && category.tipoAventura){
            category.nome = category.nomePt
            const response = await saveDataCategory(category)
            if(response.status === 200){
                Util.showSucessToast(toast, "Categoria salva com sucesso");
            } else {
                Util.showErrorToast(toast, "Erro ao salvar categoria");
            }
        } else {
            Util.showErrorToast(toast, "Preencha todos os campos");
        }
        
        forceUpdate()
        setCategory({
            nome: null,
            nomePt: null,
            nomeEn: null,
            nomeEs: null,
            tipoAventura: null
        })
        props.onHide()
    }

    useEffect(() => {
        setVisible(props.visible)
        setCategory(props.data)
    }, [props.visible])

    return(
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />
        {/* @ts-ignore */}
        <Dialog header={category?.id ? 'Salvar categoria' : 'Nova categoria' } visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide() }>
            {/* @ts-ignore */}
            <Formik>
            <Form>
            <InputGroup inputs={1}>
                <InputContainer>
                    <Input
                        name="nomePortugues"
                        label="Nome em portugues"
                        placeholder="Cachoeirismo"
                        value={category?.nomePt || ""}
                        onChange={(i: any) => setCategory(prevState => {
                            return { ...prevState, nomePt: i.target.value }
                        })}
                    />
                </InputContainer>
                <InputContainer>
                    <Input
                        name="nomeIngles"
                        label="Nome em inglês"
                        placeholder="Waterfall"
                        value={category?.nomeEn || ""}
                        onChange={(i: any) => setCategory(prevState => {
                            return { ...prevState, nomeEn: i.target.value }
                        })}
                    />
                </InputContainer>
                <InputContainer>
                    <Input 
                        name="nomeEspanhol"
                        label="Nome em espanhol"
                        placeholder="Cascada"
                        value={category?.nomeEs || ""}
                        onChange={(i: any) => setCategory(prevState => {
                            return { ...prevState, nomeEs: i.target.value }
                        })}
                    />
                </InputContainer>
                <InputContainer>
                    <Input 
                        name="nomeElemento"
                        label="Elemento"
                        as="select"
                        options={dropdownOptions}
                        onChange={(i: any) => setCategory(prevState => {
                            return { ...prevState, tipoAventura: i.target.value }
                        })}
                        value={category?.tipoAventura || null}
                    />
                </InputContainer>
            </InputGroup>
                <Button type="button" onClick={() => saveCategoryDataDto()} text="Salvar alterações"></Button>
            </Form>
            </Formik>
        </Dialog>
        </>
    )
}