import styled from "styled-components";

export const InputGroup = styled.div<{ inputs: number }>`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${(p) => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;