import { Dialog } from "primereact/dialog"
import { useEffect, useRef, useState } from "react"
import Button from "../../Button"
import { InputGroup } from './styles'
import { Util } from "../../../../core/utils/util"
import { Toast } from "primereact/toast"
import useCategory from "../../../../core/hooks/useCategory"

export default function DeleteModalCategory(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const [category, setCategory] = useState({})
    const { deleteDataCategory } = useCategory()

    useEffect(() => {
        setVisible(props.visible)
        setCategory(props.data)

    }, [props.visible])

    const deleteCategoriaDataDto = async () => {
        {/* @ts-ignore */}
        if(category && category?.id){
            const response = await deleteDataCategory(category)
            if(response.status === 204){
                Util.showSucessToast(toast, "Categoria excluido com sucesso");
            } else {
                Util.showErrorToast(toast, "Erro ao excluir categoria");
            }
        }
        props.onHide()
    }

    return (
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />

        {/* @ts-ignore */}
        <Dialog header="Excluir categoria" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            <div>
                Você tem certeza que deseja excluir o categoria ? A operação não poder desfeita.
            </div>
            <br/>
            <InputGroup inputs={2}>
                <Button type="button" color="#495057a3" onClick={() => props.onHide()} text="Não"></Button>
                <Button type="button" onClick={() => deleteCategoriaDataDto() } text="Sim"></Button>
            </InputGroup>
        </Dialog>
        </>
    )
}