import moment from "moment";
import React from "react";
import styled from "styled-components";

import { AdventureRate } from "../../../core/models/interfaces/Adventure/AdventureRate";
import EmptyStar from "../SvgIcons/emptyStar";
import Star from "../SvgIcons/star";

interface CardRateProps {
  rate: AdventureRate;
}

function CardRate(props: CardRateProps) {
  const { rate } = props;

  const getRate = () => {
    let note = Number(rate.notaAvaliacao.toFixed(0));

    var rates: any = [];

    for (let index = 0; index < 5; index++) {
      if (index + 1 <= note) {
        rates.push(<Star width={10} height={10} />);
      } else {
        rates.push(<EmptyStar width={10} height={10} />);
      }
    }
    return rates;
  };

  return (
    <Wrapper>
      <ImageAndNameContainer>
        <RateImage url={rate.urlFotoCliente || "/assets/perfil-default.png"}></RateImage>
        <TextContainer>
          <ClientName>{rate.nomeCliente}</ClientName>
          <Stars>
            <Date>{moment(rate.dataAvaliacao).format("D [de] MMMM [de] YYYY")}</Date>
            <div>{getRate()}</div>
          </Stars>
        </TextContainer>
      </ImageAndNameContainer>
      <Rate>{rate.descricaoAvaliacao}</Rate>
    </Wrapper>
  );
}

export default React.memo(CardRate);

const Wrapper = styled.div`
  width: 100%;
`;

const ImageAndNameContainer = styled.div`
  width: 100%;
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
  align-items: center;
  color: ${(p) => p.theme.pageForeground};
`;

const TextContainer = styled.div`
  display: flex;
  flex-direction: column;
  margin-left: 10px;
`;

const ClientName = styled.text`
  font: normal normal bold 14px/21px Poppins;
`;

const Stars = styled.div`
  display: flex;
  flex-direction: row;
  justify-content: center;
  align-items: center;

  div {
    margin-left: 5px;
  }
`;

const Date = styled.text`
  font: normal normal normal 13px/20px Poppins;
`;

const Rate = styled.text`
  margin-top: 20px;
  font: normal normal normal 14px/24px Poppins;
`;

export const RateImage = styled.div<{ url: string }>`
  width: 46px;
  height: 46px;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
`;
