import styled from "styled-components";
import { transparentize } from "polished";

export const Image = styled.div<{ url: string }>`
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 69%;
    background-image: url(${(p) => p.url});
    background-position: center;
    background-size: cover;
    border-top-left-radius: ${(p) => p.theme.borderRadius};
    border-top-right-radius: ${(p) => p.theme.borderRadius};
`;

export const FavoriteContainer = styled.div`
    position: absolute;
    right: 8px;
    top: 8px;
    cursor: pointer;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 10;
`;

export const RatingContainer = styled(FavoriteContainer)`
    left: 8px;
    top: 8px;
    max-width: 55px;
    height: 22px;
    background-color: ${(p) => p.theme.activeElementBackground};
    border-radius: ${(p) => p.theme.borderRadius};
    padding: 5px;
    justify-content: space-around;
`;

export const Element = styled(FavoriteContainer)`
    right: 8px;
    top: 195px;
    width: 60px;
`;

export const ElementTransAction = styled.div<{ color: string }>`
    position: absolute;
    right: 8px;
    top: 8px;
    cursor: pointer;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 10;

    left: 8px;
    top: 185px;
    max-width: 110px;
    height: 22px;
    color: white;
    background-color: ${(p) => p.color};
    font-size: .8rem;
    color: rgba(0, 0, 0, 0.5);
    border-radius: ${(p) => p.theme.borderRadius};
`

export const Wrapper = styled.div`
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
    width: 100%;
    min-height: 320px;
    color: ${(p) => p.theme.pageForeground};
    background-color: white;
    position: relative;

    transition: 0.25s ease;
    * {
        transition: 0.25s ease;
    }

    &:hover, &:focus {
        * {
            color: ${(p) => p.theme.primaryForeground};
        }

        ${Image} {
            height: 100%;
        }

        ${RatingContainer},
        ${Element} {
            text {
                color: ${(p) => p.theme.pageForeground};
            }   
        }
    }   
`;

export const CardContent = styled.div<{ align: string }>`
    border-${ (p) => p.align || 'top' }-left-radius: ${(p) => p.theme.borderRadius};
    border-${ (p) => p.align || 'top' }-right-radius: ${(p) => p.theme.borderRadius};
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};

    color: ${(p) => p.theme.activeElementForeground};
    // display: flex;
    // flex-direction: row;
    align-items: center;
    justify-content: space-around;
    // margin-inline: 0;
    padding: 10px;
`

export const TitleContainer = styled.div`
    background-color: rgba(0, 0, 0, 0.5);
    color: #fff;
    text-align: center;
    right: 8px;
    top: 8px;
    top: 100px;
    width: 250px;
    line-height: 30px;
    height: 30px;
`;

export const InfoContainer = styled.div`
    position: absolute;
    top: 69%;
    width: 65%;
    height: 30%;
    padding: 10px 10px;
    display: flex;
    flex-direction: column;
    gap: 10px;
`;

export const InfoAccomplishedContainer = styled.div`
    position: absolute;
    top: 88%;
    width: 65%;
    height: 30%;
    padding: 10px 10px;
    display: flex;
    flex-direction: column;
    gap: 10px;
`;

export const ButtonAction = styled.button`
    background-color: ${(p) => p.theme.primaryBackground};
    border-radius: ${(p) => p.theme.borderRadius};
    cursor: pointer;
    padding: 8px;
    margin: 8px;
    border: none;
    color: #fff;

    .text {
        font: normal normal normal 14px/20px Poppins;
    }
`

export const Title = styled.text`
    text-align: left;
    font: normal normal 600 16px/14px Poppins;
    letter-spacing: 0.2px;
    line-height: 1.1;
    color: ${(p) => p.theme.pageForeground};
`;

export const Text = styled(Title)`
    font: normal normal normal 14px/14px Poppins;
`;

export const PriceContainer = styled(InfoContainer)`
    width: 35%;
    right: 0;
    padding-left: 0;
`;
