import styled from "styled-components";
import { transparentize } from "polished";

export const Image = styled.div<{ url: string }>`
    position: absolute;
    width: 100%;
    height: 69%;
    background-image: url(${(p) => p.url});
    background-position: center;
    background-size: cover;
`;

export const FavoriteContainer = styled.div`
    position: absolute;
    right: 8px;
    top: 8px;
    cursor: pointer;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 10;
`;

export const RatingContainer = styled(FavoriteContainer)`
    left: 8px;
    top: 8px;
    max-width: 55px;
    height: 22px;
    background-color: ${(p) => p.theme.activeElementBackground};
    border-radius: ${(p) => p.theme.borderRadius};
    padding: 5px;
    justify-content: space-around;
`;

export const Element = styled(FavoriteContainer)`
    right: 8px;
    top: 195px;
    width: 60px;
`;

export const Wrapper = styled.div`
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
    width: 100%;
    min-height: 320px;
    color: ${(p) => p.theme.pageForeground};
    background-color: white;
    position: relative;

    transition: 0.25s ease;
    * {
        transition: 0.25s ease;
    }

    &:hover, &:focus {
        * {
            color: ${(p) => p.theme.primaryForeground};
        }

        ${Image} {
            height: 100%;
        }

        ${RatingContainer},
        ${Element} {
            text {
                color: ${(p) => p.theme.pageForeground};
            }   
        }
    }   
`;

export const TitleContainer = styled.div`
    background-color: rgba(0, 0, 0, 0.5);
    color: #fff;
    text-align: center;
    right: 8px;
    top: 8px;
    top: 100px;
    width: 250px;
    line-height: 30px;
    height: 30px;
`;

export const InfoContainer = styled.div`
    position: absolute;
    top: 75%;
    height: auto;
    padding: 10px 10px;
    display: flex;
    flex-direction: column;
`;

export const InfoContainerHeaderProfile = styled.div`
    height: 100%;
    display: flex;
    flex-direction: column;
    max-width: 300px;
    flex: 1;
`

export const TextHeaderProfile = styled.text`
font: normal normal normal 11px/20px Poppins;
`

export const Title = styled.text`
    text-align: left;
    font: normal normal 600 16px/14px Poppins;
    letter-spacing: 0.2px;
    line-height: 1.1;
    color: ${(p) => p.theme.pageForeground};
`;

export const Text = styled(Title)`
    cursor: default;
    font: normal normal bold 14px/14px Poppins;
`;

export const CardContent = styled.div<{ align: string }>`
    border-${ (p) => p.align || 'top' }-left-radius: ${(p) => p.theme.borderRadius};
    border-${ (p) => p.align || 'top' }-right-radius: ${(p) => p.theme.borderRadius};
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};

    color: ${(p) => p.theme.activeElementForeground};
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: space-around;
    margin-inline: 0;
    padding: 10px;
`

export const ProfileImage = styled.div<{ url: string }>`
    width: 45px;
    height: 45px;
    background-image: url(${(p) => p.url});
    background-position: center;
    background-size: cover;
    border-radius: 100px;
    display: flex;
    justify-content: center;
    align-items: center;
    cursor: default;
`;

export const BoldText = styled.text`   
    font: normal normal 600 20px/30px Poppins;
`;

export const Button = styled.button<{ color: string, colorSite: string }>`
    padding: 0;
    border: none;
    outline: none;
    background-color: ${(p) => p.color || p.theme.secondaryBackground};
    border-radius: 6px;
    color: ${(p) => p.colorSite || p.theme.primaryForeground};
    cursor: pointer;
    padding: 8px;
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
`