import React, { useEffect, useReducer, useState } from "react";
import * as Card from "./styles";
import Link from "next/link";
import ElementTag from "../ElementTag";
import { useTranslation } from "next-i18next";
import FullHeart from "../SvgIcons/fullHeart";
import Heart from "../SvgIcons/heart";
import Star from "../SvgIcons/star";
import Image from 'next/image'
import LikeRegular from '../../../assets/icons/social/like-regular.png'
import LikeSolid from '../../../assets/icons/social/like-solid.png'
import CommentImg from '../../../assets/icons/social/comments.png'
import useClient from "../../../core/hooks/useClient";
import useAdventure from "../../../core/hooks/useAdventure";
import api from "../../../core/services/api";
import { Dialog } from "primereact/dialog";

function CardAdventureCommunity(props: any) {

    const { t } = useTranslation();
    const { saveDataFollow, saveDataUnFollow } = useClient();
    const { favoriteAdventure, desfavoriteAdventure, getDataRating } = useAdventure()
    const [seCurtido, setSeCurtido] = useState(props.adventure.seCurtida == "S" ? true : false);
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);
    const [seSeguindo, setSeSeguindo] = useState(props.adventure.seSeguindo == "S" ? true : false);
    const [visibleModalComentarios, setVisibleModalComentarios] = useState(false)
    const { seguirCardsIguais, mudarSeguindo, naoSeguirCardsIguais } = props;
    const [listRating, setListRating] = useState([])

    useEffect(() => {
        if (mudarSeguindo > 0)
            if (props.adventure.seSeguindo == "S") {
                setSeSeguindo(true);
            } else {
                setSeSeguindo(false);
            }
    }, [mudarSeguindo]);

    const handleFavoriteOrDesfavorite = async (event: React.MouseEvent) => {
        event.preventDefault();
        if (props.adventure.aventura.id){
            if (props.adventure.aventura.seFavorita === "N") {
                await favoriteAdventure(props.adventure.aventura.id).then(() => {
                    props.adventure.aventura.seFavorita = "S";
                })
            } else {
                await desfavoriteAdventure(props.adventure.aventura.id).then(() => {
                    props.adventure.aventura.seFavorita = "N";
                })
            }
        }

        forceUpdate();
    };

    const followOrUnfollow = async (event: any, followingOrUnfollowing: boolean) => {
        if(followingOrUnfollowing){
            setSeSeguindo(true);
            seguirCardsIguais(event.idCliente);
            const response = await saveDataFollow(event)
            if(response.status == 200) {
                props.adventure.seSeguindo = "S"
            }
        } else {
            setSeSeguindo(false);
            naoSeguirCardsIguais(event.idCliente);
            const response = await saveDataUnFollow(event)
            if(response.status == 200) {
                props.adventure.seSeguindo = "N"
            }
        }
        forceUpdate();
    }

    function handleLike() {
        setSeCurtido(true)
        api.post("/WS/ClienteAventura/" + props.adventure.id + "/Curtir", null)
        .then(() => {})
    }

    function handleDislike(){
        setSeCurtido(false);
        api.post("/WS/ClienteAventura/" + props.adventure.id + "/Descurtir", null)
        .then(() => {})
    }

    const handleClickRating = async (adventureId: any) => {
        const response = await getDataRating(adventureId)
        setListRating(response.data)
    }


    return (
        <>
        {/* @ts-ignore */}
            <Dialog header="Comentarios" visible={visibleModalComentarios} style={{ width: '50vw' }} onHide={() => setVisibleModalComentarios(!visibleModalComentarios) }>
                { listRating.length ? (
                    listRating.map(item => {
                        return (
                            <>
                                <div style={{ borderBottom: '1px solid whitesmoke' }}>
                                <br/>
                                {/* @ts-ignore */}
                                    <Card.ProfileImage url={ item.urlFotoCliente || "../assets/perfil-default.png"}/>
                                    <Card.TextHeaderProfile>
                                        {/* @ts-ignore */}
                                        Nota: { item?.notaAvaliacao }
                                    </Card.TextHeaderProfile> <br/>
                                    {/* @ts-ignore */}
                                    <Card.Title>{ item?.nomeCliente + ' - ' + item?.dataAvaliacao }</Card.Title>
                                    <br/>
                                    <Card.TextHeaderProfile>
                                        {/* @ts-ignore */}
                                        { item?.descricaoAvaliacao }
                                    </Card.TextHeaderProfile>
                                </div>
                            </>
                        )
                    })
                ) : 'Nenhum comentario' }
            </Dialog>
            <Card.CardContent align="top">
                <Card.ProfileImage url={ props.adventure.urlFotoCliente || "/assets/perfil-default.png"}/>
                <Card.InfoContainerHeaderProfile>
                    <Card.Text style={{ marginLeft: '10px' }}> { props.adventure.nome } </Card.Text>
                </Card.InfoContainerHeaderProfile>
                {seSeguindo && props.adventure.seSeguindo == "S" ? (
                    <Card.Button colorSite="" color="" onClick={() => followOrUnfollow(props.adventure, false)}> Seguindo </Card.Button>
                ) : (
                    <Card.Button colorSite="#0084B9" color="white" onClick={() => followOrUnfollow(props.adventure, true)}> Seguir </Card.Button>
                )}
            </Card.CardContent>

            <Link href={`/adventure-details/${props.adventure.aventura.id}/${props.adventure?.aventura.slug}`} passHref>
                <Card.Wrapper>
                    <Card.FavoriteContainer onClick={(event) => handleFavoriteOrDesfavorite(event)}>
                        {props.adventure.aventura.seFavorita === "S" ? (
                            <FullHeart width={24} height={26} />
                        ) : (
                            <Heart fill={"#FFFFFF"} width={24} height={26} />
                        )}
                    </Card.FavoriteContainer>

                    {props.adventure?.aventura.avaliacao && !isNaN(props.adventure?.aventura.avaliacao) && (
                    <Card.RatingContainer>
                        <Star />
                        <Card.Text>{parseFloat(props.adventure?.aventura.avaliacao?.toString()).toFixed(1)}</Card.Text>
                    </Card.RatingContainer>
                    )}

                    <Card.Image url={props.adventure?.aventura.urlFoto}>
                        <Card.Element>
                            <ElementTag adventureType={props.adventure?.aventura.tipo}></ElementTag>
                        </Card.Element>
                    </Card.Image>
                    <Card.InfoContainer>
                        <Card.Title>{props.adventure?.aventura.titulo}</Card.Title>
                        <Card.Text>
                            {t("where")}: {props.adventure?.aventura.local}
                        </Card.Text>
                    </Card.InfoContainer>
                </Card.Wrapper>
            </Link>

            <Card.CardContent align="bottom">
                <div>
                    { seCurtido == false && (<Image onClick={handleLike} src={LikeRegular} alt="like"/>) }
                    { seCurtido == true && (<Image onClick={handleDislike} src={LikeSolid} alt="dislike"/>) }
                </div>
                <div onClick={() => setVisibleModalComentarios(!visibleModalComentarios)}>
                    <Image src={CommentImg} onClick={() => handleClickRating(props.adventure?.aventura?.id)} />
                    <Card.Text> { props.adventure?.aventura?.quantidadeAvaliacoes } </Card.Text>
                </div>
            </Card.CardContent>
        </>
    );
}

export default React.memo(CardAdventureCommunity);