import styled from 'styled-components';
import { transparentize } from 'polished';

export const Image = styled.div<{ url: string }>`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 69%;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-top-left-radius: ${(p) => p.theme.borderRadius};
  border-top-right-radius: ${(p) => p.theme.borderRadius};
`;

export const FavoriteContainer = styled.div`
  position: absolute;
  right: 8px;
  top: 8px;
  cursor: pointer;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 10;
`;

export const RatingContainer = styled(FavoriteContainer)`
  left: 8px;
  top: 8px;
  max-width: 55px;
  height: 22px;
  background-color: ${(p) => p.theme.activeElementBackground};
  border-radius: ${(p) => p.theme.borderRadius};
  padding: 5px;
  justify-content: space-around;
`;

export const Element = styled(FavoriteContainer)`
  right: 8px;
  top: 195px;
  width: 60px;
`;

export const Wrapper = styled.div`
  border-radius: ${(p) => p.theme.borderRadius};
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  width: 100%;
  min-height: 320px;
  color: ${(p) => p.theme.pageForeground};
  position: relative;

  transition: 0.25s ease;
  * {
    transition: 0.25s ease;
  }

  &:hover,
  &:focus {
    box-shadow: 0 0 0 4px
      ${(p) => transparentize(0.7, p.theme.primaryBackground)};
    outline: none;
    * {
      color: ${(p) => p.theme.primaryForeground};
    }

    ${Image} {
      height: 100%;
      border-radius: ${(p) => p.theme.borderRadius};
    }

    ${RatingContainer},
    ${Element} {
      text {
        color: ${(p) => p.theme.pageForeground};
      }
    }
  }
`;

export const TitleContainer = styled.div`
  background-color: rgba(0, 0, 0, 0.5);
  color: #fff;
  text-align: center;
  right: 8px;
  top: 8px;
  top: 100px;
  width: 250px;
  line-height: 30px;
  height: 30px;
`;

export const InfoContainer = styled.div`
  position: absolute;
  top: 69%;
  width: 65%;
  height: 30%;
  padding: 10px 10px;
  display: flex;
  flex-direction: column;
`;

export const InfoAccomplishedContainer = styled.div`
  position: absolute;
  top: 88%;
  width: 65%;
  height: 30%;
  padding: 10px 10px;
  display: flex;
  flex-direction: column;
  gap: 10px;
`;

export const ButtonAction = styled.button`
  background-color: ${(p) => p.theme.primaryBackground};
  border-radius: ${(p) => p.theme.borderRadius};
  cursor: pointer;
  padding: 8px;
  margin: 8px;
  border: none;
  color: #fff;

  .text {
    font: normal normal normal 14px/20px Poppins;
  }
`;

export const Title = styled.text`
  text-align: left;
  font: normal normal 600 16px/14px Poppins;
  letter-spacing: 0.2px;
  line-height: 1.1;
  color: ${(p) => p.theme.pageForeground};
`;

export const Text = styled(Title)`
  font: normal normal normal 14px/14px Poppins;
  margin-top: 10px;
`;

export const PriceContainer = styled(InfoContainer)`
  width: 35%;
  right: 0;
  padding-left: 0;
`;

export const ButtonGroup = styled.div`
  position: absolute;
  z-index: 1000;
  display: flex;
  flex-direction: column;
  gap: 5px;
  min-height: 320px;
  justify-content: center;
  margin-left: 8px;
`;

export const ButtonConfig = styled.button`
  background-color: ${(p) => p.theme.pageBackground};
  border-radius: 4px;
  display: flex;
  justify-content: center;
  align-items: center;
  color: ${(p) => p.theme.primaryBackground};
  cursor: pointer;
  padding: 1px 10px;
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  width: 100%;
  height: 30px;
  font: normal normal normal 11px Poppins;

  :hover {
    background-color: ${(p) => p.theme.primaryBackground};
    color: ${(p) => p.theme.primaryForeground};
  }

  :active {
    opacity: 0.5;
  }

  :disabled {
    background-color: ${(p) => p.theme.inactiveElementBackground};
    color: ${(p) => p.theme.inactiveElementForeground};
    opacity: 1;
    cursor: no-drop;
    :active {
      opacity: 1;
    }
  }
`;

export const InputGroup = styled.div<{ inputs: number }>`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${(p) => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;