import { transparentize } from "polished";
import React, { ButtonHTMLAttributes } from "react";
import styled, { useTheme } from "styled-components";

interface ButtonProps extends ButtonHTMLAttributes<HTMLButtonElement> {
  color?: string;
  text: string;
  sizeText?: number;
}

export default function Button({ text, color, ...rest }: ButtonProps) {
  const theme = useTheme();

  return (
    <Wrapper>
      <CustomButton color={color ? color : theme.primaryBackground} {...rest}>
        <>
          <p className="text">{text}</p>
        </>
      </CustomButton>
    </Wrapper>
  );
}

const Wrapper = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 100%;
  color: ${(p) => p.theme.primaryForeground};
  cursor: pointer;

  max-height: 50px;
`;

const CustomButton = styled.button<{ sizeText?: number }>`
  padding: 0;
  border: none;
  background: none;
  outline: none;
  background-color: ${(p) => p.color};
  border-radius: ${(p) => p.theme.borderRadius};
  display: flex;
  justify-content: center;
  align-items: center;
  color: ${(p) => p.theme.primaryForeground};
  cursor: pointer;
  padding: 12.5px;
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  width: 100%;
  height: 100%;

  :active {
    opacity: 0.5;
  }

  :disabled {
    background-color: ${(p) => p.theme.inactiveElementBackground};
    color: ${(p) => p.theme.inactiveElementForeground};
    opacity: 1;
    cursor: no-drop;
    :active {
      opacity: 1;
    }
  }

  .text {
    font: normal normal normal ${(p) => p.sizeText || '14'}px/20px Poppins;
  }
`;
