import styled from "styled-components";
import { AutoComplete } from "primereact/autocomplete";

export const Container = styled.div`
  display: flex;
  width: 100%;
  flex-direction: column;
`;

export const InputContainer = styled.div`
  width: 100%;
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: center;
  position: relative;

  svg {
    position: absolute;
    left: 0;
  }
`;

export const Input = styled.input<{ error: boolean }>`
  display: block;
  width: 100%;
  border: none;
  border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.inactiveElementBackground)};
  padding: 6px 12px;
  padding-left: 24px;
  font-size: 14px;
  line-height: 1.42857143;
  outline: none;
  font-family: Poppins;

  :focus {
    border: none;
    border-bottom: 2px solid ${(p) => (p.error ? p.theme.red : p.theme.primaryBackground)};
  }
`;

export const Label = styled.text`
  width: 100%;
  color: ${(p) => p.theme.pageForeground};
  font-size: 14px;
  text-align: left;
  font-weight: 600;
`;

export const ErrorLabel = styled.text`
  width: 100%;
  color: ${(p) => p.theme.red};
  position: absolute;
  font-size: 10px;
  text-align: left;
  bottom: -18px;
`;
