import React, { useRef } from "react";
import { useField } from "formik";
import { ErrorMessage } from "formik";
import { AutoComplete } from "primereact/autocomplete";

import { Container, Label, InputContainer, Input, ErrorLabel } from "./styles";

function Autocomplete(props: any) {
  const [inputProps] = useField(props);
  const inputRef = useRef<any>();

  const TextError = ({ children }: any) => {
    return <ErrorLabel>{children}</ErrorLabel>;
  };

  return (
    <Container className="form-control">
      {props.label && <Label>{props.label}</Label>}

      <InputContainer>
        {props.icon}
        {/* @ts-ignore */}
        <AutoComplete ref={inputRef} {...inputProps} {...props} />
        {/* @ts-ignore */}
        <ErrorMessage name={props.name} component={TextError} />
      </InputContainer>
    </Container>
  );
}

export default Autocomplete;
