"use strict";
(() => {
var exports = {};
exports.id = 495;
exports.ids = [495];
exports.modules = {

/***/ 2576:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ Register),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./src/core/hooks/useFile.ts
var useFile = __webpack_require__(4050);
// EXTERNAL MODULE: ./src/core/utils/exceptions.ts
var exceptions = __webpack_require__(504);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: external "yup-phone"
var external_yup_phone_ = __webpack_require__(7815);
// EXTERNAL MODULE: external "yup-password"
var external_yup_password_ = __webpack_require__(3121);
var external_yup_password_default = /*#__PURE__*/__webpack_require__.n(external_yup_password_);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/password.tsx
var SvgIcons_password = __webpack_require__(3371);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/mail.tsx
var mail = __webpack_require__(4730);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./src/core/hooks/useAuth.ts
var useAuth = __webpack_require__(7471);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
// EXTERNAL MODULE: ./src/core/utils/masks.ts
var masks = __webpack_require__(5069);
// EXTERNAL MODULE: ./src/app/components/FormLoading/index.tsx
var FormLoading = __webpack_require__(9713);
;// CONCATENATED MODULE: external "primereact/checkbox"
const checkbox_namespaceObject = require("primereact/checkbox");
// EXTERNAL MODULE: ./src/app/components/SvgIcons/cellphone.tsx
var cellphone = __webpack_require__(4157);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/user.tsx
var user = __webpack_require__(1475);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/register/styles.ts


const Wrapper = (external_styled_components_default()).div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  border-radius: ${p => p.theme.borderRadius};
  background-color: ${p => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    padding: 5px;
    width: 100%;
  }
`;
const Title = (external_styled_components_default()).text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;
const RegisterImage = (external_styled_components_default()).div`
  width: 130px;
  height: 130px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  input {
    width: 92px;
    height: 92px;
    border-radius: 100px;
    display: none;
  }
`;
const TextContainer = (external_styled_components_default()).div`
  text-align: center;
`;
const Text = (external_styled_components_default()).text`
  font: normal normal normal 16px/25px Poppins;
  text-align: center;
  color: #c3c3c3;
`;
const TextLink = (external_styled_components_default()).a`
  text-decoration: underline;
  color: ${p => p.theme.primaryBackground};
  cursor: pointer;
`;
const ButtonContainer = (external_styled_components_default()).div`
  margin-top: 40px;
`;
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
;// CONCATENATED MODULE: ./src/pages/register/index.tsx



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


























external_yup_password_default()(external_yup_);
function Register() {
  const inputRef = (0,external_react_.useRef)();
  const toastRef = (0,external_react_.useRef)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  const {
    getArchiveByHtmlInput,
    archiveInfos
  } = (0,useFile/* default */.Z)("image");
  const {
    registerUser
  } = (0,useAuth/* default */.Z)();
  const {
    0: buttonLoading,
    1: setButtonLoading
  } = (0,external_react_.useState)(false);
  const {
    0: wantToBeASupplier,
    1: setWantToBeSupplier
  } = (0,external_react_.useState)(false);

  const handleOnImageChnage = event => {
    try {
      getArchiveByHtmlInput(event);
    } catch (error) {
      if (error instanceof exceptions/* ImageError */.YA) {
        util/* Util.showErrorToast */.Z.showErrorToast(toastRef, error.message);
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toastRef, t("onUploadImageError"));
      }
    }
  };

  const passwordConfirmationValidation = senha => {
    if (senha) {
      return true;
    }

    return false;
  };

  const initialValues = {
    name: "",
    email: "",
    cellPhone: "",
    password: "",
    repeatPassword: ""
  };

  const onSubmit = async values => {
    if (buttonLoading) return;
    let body = {
      nome: values.name,
      email: values.email,
      celular: values.cellPhone,
      senha: values.password,
      perfilAtual: wantToBeASupplier ? "E" : "C",
      foto: archiveInfos !== null && archiveInfos !== void 0 && archiveInfos.base64 ? {
        bytes: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.base64,
        nome: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.nome,
        contentType: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.contentType
      } : null,
      //default, vamo pegar a do sistema dps
      linguagemAtual: "pt-BR"
    };
    setButtonLoading(true);

    try {
      await registerUser(body);
      util/* Util.showSucessToast */.Z.showSucessToast(toastRef, t("successAccount"));
      router_default().replace("/home?page=1");
    } catch (error) {
      util/* Util.showErrorToast */.Z.showErrorToast(toastRef, t("registerError"));
    } finally {
      setButtonLoading(false);
    }
  };

  const validationSchema = external_yup_.object({
    name: external_yup_.string().required(t("requiredField")),
    email: external_yup_.string().email(t("invalidEmail")).required(t("requiredField")),
    cellPhone: external_yup_.string().phone("BR", false, t("invalidCellphone")).required(t("requiredField")),
    password: external_yup_.string().password().minUppercase(0).minLowercase(0).minSymbols(0).minNumbers(0).min(6, t("passwordLength")).max(16, t("passwordLength")),
    repeatPassword: external_yup_.string().when("password", {
      is: value => value && value.length > 0,
      then: external_yup_.string().oneOf([external_yup_.ref("password")], t("passwordsMatch")).required(t("requiredField")),
      otherwise: external_yup_.string().notRequired()
    })
  });
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("title", {
        children: ["Relty - ", t("createAccount")]
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(FormLoading/* default */.Z, {
      show: buttonLoading
    }), /*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toastRef,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(Title, {
      children: t("createAccount")
    }), /*#__PURE__*/jsx_runtime_.jsx(RegisterImage, {
      url: (archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.uri) || "/assets/perfil-default.png",
      onClick: () => {
        inputRef.current.click();
      },
      children: /*#__PURE__*/jsx_runtime_.jsx("input", {
        ref: inputRef,
        type: "file",
        onChange: event => {
          handleOnImageChnage(event);
        }
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
      initialValues: initialValues,
      validationSchema: validationSchema,
      onSubmit: values => onSubmit(values),
      validateOnChange: true,
      children: formik => {
        return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
            id: "name",
            name: "name",
            label: t("name"),
            placeholder: "Jo\xE3o Alberto",
            error: formik.errors.name && formik.touched.name,
            onBlur: event => {
              if (passwordConfirmationValidation(formik.values.password)) {
                formik.setFieldTouched("repeatPassword", true, true);
              }
            },
            icon: /*#__PURE__*/jsx_runtime_.jsx(user/* default */.Z, {
              width: 20,
              height: 20
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
            id: "email",
            name: "email",
            label: t("email"),
            placeholder: "example@gmail.com",
            error: formik.errors.email && formik.touched.email,
            onBlur: event => {
              if (passwordConfirmationValidation(formik.values.password)) {
                formik.setFieldTouched("repeatPassword", true, true);
              }
            },
            icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
              width: 20,
              height: 20
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
            id: "cellPhone",
            name: "cellPhone",
            label: t("cellPhone"),
            placeholder: "(99) 9 9999-9999",
            onInput: event => {
              event.nativeEvent.target.value = masks/* masks.brCellphone */.T.brCellphone(event.nativeEvent.target.value);
            },
            error: formik.errors.cellPhone && formik.touched.cellPhone,
            onBlur: event => {
              if (passwordConfirmationValidation(formik.values.password)) {
                formik.setFieldTouched("repeatPassword", true, true);
              }
            },
            icon: /*#__PURE__*/jsx_runtime_.jsx(cellphone/* default */.Z, {
              width: 20,
              height: 20
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
            id: "password",
            name: "password",
            label: t("password"),
            type: "password",
            placeholder: "******",
            error: formik.errors.password && formik.touched.password,
            icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
              width: 20,
              height: 20
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
            id: "repeatPassword",
            name: "repeatPassword",
            label: t("repeatPassword"),
            type: "password",
            placeholder: "******",
            error: formik.errors.repeatPassword && formik.touched.repeatPassword,
            icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
              width: 20,
              height: 20
            })
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
            className: "p-field-checkbox",
            children: [/*#__PURE__*/jsx_runtime_.jsx(checkbox_namespaceObject.Checkbox, {
              inputId: "binary",
              checked: wantToBeASupplier,
              onChange: e => setWantToBeSupplier(e.checked)
            }), /*#__PURE__*/jsx_runtime_.jsx("label", {
              htmlFor: "binary",
              children: t("wantToBeSupplier")
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(TextContainer, {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
              children: [t("youAcceptTerms"), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(TextLink, {
                href: "https://reltyapp.com.br/fornecedores/",
                target: "_blank",
                children: t("supplierTerms")
              }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(TextLink, {
                href: "https://reltyapp.com.br/termos-usuario/",
                target: "_blank",
                children: t("usersTerms")
              })]
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
              text: t("createAccount"),
              disabled: !formik.isValid
            })
          })]
        });
      }
    })]
  });
}
const getServerSideProps = async ctx => {
  const {
    res,
    resolvedUrl
  } = ctx;
  const token = (0,external_nookies_.parseCookies)(ctx).access_token;
  const savedUser = (0,external_nookies_.parseCookies)(ctx).user;

  if (token) {
    util/* Util.sendToHomePage */.Z.sendToHomePage(res);
  }

  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  if (savedUser) {
    let user = JSON.parse(savedUser);
    return util/* Util.sendToAnyPage */.Z.sendToAnyPage(res, `/profiles/${user.perfilAtual == "E" ? "supplier" : "user"}`);
  }

  return {
    props: _objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 3229:
/***/ ((module) => {

module.exports = require("remask");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 3121:
/***/ ((module) => {

module.exports = require("yup-password");

/***/ }),

/***/ 7815:
/***/ ((module) => {

module.exports = require("yup-phone");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5548,4017,5745,5980,7697,3371,37,7471,4993,2966], () => (__webpack_exec__(2576)));
module.exports = __webpack_exports__;

})();