"use strict";
(() => {
var exports = {};
exports.id = 5625;
exports.ids = [5625];
exports.modules = {

/***/ 5100:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ Redirect),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./src/core/services/apiServerSide.ts
var apiServerSide = __webpack_require__(9763);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/redirect-app/styles.ts

const Wrapper = (external_styled_components_default()).div`
  width: 100%;
  height: 100%;
  display: flex;
  justify-content: center;
  padding: 20px;
`;
const Container = (external_styled_components_default()).div`
  display: flex;
  flex: 1;
  flex-direction: column;
  max-width: 600px;
  justify-content: center;
  align-items: center;

  span {
    width: 100%;
    margin-top: 24px;
  }
`;
const Icon = (external_styled_components_default()).div`
  width: 200px;
  background-image: url("/assets/icon.png");
  height: 200px;
  cursor: pointer;
  background-position: center;
  background-size: cover;
`;
const ForgotPassword = (external_styled_components_default()).label`
  color: ${p => p.theme.primaryBackground};
  cursor: pointer;
  text-align: center;

  &:hover {
    text-decoration: underline;
  }
`;
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: external "react-i18next"
var external_react_i18next_ = __webpack_require__(7789);
;// CONCATENATED MODULE: ./src/pages/redirect-app/index.tsx



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











function Redirect({
  adventureId,
  slug,
  imageUrl
}) {
  const {
    t
  } = (0,external_react_i18next_.useTranslation)("common");
  const theme = (0,external_styled_components_.useTheme)();
  const {
    0: isMobile,
    1: setIsMobile
  } = (0,external_react_.useState)(false);
  (0,external_react_.useEffect)(() => {
    setIsMobile(util/* Util.isMobile */.Z.isMobile()); //Caso for um navegador jogamos pra própria pagina da aventura dentro do site.

    if (!util/* Util.isMobile */.Z.isMobile()) {
      router_default().replace(`/adventure-details/${adventureId}/${slug}`);
      return;
    }

    setTimeout(function () {
      //Faz apenas se for iOS.
      if (util/* Util.isMobile */.Z.isMobile() && util/* Util.isAndroid */.Z.isAndroid()) {
        window.location.href = "https://relty.app.link/";
      }

      return;
    }, 400);
    window.location.href = `relty://?aventuraid=${adventureId}`;
  }, []);

  const getApp = () => {
    window.location.href = "https://relty.app.link/";
  };

  const goToHome = () => {
    router_default().replace("/home");
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/jsx_runtime_.jsx("meta", {
        property: "og:image",
        content: imageUrl
      })
    }), isMobile && /*#__PURE__*/(0,jsx_runtime_.jsxs)(Container, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(Icon, {}), /*#__PURE__*/jsx_runtime_.jsx("span", {
        children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          onClick: getApp,
          text: t("getApp")
        })
      }), /*#__PURE__*/jsx_runtime_.jsx("span", {
        children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          onClick: goToHome,
          color: theme.secondaryBackground,
          text: t("home")
        })
      })]
    })]
  });
}
const getServerSideProps = async ctx => {
  var _adventureDetail$data, _adventureDetail$data2;

  console.log('passei aqui ===>', ctx);
  const {
    query
  } = ctx;
  const {
    adventureId: _adventureId
  } = query;
  const adventureId = Number(_adventureId);
  const api = (0,apiServerSide/* getApi */.ac)(ctx);

  if (!adventureId || isNaN(adventureId) || adventureId < 1) {
    return {
      notFound: true
    };
  }

  const adventureDetail = await api.get(`/WS/Aventura/Completa/${adventureId}`);
  return {
    props: _objectSpread(_objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"])), {}, {
      adventureId,
      slug: adventureDetail.data.slug,
      imageUrl: (_adventureDetail$data = adventureDetail.data) === null || _adventureDetail$data === void 0 ? void 0 : (_adventureDetail$data2 = _adventureDetail$data.imagens[0]) === null || _adventureDetail$data2 === void 0 ? void 0 : _adventureDetail$data2.link
    })
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5548,4017], () => (__webpack_exec__(5100)));
module.exports = __webpack_exports__;

})();