"use strict";
(() => {
var exports = {};
exports.id = 6194;
exports.ids = [6194];
exports.modules = {

/***/ 6718:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ overview),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "next/dist/shared/lib/head"
var head_ = __webpack_require__(4190);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: ./src/app/components/Content/index.tsx
var Content = __webpack_require__(5490);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/overview/styles.ts


const Row = (external_styled_components_default()).div`
    display: grid;
    position: relative;
    grid-template-columns: repeat(${p => p.col || '2'}, 1fr);
    justify-content: center;
    align-items: center;
    margin: auto;
    flex-direction: row;
    gap: 10px;
    padding: 10px 10px;
    max-width: 100%;

    @media screen and (max-width: 450px) {
        grid-template-columns: repeat(1, 1fr);
    }
`;
const Column = (external_styled_components_default()).div`
    
    text-align: center;
    display: flex;
    width: 100%;
    flex-direction: column;
    padding: 10px 10px;
    align-itens: center;

    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    border-radius: ${p => p.theme.borderRadius};
    background-color: ${p => p.theme.activeElementBackground};
`;
const Container = (external_styled_components_default()).div`
    display: flex;
    width: 100%;
    justify-content: center;
`;
const ContainerText = (external_styled_components_default()).div`
    flex-direction: column;
    width: 100%;
    justify-content: center;
    display: grid;
`;
const Text = (external_styled_components_default()).text`
    font: normal normal ${p => p.fontWeight || 'normal'} ${p => p.fontSize || 16}px Poppins;
    margin: 20px 0;
    text-align: center;
`;
const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const NoData = (external_styled_components_default()).div`
    margin: auto;
    margin-top: 50px;

    h2 {
        text-align: center;
    }
`;
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
// EXTERNAL MODULE: ./src/app/components/CustomInput/styles.ts
var styles = __webpack_require__(2601);
// EXTERNAL MODULE: ./node_modules/react-icons/fa/index.esm.js
var index_esm = __webpack_require__(9583);
// EXTERNAL MODULE: ./src/app/components/CardAdventure/index.tsx + 1 modules
var CardAdventure = __webpack_require__(1349);
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/overview/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }













const Overview = () => {
  var _overview$receitaTota, _overview$receitaNoPe, _overview$aventuraMai, _overview$aventuraMel;

  const {
    getDataOverview
  } = (0,useEstablishment/* default */.Z)();
  const {
    0: overview,
    1: setOverview
  } = (0,external_react_.useState)({});
  const {
    0: dateInputs,
    1: setDateInputs
  } = (0,external_react_.useState)({
    dataInicial: new Date(new Date().getFullYear(), new Date().getMonth() - 1).toLocaleDateString('pt-br').split("/").reverse().join("-"),
    dataFinal: new Date().toLocaleDateString('pt-br').split("/").reverse().join("-")
  });
  const getDataOverviewDto = (0,external_react_.useCallback)(async dateInputs => {
    const response = await getDataOverview(dateInputs);
    setOverview(response.data);
  }, []);
  (0,external_react_.useEffect)(() => {
    getDataOverviewDto(dateInputs);
  }, [getDataOverviewDto]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)((head_default()), {
      children: [/*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Minhas aventuras"
      }), /*#__PURE__*/jsx_runtime_.jsx("meta", {
        name: "description",
        content: "Relty ativades f\xEDsicas e aventuras"
      }), /*#__PURE__*/jsx_runtime_.jsx("link", {
        rel: "icon",
        href: "/assets/icon.png"
      })]
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Content/* default */.Z, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(Container, {
        children: /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
          children: /*#__PURE__*/jsx_runtime_.jsx(Container, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 24,
              fontWeight: 600,
              children: "Veja seus resultados"
            })
          })
        })
      }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Row, {
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            fontSize: 18,
            fontWeight: 600,
            children: [(overview === null || overview === void 0 ? void 0 : (_overview$receitaTota = overview.receitaTotal) === null || _overview$receitaTota === void 0 ? void 0 : _overview$receitaTota.toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              style: "currency",
              currency: "BRL"
            })) || "-", " "]
          }), /*#__PURE__*/jsx_runtime_.jsx("div", {
            children: " Sua receita total at\xE9 o momento "
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Text, {
            style: {
              margin: "1rem"
            },
            children: " Seu desempenho por per\xEDodo "
          }), /*#__PURE__*/jsx_runtime_.jsx(Row, {
            col: 1,
            style: {
              padding: "0"
            },
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
              inputs: 3,
              style: {
                alignItems: "center"
              },
              children: [/*#__PURE__*/jsx_runtime_.jsx(styles/* Input */.II, {
                type: "date",
                defaultValue: dateInputs.dataInicial,
                onChange: i => setDateInputs(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    dataInicial: i.target.value
                  });
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(styles/* Input */.II, {
                style: {
                  resize: "none"
                },
                type: "date",
                defaultValue: dateInputs.dataFinal,
                onChange: i => setDateInputs(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    dataFinal: i.target.value
                  });
                })
              }), /*#__PURE__*/jsx_runtime_.jsx("div", {
                children: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaSearch */.U41, {
                  size: 22,
                  onClick: () => getDataOverviewDto(dateInputs),
                  style: {
                    cursor: "pointer"
                  }
                })
              })]
            })
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            fontSize: 18,
            fontWeight: 600,
            children: [(overview === null || overview === void 0 ? void 0 : (_overview$receitaNoPe = overview.receitaNoPeriodo) === null || _overview$receitaNoPe === void 0 ? void 0 : _overview$receitaNoPe.toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              style: "currency",
              currency: "BRL"
            })) || "-", " "]
          }), /*#__PURE__*/jsx_runtime_.jsx("div", {
            children: " Receita no periodo "
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            fontSize: 18,
            fontWeight: 600,
            children: [(overview === null || overview === void 0 ? void 0 : overview.vendasNoPeriodo) || "-", " "]
          }), /*#__PURE__*/jsx_runtime_.jsx("div", {
            children: " Aventuras vendidas no periodo "
          })]
        })]
      }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Row, {
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Text, {
            fontSize: 24,
            fontWeight: 600,
            children: "Aventurar mais vendida"
          }), overview !== null && overview !== void 0 && overview.aventuraMaisVendida ?
          /*#__PURE__*/
          //@ts-ignore
          jsx_runtime_.jsx(CardAdventure/* default */.Z, {
            adventure: overview.aventuraMaisVendida
          }) : /*#__PURE__*/jsx_runtime_.jsx(NoData, {
            children: /*#__PURE__*/jsx_runtime_.jsx("p", {
              children: "Nenhum resultado encontrado"
            })
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Text, {
            fontSize: 24,
            fontWeight: 600,
            children: "Aventurar mais favorita"
          }), overview !== null && overview !== void 0 && (_overview$aventuraMai = overview.aventuraMaisFavoritada) !== null && _overview$aventuraMai !== void 0 && _overview$aventuraMai.id ?
          /*#__PURE__*/
          //@ts-ignore
          jsx_runtime_.jsx(CardAdventure/* default */.Z, {
            adventure: overview.aventuraMaisFavoritada
          }) : /*#__PURE__*/jsx_runtime_.jsx(NoData, {
            children: /*#__PURE__*/jsx_runtime_.jsx("p", {
              children: "Nenhum resultado encontrado"
            })
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Column, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Text, {
            fontSize: 24,
            fontWeight: 600,
            children: "Aventurar melhor avaliada"
          }), overview !== null && overview !== void 0 && (_overview$aventuraMel = overview.aventuraMelhorAvaliada) !== null && _overview$aventuraMel !== void 0 && _overview$aventuraMel.id ?
          /*#__PURE__*/
          //@ts-ignore
          jsx_runtime_.jsx(CardAdventure/* default */.Z, {
            adventure: overview.aventuraMelhorAvaliada
          }) : /*#__PURE__*/jsx_runtime_.jsx(NoData, {
            children: /*#__PURE__*/jsx_runtime_.jsx("p", {
              children: "Nenhum resultado encontrado"
            })
          })]
        })]
      })]
    })]
  });
};

/* harmony default export */ const overview = (Overview);
const getServerSideProps = async ctx => {
  const {
    resolvedUrl
  } = ctx;
  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: _objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 9443:
/***/ ((module) => {

module.exports = require("@googlemaps/markerclustererplus");

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 9325:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 4190:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head");

/***/ }),

/***/ 8300:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 5378:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 7162:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 8773:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 2248:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 9372:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 665:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 2747:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 333:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 3456:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 7620:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 1687:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,9583,1664,5548,4017,5745,5980,7697,3371,3802,3976,37,6089,7471,8409,1629,8394,1349,5490], () => (__webpack_exec__(6718)));
module.exports = __webpack_exports__;

})();