"use strict";
(() => {
var exports = {};
exports.id = 9347;
exports.ids = [9347];
exports.modules = {

/***/ 5670:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ NewAdventure),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "axios"
var external_axios_ = __webpack_require__(2376);
var external_axios_default = /*#__PURE__*/__webpack_require__.n(external_axios_);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "primereact/button"
var button_ = __webpack_require__(9982);
// EXTERNAL MODULE: external "primereact/fileupload"
var fileupload_ = __webpack_require__(2832);
// EXTERNAL MODULE: external "primereact/inputswitch"
var inputswitch_ = __webpack_require__(1775);
// EXTERNAL MODULE: external "primereact/listbox"
var listbox_ = __webpack_require__(322);
// EXTERNAL MODULE: external "primereact/tag"
var tag_ = __webpack_require__(9093);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./node_modules/react-icons/cg/index.esm.js
var index_esm = __webpack_require__(471);
// EXTERNAL MODULE: ./node_modules/react-icons/io/index.esm.js
var io_index_esm = __webpack_require__(1649);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: ./src/app/components/FormLoading/index.tsx
var FormLoading = __webpack_require__(9713);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: external "primereact/calendar"
var calendar_ = __webpack_require__(7418);
;// CONCATENATED MODULE: ./src/app/components/ModalDefineTimeSave/ModalDefineTimeSaveNewHours/styles.ts

const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const InputContainer = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
`;
// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__(3804);
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
;// CONCATENATED MODULE: ./src/app/components/ModalDefineTimeSave/ModalDefineTimeSaveNewHours/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










function ModalDefineTimeSaveNewHours(props) {
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const listOption = [{
    key: "Tipo de horário",
    value: 'Typetime'
  }, {
    key: "Por data",
    value: 'DATA'
  }, {
    key: "Semanal",
    value: 'SEMANAL'
  }];
  const {
    getListTimeLocalStorage,
    saveListTimeLocalStorage
  } = (0,useEstablishment/* default */.Z)();
  const listOptionDaysWeek = [{
    key: "Todos os dias",
    value: 'T'
  }, {
    key: "Segunda-feira",
    value: 'MONDAY'
  }, {
    key: "Terça-feira",
    value: 'TUESDAY'
  }, {
    key: "Quarta-feira",
    value: 'WEDNESDAY'
  }, {
    key: "Quinta-feira",
    value: 'THURSDAY'
  }, {
    key: "Sexta-feira",
    value: 'FRIDAY'
  }, {
    key: "Sabado",
    value: 'SATURDAY'
  }, {
    key: "Domingo",
    value: 'SUNDAY'
  }];
  const {
    0: times,
    1: setTimes
  } = (0,external_react_.useState)({});
  const {
    0: visibleTypeDataTime,
    1: setVisibleDataTime
  } = (0,external_react_.useState)("Typetime");
  const {
    0: dates,
    1: setDates
  } = (0,external_react_.useState)();

  const formatStringData = event => {
    if (event != undefined) {
      var _event$toLocaleString;

      const dateTime = (_event$toLocaleString = event.toLocaleString('pt-br')) === null || _event$toLocaleString === void 0 ? void 0 : _event$toLocaleString.split(',');

      if (dateTime) {
        return /*#__PURE__*/jsx_runtime_.jsx("b", {
          style: {
            fontSize: '12px',
            textAlign: 'center'
          },
          children: dateTime[1] ? `A aventura começa dia ${dateTime[0].replace('00:00:00', '')} e termina dia ${dateTime[1].replace('00:00:00', '')}` : `A aventura começa dia ${dateTime[0].replace('00:00:00', '')}`
        });
      }
    }
  };

  const onSubmit = () => {
    const isValid = () => {
      if (times.tipoHorario.includes('DATA')) {
        return dates != [] && times.horarioInicial != null && times.horarioFinal != null && dates[0] != null && dates[1] != null;
      } else if (times.tipoHorario.includes('SEMANAL')) {
        return times.horarioInicial != null && dates[0] != null && dates[1] != null;
      }

      return false;
    };

    if (isValid()) {
      var _dates$, _dates$2;

      let dateInitial = (_dates$ = dates[0]) === null || _dates$ === void 0 ? void 0 : _dates$.toLocaleDateString('pt-br').split('/').reverse().join('-');
      let dateEnd = (_dates$2 = dates[1]) === null || _dates$2 === void 0 ? void 0 : _dates$2.toLocaleDateString('pt-br').split('/').reverse().join('-');
      let listDateLimeLocalStorage = getListTimeLocalStorage();

      if (!(0,external_lodash_.isNull)(dateInitial) && !(0,external_lodash_.isNull)(dateEnd)) {
        if (props.data.id) {
          props.update(times, true);
        } else {
          times.dataInicial = dateInitial;
          times.dataFinal = dateEnd;
          times.id = ++listDateLimeLocalStorage.length;
          times.quantidadePessoas = times.quantidadePessoas ? times.quantidadePessoas : 0;
          props.update(times);
        }

        props.onHide();
      }
    }
  };

  (0,external_react_.useEffect)(() => {
    var _props$data;

    setVisible(props.visible);

    if (visible) {
      setDates([]);
    }

    if ((_props$data = props.data) !== null && _props$data !== void 0 && _props$data.id) {
      setTimes(props.data);
      setVisibleDataTime(props.data.tipoHorario);
    } else {
      setTimes({});
      setVisibleDataTime('Typetime');
    }
  }, [props.visible, props.data]);
  return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
    children: /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: "Hor\xE1rios da aventura",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
        initialValues: [],
        onSubmit: onSubmit,
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
              as: "select",
              label: "Selecione o tipo de hor\xE1rio",
              name: "tipoHorario",
              options: listOption,
              value: visibleTypeDataTime,
              onChange: e => {
                setVisibleDataTime(e.target.value);
                {
                  /* @ts-ignore */
                }
                setTimes(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    tipoHorario: e.target.value
                  });
                });
              }
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
            inputs: 1,
            children: visibleTypeDataTime === 'DATA' && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
              children: [/*#__PURE__*/jsx_runtime_.jsx(calendar_.Calendar, {
                selectionMode: "range",
                minDate: new Date(),
                showButtonBar: true,
                inline: true,
                dateFormat: "dd/mm/yy",
                value: dates,
                onChange: e => setDates(e.target.value)
              }), formatStringData(dates), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
                inputs: 2,
                children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                    label: "Inicio",
                    name: "inicio",
                    mask: "99:99",
                    value: times.horarioInicial || null,
                    onChange: e => {
                      {
                        /* @ts-ignore */
                      }
                      setTimes(prevState => {
                        return _objectSpread(_objectSpread({}, prevState), {}, {
                          horarioInicial: e.target.value
                        });
                      });
                    }
                  })
                }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                    label: "Fim",
                    name: "fim",
                    mask: "99:99",
                    value: times.horarioFinal || null,
                    onChange: e => {
                      {
                        /* @ts-ignore */
                      }
                      setTimes(prevState => {
                        return _objectSpread(_objectSpread({}, prevState), {}, {
                          horarioFinal: e.target.value
                        });
                      });
                    }
                  })
                })]
              }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
                inputs: 1,
                children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                    label: "Quantidade de pessoas",
                    name: "quantidade",
                    type: "number",
                    value: times.quantidadePessoas || 0,
                    onChange: e => {
                      {
                        /* @ts-ignore */
                      }
                      setTimes(prevState => {
                        return _objectSpread(_objectSpread({}, prevState), {}, {
                          quantidadePessoas: e.target.value
                        });
                      });
                    }
                  })
                }), /*#__PURE__*/jsx_runtime_.jsx("p", {
                  style: {
                    fontSize: '10px',
                    textAlign: 'left'
                  },
                  children: " (deixe 0 caso queira que seja aberto) "
                })]
              }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                text: "Salvar",
                type: "button",
                onClick: onSubmit
              })]
            }) || visibleTypeDataTime === 'SEMANAL' && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
              children: [/*#__PURE__*/jsx_runtime_.jsx(calendar_.Calendar, {
                selectionMode: "range",
                minDate: new Date(),
                showButtonBar: true,
                inline: true,
                dateFormat: "dd/mm/yy",
                value: dates,
                onChange: e => setDates(e.target.value)
              }), formatStringData(dates), /*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
                inputs: 1,
                children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                  as: "select",
                  label: "Dias da semana",
                  name: "diasSemana",
                  options: listOptionDaysWeek,
                  value: times.diaSemana || listOptionDaysWeek[0],
                  onChange: e => {
                    {
                      /* @ts-ignore */
                    }
                    setTimes(prevState => {
                      return _objectSpread(_objectSpread({}, prevState), {}, {
                        diaSemana: e.target.value
                      });
                    });
                  }
                })
              }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
                inputs: 2,
                children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                    label: "Inicio",
                    name: "inicio",
                    mask: "99:99",
                    value: times.horarioInicial || null,
                    onChange: e => {
                      {
                        /* @ts-ignore */
                      }
                      setTimes(prevState => {
                        return _objectSpread(_objectSpread({}, prevState), {}, {
                          horarioInicial: e.target.value
                        });
                      });
                    }
                  })
                }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                    type: "number",
                    label: "Quantidade de pessoas",
                    name: "quantidadePessoas",
                    value: times.quantidadePessoas || 0,
                    onChange: e => {
                      {
                        /* @ts-ignore */
                      }
                      setTimes(prevState => {
                        return _objectSpread(_objectSpread({}, prevState), {}, {
                          quantidadePessoas: e.target.value
                        });
                      });
                    }
                  })
                })]
              }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                type: "button",
                text: "Salvar",
                onClick: onSubmit
              })]
            }) || visibleTypeDataTime === 'Typetime' && /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {})
          })]
        })
      })
    })
  });
}
// EXTERNAL MODULE: external "primereact/dataview"
var dataview_ = __webpack_require__(7930);
;// CONCATENATED MODULE: ./src/app/components/ModalDefinedTime/ModalDefineTimeNewHours/index.tsx









function ModalDefineTimeNewHours(props) {
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalDefineTimeSaveNewHours,
    1: setVisibleModalDefineTimeSaveNewHours
  } = (0,external_react_.useState)(false);
  const {
    0: times,
    1: setTimes
  } = (0,external_react_.useState)([]);
  const {
    getListTimeLocalStorage,
    saveListTimeLocalStorage
  } = (0,useEstablishment/* default */.Z)();
  const {
    0: dataListTimes
  } = (0,external_react_.useState)({});

  const updateTimesList = event => {
    let listDateTimeLocalStorage = getListTimeLocalStorage();
    listDateTimeLocalStorage.push(event);
    saveListTimeLocalStorage(listDateTimeLocalStorage);

    if (listDateTimeLocalStorage) {
      setTimes(listDateTimeLocalStorage);
    } else {
      setTimes([]);
    }
  };

  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    let listDateTimeLocalStorage = getListTimeLocalStorage();
    saveListTimeLocalStorage(listDateTimeLocalStorage);

    if (listDateTimeLocalStorage == null) {
      setTimes([]);
    } else {
      setTimes(listDateTimeLocalStorage);
    }
  }, [props.visible]);

  const deleteTime = item => {
    let listDateTimeLocalStorage = getListTimeLocalStorage();
    {
      /* @ts-ignore */
    }
    listDateTimeLocalStorage = listDateTimeLocalStorage.filter(i => i.id != item.id);
    saveListTimeLocalStorage(listDateTimeLocalStorage);
    setTimes(listDateTimeLocalStorage);
  };

  const itemTemplate = item => {
    var _item$dataInicial, _item$dataInicial2, _item$dataFinal;

    const renderDayName = dayWeek => {
      if (dayWeek === 'MONDAY') {
        return 'Segunda-feira';
      } else if (dayWeek === 'TUESDAY') {
        return 'Terça-feira';
      } else if (dayWeek === 'WEDNESDAY') {
        return 'Quarta-feira';
      } else if (dayWeek === 'THURSDAY') {
        return 'Quinta-feira';
      } else if (dayWeek === 'FRIDAY') {
        return 'Sexta-feira';
      } else if (dayWeek === 'SATURDAY') {
        return 'Sabado';
      } else if (dayWeek === 'SUNDAY') {
        return 'Domingo';
      } else {
        return '-';
      }
    };

    return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        className: "p-col-6",
        style: {
          marginTop: '10px'
        },
        children: [item.tipoHorario == "SEMANAL" ? /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("b", {
            children: [" ", item.diaSemana == 'T' ? 'Todos os dias' : renderDayName(item.diaSemana) || 'Todos os dias', " "]
          })
        }) : /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("b", {
            children: [" ", (_item$dataInicial = item.dataInicial) === null || _item$dataInicial === void 0 ? void 0 : _item$dataInicial.split('-').reverse().join('/'), " \xE0 ", item.dataFinal.split('-').reverse().join('/'), " "]
          })
        }), /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("small", {
            children: [" Hor\xE1rio inicial: ", (_item$dataInicial2 = item.dataInicial) === null || _item$dataInicial2 === void 0 ? void 0 : _item$dataInicial2.split('-').reverse().join('/'), " \xE0s ", item.horarioInicial, " "]
          })
        }), /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("small", {
            children: [" Hor\xE1rio inicial: ", (_item$dataFinal = item.dataFinal) === null || _item$dataFinal === void 0 ? void 0 : _item$dataFinal.split('-').reverse().join('/'), " \xE0s ", item.horarioFinal, " "]
          })
        }), /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("small", {
            children: [" Pessoas: ", item.quantidadePessoas || 'Aberto', " "]
          })
        })]
      }), /*#__PURE__*/jsx_runtime_.jsx("div", {
        className: "p-col-6",
        style: {
          marginTop: '18px'
        },
        children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          text: "Excluir",
          onClick: () => deleteTime(item)
        })
      })]
    });
  };

  return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
    children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Hor\xE1rios da aventura",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/jsx_runtime_.jsx(ModalDefineTimeSaveNewHours, {
        visible: visibleModalDefineTimeSaveNewHours,
        data: dataListTimes,
        update: event => updateTimesList(event),
        style: {
          width: '50vw'
        },
        onHide: () => {
          setVisibleModalDefineTimeSaveNewHours(!visibleModalDefineTimeSaveNewHours);
        }
      }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
        text: "Novo hor\xE1rio",
        onClick: () => {
          setVisibleModalDefineTimeSaveNewHours(!visibleModalDefineTimeSaveNewHours);
        }
      }), times.length ? /*#__PURE__*/jsx_runtime_.jsx(dataview_.DataView, {
        value: times,
        itemTemplate: itemTemplate,
        header: /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: " Lista de hor\xE1rios "
        })
      }) : /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {})]
    })
  });
}
// EXTERNAL MODULE: ./src/core/contexts/GeolocationContext.tsx
var GeolocationContext = __webpack_require__(382);
// EXTERNAL MODULE: ./src/core/hooks/useAdventure.ts
var useAdventure = __webpack_require__(3802);
// EXTERNAL MODULE: ./src/core/hooks/useMap.ts
var useMap = __webpack_require__(3046);
// EXTERNAL MODULE: ./src/core/hooks/useMasks.ts
var useMasks = __webpack_require__(4918);
// EXTERNAL MODULE: ./src/core/utils/masks.ts
var masks = __webpack_require__(5069);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/adventures/create/styles.ts


const Wrapper = (external_styled_components_default()).div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  border-radius: ${p => p.theme.borderRadius};
  background-color: ${p => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    width: 100%;
    padding: 5px;
  }
`;
const styles_InputGroup = (external_styled_components_default()).div`
  display: grid;
  width: 100%;
  justify-content: center;
  flex-wrap: wrap;
  gap: 10px;

  @media screen and (min-width: 768px) {
    grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
  }

  @media screen and (max-width: 768px) {
    display: flex;
    justify-content: center;
    align-items: center;
  }
`;
const styles_InputContainer = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  justify-content: flex-start;
`;
const ButtonContainer = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  margin-top: 20px;
  justify-content: center;
  align-items: center;

  button{
    margin: 10px
  }
`;
const ContainerText = (external_styled_components_default()).div`
  display: flex;
  flex-direction: row;
  width: 100%;
  justify-content: center;
`;
const Title = (external_styled_components_default()).text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;
const Text = (external_styled_components_default()).text`
  font: normal normal 600 ${p => p.fontSize || 16}px Poppins;
  margin: 20px 0;
  text-align: center;
`;
const MapContainer = (external_styled_components_default()).div`
  width: 100%;
  height: 300px;
  margin-bottom: 1rem;
  border-radius: ${p => p.theme.borderRadius};
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.7, p.theme.pageForeground)};

  @media screen and (max-width: 767px) {
    height: 300px;
  }
`;
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/adventures/create/index.tsx




function create_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function create_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { create_ownKeys(Object(source), true).forEach(function (key) { create_defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { create_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function create_defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






























function NewAdventure() {
  const {
    t
  } = (0,external_next_i18next_.useTranslation)('common');
  const {
    mapRef,
    loadMap,
    searchPlaces
  } = (0,useMap/* default */.Z)();
  const {
    lastLocation,
    localizationMaps
  } = (0,GeolocationContext/* useGeolocationContext */.kL)();
  const toastRef = (0,external_react_.useRef)();
  const {
    0: adventureImages,
    1: setAdventureImages
  } = (0,external_react_.useState)([]);
  const {
    0: loading,
    1: setLoading
  } = (0,external_react_.useState)(false);
  const theme = (0,external_styled_components_.useTheme)();
  const {
    0: selectedInclude,
    1: setSelectedInlude
  } = (0,external_react_.useState)([]);
  const {
    0: selectedNotForget,
    1: setSelectedNotForget
  } = (0,external_react_.useState)([]);
  const {
    0: visibleDialogDefinedTimeNewHours,
    1: setVisibleDialogDefinedTimeNewHours
  } = (0,external_react_.useState)(false);
  const {
    0: checked,
    1: setChecked
  } = (0,external_react_.useState)(false);
  const {
    0: checkedDuracao,
    1: setCheckedDuracao
  } = (0,external_react_.useState)(false);
  const {
    getDataCategoria,
    getDataMaterial
  } = (0,useEstablishment/* default */.Z)();
  const {
    0: listType,
    1: setListType
  } = (0,external_react_.useState)([]);
  const {
    money
  } = (0,useMasks/* default */.Z)();
  const {
    0: materialListInclude,
    1: setMaterialListInclude
  } = (0,external_react_.useState)([]);
  const {
    0: materialListNotForget,
    1: setMaterialListNotForget
  } = (0,external_react_.useState)([]);
  const {
    0: includeMaterialImutable,
    1: setIncludeMaterialImutable
  } = (0,external_react_.useState)([]);
  const {
    0: totalSize,
    1: setTotalSize
  } = (0,external_react_.useState)(0);
  const {
    createAdventure
  } = (0,useAdventure/* default */.Z)();
  const dropdownOptions = [{
    key: t('easy'),
    value: 'F'
  }, {
    key: t('medium'),
    value: 'M'
  }, {
    key: t('hard'),
    value: 'D'
  }];
  const parcelaOptions = [{
    key: '1x',
    value: 1
  }, {
    key: '2x',
    value: 2
  }, {
    key: '3x',
    value: 3
  }, {
    key: '4x',
    value: 4
  }, {
    key: '5x',
    value: 5
  }, {
    key: '6x',
    value: 6
  }, {
    key: '7x',
    value: 7
  }, {
    key: '8x',
    value: 8
  }, {
    key: '9x',
    value: 9
  }, {
    key: '10x',
    value: 10
  }, {
    key: '11x',
    value: 11
  }, {
    key: '12x',
    value: 12
  }];
  const listEstados = [{
    key: 'São Paulo, SP',
    value: 'São Paulo, SP'
  }, {
    key: 'Paraná, PR',
    value: 'Paraná, PR'
  }, {
    key: 'Santa Catarina, SC',
    value: 'Santa Catarina, SC'
  }, {
    key: 'Rio Grande do Sul, RS',
    value: 'Rio Grande do Sul, RS'
  }, {
    key: 'Mato Grosso do Sul, MS',
    value: 'Mato Grosso do Sul, MS'
  }, {
    key: 'Rondônia, RO',
    value: 'Rondônia, RO'
  }, {
    key: 'Acre, AC',
    value: 'Acre, AC'
  }, {
    key: 'Amazonas, AM',
    value: 'Amazonas, AM'
  }, {
    key: 'Roraima, RR',
    value: 'Roraima, RR'
  }, {
    key: 'Pará, PA',
    value: 'Pará, PA'
  }, {
    key: 'Amapá, AP',
    value: 'Amapá, AP'
  }, {
    key: 'Tocantins, TO',
    value: 'Tocantins, TO'
  }, {
    key: 'Maranhão, MA',
    value: 'Maranhão, MA'
  }, {
    key: 'Rio Grande do Norte, RN',
    value: 'Rio Grande do Norte, RN'
  }, {
    key: 'Paraíba, PB',
    value: 'Paraíba, PB'
  }, {
    key: 'Pernambuco, PE',
    value: 'Pernambuco, PE'
  }, {
    key: 'Alagoas, AL',
    value: 'Alagoas, AL'
  }, {
    key: 'Sergipe, SE',
    value: 'Sergipe, SE'
  }, {
    key: 'Bahia, BA',
    value: 'Bahia, BA'
  }, {
    key: 'Minas Gerais, MG',
    value: 'Minas Gerais, MG'
  }, {
    key: 'Rio de Janeiro, RJ',
    value: 'Rio de Janeiro, RJ'
  }, {
    key: 'Mato Grosso, MT',
    value: 'Mato Grosso, MT'
  }, {
    key: 'Goiás, GO',
    value: 'Goiás, GO'
  }, {
    key: 'Distrito Federal, DF',
    value: 'Distrito Federal, DF'
  }, {
    key: 'Piauí, PI',
    value: 'Piauí, PI'
  }, {
    key: 'Ceará, CE',
    value: 'Ceará, CE'
  }, {
    key: 'Espírito Santo, ES',
    value: 'Espírito Santo, ES'
  }];

  const InputSwitchCustomMetrosQuilometros = props => {
    return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        style: {
          display: 'flex',
          flexDirection: 'row',
          alignItems: 'center'
        },
        children: [/*#__PURE__*/jsx_runtime_.jsx("p", {
          children: props.label
        }), " \xA0 \xA0 \xA0", ' ', /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
          checked: checked,
          onChange: e => setChecked(oldValue => !oldValue)
        })]
      })
    });
  };

  const InputSwitchCustomDiasHoras = props => {
    return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        style: {
          display: 'flex',
          flexDirection: 'row',
          alignItems: 'center'
        },
        children: [/*#__PURE__*/jsx_runtime_.jsx("p", {
          children: props.label
        }), " \xA0 \xA0 \xA0", ' ', /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
          checked: checkedDuracao,
          onChange: e => setCheckedDuracao(oldValue => !oldValue)
        })]
      })
    });
  };

  const initialMap = () => {
    loadMap(lastLocation, () => {});
  };

  const getCategoria = (0,external_react_.useCallback)(async () => {
    const response = await getDataCategoria();
    setListType(response.data.map(category => {
      return create_objectSpread(create_objectSpread({}, category), {}, {
        key: category.nome,
        value: category.id
      });
    }));
  }, [setListType]);
  const getMaterial = (0,external_react_.useCallback)(async () => {
    const response = await getDataMaterial();
    setMaterialListInclude(response.data);
    setMaterialListNotForget(response.data);
    setIncludeMaterialImutable(response.data);
  }, []);
  (0,external_react_.useEffect)(() => {
    initialMap();
    getCategoria();
    getMaterial();
  }, []);
  (0,external_react_.useEffect)(() => {
    filterListMaterialNotForget(selectedInclude);
    filterListMaterialInclude(selectedNotForget);
  }, [selectedNotForget, selectedInclude]);

  const filterListMaterialNotForget = selectedInclude => {
    if (selectedInclude) {
      let listId = selectedInclude.map(i => i.id);
      let filterItem = includeMaterialImutable.filter( // @ts-ignore 
      y => !listId.includes(y.id));
      setMaterialListNotForget(filterItem);
    }
  };

  const filterListMaterialInclude = selectedInclude => {
    if (selectedInclude) {
      let listId = selectedInclude.map(i => i.id);
      let filterItem = includeMaterialImutable.filter( // @ts-ignore
      y => !listId.includes(y.id));
      setMaterialListInclude(filterItem);
    }
  };

  const onTemplateRemove = (file, callback) => {
    let filteredImages = adventureImages.filter(image => image.nome != file.name);
    setAdventureImages(filteredImages);
    setTotalSize(totalSize - file.size);
    callback();
  };

  const onSubmit = async event => {
    console.log('event ===>', event); // @ts-ignore

    event.categoria = event.categoria ? event.categoria : listType[0].value;
    event.nivel = event.nivel ? event.nivel : dropdownOptions[0].value;
    event.parcelas = event.parcelas ? event.parcelas : parcelaOptions[0].value;
    let horarios = window.sessionStorage.getItem('horarios');
    horarios = horarios ? JSON.parse(horarios) : []; // if (!localizationMaps)
    //   return Util.showErrorToast(
    //     toastRef,
    //     'Erro: Selecione um local no mapa antes de prosseguir!'
    // );

    if (adventureImages.length == 0) return util/* Util.showErrorToast */.Z.showErrorToast(toastRef, 'Erro: Selecione ao menos 1 imagem para sua aventura!');
    if (!horarios || horarios.length == 0) return util/* Util.showErrorToast */.Z.showErrorToast(toastRef, 'Erro: É necessário definir ao menos um horário para a Aventura!');
    const body = {
      categoria: listType.find(item => item.id == event.categoria),
      descricao: event.detalhes,
      duracao: event.duracao,
      endereco: {
        bairro: event.endereco.bairro,
        cep: event.endereco.cep,
        cidade: event.local,
        complemento: event.endereco.complemento,
        latitude: localizationMaps === null || localizationMaps === void 0 ? void 0 : localizationMaps.lat,
        longitude: localizationMaps === null || localizationMaps === void 0 ? void 0 : localizationMaps.lng,
        numero: event.endereco.numero,
        rua: event.endereco.rua,
        uf: event.endereco.uf
      },
      horarios: horarios,
      horasCompraAntecedencia: event.horasCompraAntecedencia,
      imagens: adventureImages.map(img => {
        return {
          bytes: img.bytes,
          imagem: img
        };
      }),
      local: event.local,
      materiais: selectedNotForget.map(material => {
        return {
          material: material,
          tipoMaterial: 'O'
        };
      }).concat(selectedInclude.map(material => {
        return {
          material: material,
          tipoMaterial: 'I'
        };
      })),
      nivel: event.nivel,
      percurso: event.percurso,
      preco: event.preco.replace('R$', '').replace('.', '').replace(',', '.'),
      quantidadeParcela: event.parcelas,
      tipoDuracao: checkedDuracao ? 'HORAS' : 'DIAS',
      tipoPercurso: checked ? 'QUILOMETROS' : 'METROS',
      titulo: event.titulo
    };

    try {
      await createAdventure(body);
      util/* Util.showSucessToast */.Z.showSucessToast(toastRef, 'Aventura criada com sucesso!');
      window.location.href = '/profiles/supplier/adventures';
    } catch (e) {
      util/* Util.showErrorToast */.Z.showErrorToast(toastRef, 'Erro ao criar aventura!');
    }
  };

  const actualizeCep = async (cep, formik) => {
    external_axios_default().get('https://viacep.com.br/ws/' + cep + '/json/').then(response => {
      if (!response.data) return console.log('Erro, ');
      if (response.data.error) return console.log('Cep inválido');
      let {
        logradouro,
        bairro,
        uf
      } = response.data;
      formik.setFieldValue('endereco.rua', logradouro);
      formik.setFieldValue('endereco.bairro', bairro);
      formik.setFieldValue('endereco.uf', uf);
    });
  };

  const chooseOptions = {
    icon: 'pi pi-fw pi-images',
    iconOnly: true,
    className: 'custom-choose-btn p-button-rounded p-button-outlined'
  };
  const uploadOptions = {
    icon: 'pi pi-fw pi-cloud-upload',
    iconOnly: true,
    style: {
      display: 'none'
    },
    className: 'custom-upload-btn p-button-success p-button-rounded p-button-outlined'
  };
  const cancelOptions = {
    icon: 'pi pi-fw pi-times',
    iconOnly: true,
    className: 'custom-cancel-btn p-button-danger p-button-rounded p-button-outlined'
  };

  const invoiceUploadHandler = ({
    files
  }) => {
    console.log('invoiceUploadHandler ==>', files);
    const [file] = files;
    const fileReader = new FileReader();

    fileReader.onload = e => {
      var _e$target;

      let result = e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result;
      let image = {
        bytes: result.split(',')[1],
        nome: file.name,
        contentType: result.split(';')[0].split(':')[1]
      };
      setAdventureImages(adventureImages.concat(image));
    };

    fileReader.readAsDataURL(file);
  };

  const onTemplateClear = () => {
    setAdventureImages([]);
  };

  const itemTemplate = (file, props) => {
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
      className: "p-d-flex p-ai-center p-flex-wrap",
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        className: "p-d-flex p-ai-center",
        style: {
          width: '40%'
        },
        children: [/*#__PURE__*/jsx_runtime_.jsx("img", {
          alt: file.name,
          role: "presentation",
          src: file.objectURL,
          width: 100
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)("span", {
          className: "p-d-flex p-dir-col p-text-left p-ml-3",
          children: [file.name, /*#__PURE__*/jsx_runtime_.jsx("small", {
            children: new Date().toLocaleDateString()
          })]
        })]
      }), /*#__PURE__*/jsx_runtime_.jsx(tag_.Tag, {
        value: props.formatSize,
        severity: "warning"
      }), /*#__PURE__*/jsx_runtime_.jsx(button_.Button, {
        icon: "pi pi-times",
        className: "p-button-outlined p-button-rounded p-button-danger p-ml-auto",
        onClick: () => onTemplateRemove(file, props.onRemove)
      })]
    });
  };

  const emptyTemplate = () => {
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
      className: "p-d-flex p-ai-center p-dir-col",
      children: [/*#__PURE__*/jsx_runtime_.jsx("i", {
        className: "pi pi-image p-mt-3 p-p-5",
        style: {
          fontSize: '5em',
          borderRadius: '50%',
          backgroundColor: 'var(--surface-b)',
          color: 'var(--surface-d)'
        }
      }), /*#__PURE__*/jsx_runtime_.jsx("span", {
        style: {
          fontSize: '1.2em',
          color: 'var(--text-color-secondary)'
        },
        className: "p-my-5",
        children: "Arraste e solte a imagem aqui"
      })]
    });
  };

  const initialValues = {
    categoria: '',
    nivel: '',
    titulo: '',
    local: '',
    preco: '',
    horasCompraAntecedencia: '',
    parcelas: '',
    duracao: '',
    percurso: '',
    detalhes: '',
    endereco: {
      cep: '',
      rua: '',
      bairro: '',
      uf: '',
      numero: '',
      complemento: ''
    }
  };
  const validationSchema = external_yup_.object({
    titulo: external_yup_.string().required(t('requiredField')),
    local: external_yup_.string().required(t('requiredField')),
    preco: external_yup_.string().required(t('requiredField')).test('É maior que R$0,00', 'O valor deve ser maior que R$0,00', value => {
      return value != 'R$0,00';
    }),
    horasCompraAntecedencia: external_yup_.number().required(t('requiredField')),
    duracao: external_yup_.number().required(t('requiredField')),
    percurso: external_yup_.number().required(t('requiredField')),
    detalhes: external_yup_.string().required(t('requiredField')),
    endereco: external_yup_.object().shape({
      cep: external_yup_.string().required(t('requiredField')),
      rua: external_yup_.string().required(t('requiredField')),
      bairro: external_yup_.string().required(t('requiredField')),
      uf: external_yup_.string().required(t('requiredField')),
      numero: external_yup_.number().required(t('requiredField')),
      complemento: external_yup_.string()
    })
  });
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Nova Aventura"
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(FormLoading/* default */.Z, {
      show: loading
    }), /*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toastRef,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(Title, {
      children: " Nova Aventura "
    }), /*#__PURE__*/jsx_runtime_.jsx(ModalDefineTimeNewHours, {
      visible: visibleDialogDefinedTimeNewHours,
      onHide: () => {
        setVisibleDialogDefinedTimeNewHours(!visibleDialogDefinedTimeNewHours);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
      initialValues: initialValues,
      validationSchema: validationSchema,
      onSubmit: onSubmit,
      enableReinitialize: true,
      validateOnChange: true,
      validateOnBlur: true,
      children: formik => {
        return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(fileupload_.FileUpload, {
            name: "demo",
            itemTemplate: itemTemplate,
            emptyTemplate: emptyTemplate,
            chooseOptions: chooseOptions,
            uploadOptions: uploadOptions,
            accept: "image/*",
            customUpload: true,
            multiple: true,
            onSelect: invoiceUploadHandler,
            onClear: onTemplateClear,
            cancelOptions: cancelOptions
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 12,
              children: " Recomendamos adicionar at\xE9 7 fotos "
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              children: " Informa\xE7\xF5es "
            })
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              style: {
                flexDirection: 'column'
              },
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                as: "select",
                options: listType,
                name: "categoria",
                label: "Tipo",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdAlbums */.mBw, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                as: "select",
                label: "Nivel",
                options: dropdownOptions,
                name: "nivel",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdTrendingUp */.KN9, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 3,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "tituloAventura",
                type: "name",
                name: "titulo",
                label: "T\xEDtulo da aventura",
                placeholder: "T\xEDtulo da aventura",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoIosAnalytics */.$gl, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputContainer, {
              children: [/*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "municipioAventura",
                list: "categoria",
                name: "local",
                label: "Munic\xEDpio/Estado",
                placeholder: "Munic\xEDpio/Estado",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              }), /*#__PURE__*/jsx_runtime_.jsx("datalist", {
                id: "categoria",
                children: listEstados.map((item, key) => /*#__PURE__*/jsx_runtime_.jsx("option", {
                  value: item.key
                }, key.key))
              })]
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "valorPessoa",
                type: "text",
                name: "preco",
                label: "Valor por pessoa(R$)",
                placeholder: "00,00",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoLogoUsd */.$Ac, {
                  size: 16,
                  color: theme.primaryBackground
                }),
                maxLength: 10,
                onInput: event => {
                  event.nativeEvent.target.value = money(event.target.value).maskedValue;
                }
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              title: "\xC9 o tempo de anteced\xEAncia m\xEDnima que o cliente pode\r comprar sua aventura. Ex: Colocando 24 horas o clinete tem que comprar\r a aventura pelo menos um dia antes de determinado hor\xE1rio",
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                label: "Horas de antecedencia na compra",
                name: "horasCompraAntecedencia",
                placeholder: "24h",
                maxLength: 3,
                onKeyPress: event => {
                  if (event.nativeEvent.target.value.length == 0 && event.key == '0') event.preventDefault();else if (!/[0-9]/.test(event.key)) event.preventDefault();
                },
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdAlarm */.D9x, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                as: "select",
                label: "Quantidade de parcelas permitidas",
                name: "parcelas",
                options: parcelaOptions,
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoIosRemove */.Lqh, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "duracao",
                name: "duracao",
                label: /*#__PURE__*/jsx_runtime_.jsx(InputSwitchCustomDiasHoras, {
                  label: "Dura\xE7\xE3o dias/horas"
                }),
                placeholder: checkedDuracao ? 'Horas' : 'Dias',
                onKeyPress: event => {
                  if (event.nativeEvent.target.value.length == 0 && event.key == '0') event.preventDefault();else if (!/[0-9]/.test(event.key)) event.preventDefault();
                },
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdTime */.xps, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "percuso",
                name: "percurso",
                onKeyPress: event => {
                  if (event.nativeEvent.target.value.length == 0 && event.key == '0') event.preventDefault();else if (!/[0-9]/.test(event.key)) event.preventDefault();
                },
                label: /*#__PURE__*/jsx_runtime_.jsx(InputSwitchCustomMetrosQuilometros, {
                  label: "Percurso metros/quil\xF4metros"
                }),
                placeholder: checked ? 'Km' : 'Metros',
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdWalk */.jKv, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 16,
              style: {
                margin: '0'
              },
              children: "Detalhes da aventura"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
              as: "textarea",
              name: "detalhes",
              label: "Detalhes",
              icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* CgDetailsMore */.bRw, {
                size: 16,
                color: theme.primaryBackground
              })
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 16,
              children: "O que estar\xE1 incluso"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(listbox_.ListBox, {
              value: selectedInclude,
              virtualScrollerOptions: {
                itemSize: 38,
                scrollHeight: '200px'
              },
              options: materialListInclude,
              multiple: true,
              filter: true,
              optionLabel: "descricao",
              onChange: e => setSelectedInlude(e.target.value)
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 16,
              children: "O que n\xE3o pode esquecer"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(listbox_.ListBox, {
              value: selectedNotForget,
              onChange: e => setSelectedNotForget(e.target.value),
              virtualScrollerOptions: {
                itemSize: 38,
                scrollHeight: '200px'
              },
              options: materialListNotForget,
              multiple: true,
              filter: true,
              optionLabel: "descricao"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 16,
              children: "Aonde vamos nos encontrar"
            })
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 3,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.cep",
                label: "CEP",
                placeholder: "CEP",
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.cep */.T.cep(event.nativeEvent.target.value);
                  let cep = event.nativeEvent.target.value;
                  if (cep.length === 9) actualizeCep(cep, formik);
                },
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.rua",
                label: "Rua",
                placeholder: "Rua",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.bairro",
                label: "Bairro",
                placeholder: "Bairro",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
            inputs: 3,
            children: [/*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.uf",
                label: "UF",
                placeholder: "UF",
                maxLength: 2,
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.numero",
                onKeyPress: event => {
                  if (event.nativeEvent.target.value.length == 0 && event.key == '0') event.preventDefault();else if (!/[0-9]/.test(event.key)) event.preventDefault();
                },
                label: "N\xFAmero",
                placeholder: "N\xFAmero",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                type: "text",
                name: "endereco.complemento",
                label: "Complemento",
                placeholder: "Complemento",
                icon: /*#__PURE__*/jsx_runtime_.jsx(io_index_esm/* IoMdHome */.QO$, {
                  size: 16,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(ContainerText, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
              fontSize: 16,
              children: "Confira o PIN no mapa, e ajuste selecionando no mapa"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(styles_InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(MapContainer, {
              ref: mapRef
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            text: "Definir Hor\xE1rio",
            type: "button",
            onClick: () => setVisibleDialogDefinedTimeNewHours(true)
          }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            type: "submit",
            text: "Salvar aventura"
          })]
        });
      }
    })]
  });
}
const getServerSideProps = async ctx => {
  const {
    res,
    resolvedUrl
  } = ctx;
  const token = (0,external_nookies_.parseCookies)(ctx).access_token;

  if (!token) {
    return util/* Util.sendToHomePage */.Z.sendToHomePage(res, undefined);
  }

  let language = (0,external_nookies_.parseCookies)(ctx).language || 'pt';

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: create_objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ['common']))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8528:
/***/ ((module) => {

module.exports = require("i18next");

/***/ }),

/***/ 3804:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 9982:
/***/ ((module) => {

module.exports = require("primereact/button");

/***/ }),

/***/ 7418:
/***/ ((module) => {

module.exports = require("primereact/calendar");

/***/ }),

/***/ 7930:
/***/ ((module) => {

module.exports = require("primereact/dataview");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 2832:
/***/ ((module) => {

module.exports = require("primereact/fileupload");

/***/ }),

/***/ 1775:
/***/ ((module) => {

module.exports = require("primereact/inputswitch");

/***/ }),

/***/ 322:
/***/ ((module) => {

module.exports = require("primereact/listbox");

/***/ }),

/***/ 9093:
/***/ ((module) => {

module.exports = require("primereact/tag");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 3229:
/***/ ((module) => {

module.exports = require("remask");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,1649,471,5548,4017,5745,5980,7697,3802,3976,4738,382,3852,4993], () => (__webpack_exec__(5670)));
module.exports = __webpack_exports__;

})();