"use strict";
(() => {
var exports = {};
exports.id = 6206;
exports.ids = [6206];
exports.modules = {

/***/ 9985:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ supplier),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: external "yup-phone"
var external_yup_phone_ = __webpack_require__(7815);
// EXTERNAL MODULE: external "yup-password"
var external_yup_password_ = __webpack_require__(3121);
var external_yup_password_default = /*#__PURE__*/__webpack_require__.n(external_yup_password_);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/styles.ts


const Wrapper = (external_styled_components_default()).div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  border-radius: ${p => p.theme.borderRadius};
  background-color: ${p => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    width: 100%;
    padding: 5px;
  }
`;
const RegisterImage = (external_styled_components_default()).div`
  width: 130px;
  height: 130px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  input {
    width: 92px;
    height: 92px;
    border-radius: 100px;
    display: none;
  }
`;
const InputGroup = (external_styled_components_default()).div`
  display: grid;
  width: 100%;
  justify-content: center;
  flex-wrap: wrap;

  @media screen and (min-width: 768px) {
    grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
  }

  @media screen and (max-width: 768px) {
    display: flex;
    justify-content: center;
    align-items: center;
  }
`;
const InputContainer = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  justify-content: flex-start;
`;
const ButtonContainer = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  margin-top: 20px;
  justify-content: center;
  align-items: center;
`;
const Container = (external_styled_components_default()).div`
  display: flex;
  width: 100%;
  justify-content: center;
`;
const ContainerText = (external_styled_components_default()).div`
  flex-direction: row;
  width: 100%;
  justify-content: center;
  display: grid;
`;
const Title = (external_styled_components_default()).text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;
const Text = (external_styled_components_default()).text`
  font: normal normal 600 ${p => p.fontSize || 16}px Poppins;
  margin: 20px 0;
  text-align: center;
`;
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/mail.tsx
var mail = __webpack_require__(4730);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/password.tsx
var SvgIcons_password = __webpack_require__(3371);
// EXTERNAL MODULE: ./src/core/services/api.ts
var api = __webpack_require__(6402);
;// CONCATENATED MODULE: ./src/core/hooks/useBanks.ts

function useBanks() {
  const getData = async () => {
    return await api/* default.get */.Z.get(`/WS/Pagarme/JSON/Banco`);
  };

  return {
    getData
  };
}
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: ./src/core/utils/exceptions.ts
var exceptions = __webpack_require__(504);
// EXTERNAL MODULE: ./src/core/hooks/useFile.ts
var useFile = __webpack_require__(4050);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/cellphone.tsx
var cellphone = __webpack_require__(4157);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/user.tsx
var user = __webpack_require__(1475);
// EXTERNAL MODULE: ./src/core/utils/masks.ts
var masks = __webpack_require__(5069);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: ./src/app/components/FormLoading/index.tsx
var FormLoading = __webpack_require__(9713);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./src/core/contexts/UserContext.tsx
var UserContext = __webpack_require__(9263);
// EXTERNAL MODULE: ./node_modules/react-icons/hi/index.esm.js
var index_esm = __webpack_require__(3854);
// EXTERNAL MODULE: ./node_modules/react-icons/cg/index.esm.js
var cg_index_esm = __webpack_require__(471);
// EXTERNAL MODULE: ./node_modules/react-icons/ai/index.esm.js
var ai_index_esm = __webpack_require__(8193);
// EXTERNAL MODULE: ./node_modules/react-icons/bi/index.esm.js
var bi_index_esm = __webpack_require__(7516);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
;// CONCATENATED MODULE: ./src/pages/profiles/supplier/index.tsx



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






















external_yup_password_default()(external_yup_);










function SupplierProfile() {
  var _userEditDto$foto;

  const {
    getData
  } = useBanks();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  const {
    getDataEditing,
    saveDataEditing
  } = (0,useEstablishment/* default */.Z)();
  const {
    updateUser
  } = (0,UserContext/* useUserContext */.SE)();
  const {
    0: userEditDto,
    1: setUserEditDto
  } = (0,external_react_.useState)({});
  const {
    0: banks,
    1: setBanks
  } = (0,external_react_.useState)([]);
  const {
    0: filteredBanks,
    1: setFilteredBanks
  } = (0,external_react_.useState)([]);
  const inputRef = (0,external_react_.useRef)();
  const toastRef = (0,external_react_.useRef)();
  const {
    getArchiveByHtmlInput,
    archiveInfos
  } = (0,useFile/* default */.Z)("image");
  const {
    0: loading,
    1: setLoading
  } = (0,external_react_.useState)(true);
  const theme = (0,external_styled_components_.useTheme)();
  const validationSchema = external_yup_.object({
    usuario: external_yup_.object({
      nome: external_yup_.string().required(t("requiredField")),
      email: external_yup_.string().email(t("invalidEmail")).required(t("requiredField")),
      celular: external_yup_.string().phone("BR", false, t("invalidCellphone")).required(t("requiredField"))
    }),
    pessoa: external_yup_.object({
      email: external_yup_.string().email(t("invalidEmail")).required(t("requiredField")),
      cpfCnpj: external_yup_.string().required(t("requiredField")),
      contaBancaria: external_yup_.object({
        codigoBanco: external_yup_.string().required(t("requiredField")),
        contaBancaria: external_yup_.string().required(t("requiredField")),
        digitoContaBancaria: external_yup_.string().required(t("requiredField")),
        agenciaBancaria: external_yup_.string().required(t("requiredField")),
        intervaloDeTransferencia: external_yup_.string().required(t("requiredField")),
        cpfCnpjResponsavel: external_yup_.string().required(t("requiredField")),
        nomeRazaoSocial: external_yup_.string().required(t("requiredField"))
      })
    }),
    estabelecimento: external_yup_.object({
      descricaoComercial: external_yup_.string().required(t("requiredField"))
    }),
    senha: external_yup_.string().password().minUppercase(0).minLowercase(0).minSymbols(0).minNumbers(0).min(6, t("passwordLength")).max(16, t("passwordLength")),
    senhaConfirmar: external_yup_.string().when("senha", {
      is: value => value && value.length > 0,
      then: external_yup_.string().oneOf([external_yup_.ref("senha")], t("passwordsMatch")).required(t("requiredField")),
      otherwise: external_yup_.string().notRequired()
    })
  });

  const validateEmail = value => {
    let error;

    if (!value) {
      error = t("requiredField");
    }

    return error;
  };

  const validateEmailUser = value => {
    let error;

    if (!value) {
      error = t("requiredField");
    }

    return error;
  };

  const dropdownOptions = [{
    key: t("daily"),
    value: "DAILY"
  }, {
    key: t("weekly"),
    value: "WEEKLY"
  }, {
    key: t("monthly"),
    value: "MONTHLY"
  }];

  const passwordConfirmationValidation = senha => {
    if (senha) {
      return true;
    }

    return false;
  };

  const handleOnImageChnage = event => {
    try {
      getArchiveByHtmlInput(event);
    } catch (error) {
      if (error instanceof exceptions/* ImageError */.YA) {
        util/* Util.showErrorToast */.Z.showErrorToast(toastRef, error.message);
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toastRef, t("onUploadImageError"));
      }
    }
  };

  const getbancosFormatados = (0,external_react_.useCallback)(async () => {
    let bancosFormatados = [];
    let bancos = [];
    const response = await getData();
    bancos = response.data;
    bancos.forEach(banco => {
      let item = {
        key: banco.Code + " - " + banco.Name,
        value: banco.Code
      };
      bancosFormatados.push(item);
    });
    bancosFormatados = bancosFormatados.sort(function (a, b) {
      if (a.value > b.value) {
        return 1;
      }

      if (a.value < b.value) {
        return -1;
      }

      return 0;
    });
    setBanks(bancosFormatados);
  }, []);

  const searchBanks = event => {
    setTimeout(() => {
      let _filteredBanks = [];

      if (!event.query.trim().length) {
        _filteredBanks = [...banks];
      } else {
        _filteredBanks = banks.filter(bank => {
          return bank.name.toLowerCase().includes(event.query.toLowerCase());
        });
      }

      setFilteredBanks(_filteredBanks);
    }, 250);
  };

  const getUserEditDto = (0,external_react_.useCallback)(async () => {
    const response = await getDataEditing();
    setUserEditDto(response.data);
    setLoading(false);
  }, []);
  (0,external_react_.useEffect)(() => {
    getbancosFormatados();
  }, [getbancosFormatados]);
  (0,external_react_.useEffect)(() => {
    getUserEditDto();
  }, [getUserEditDto]);

  const onSubmit = async (user, onSubmitProps) => {
    if (user.senha) {
      user.usuario.senha = user.senha;
    }

    setLoading(true);

    try {
      if ((archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.base64) != null) {
        user.foto = {
          bytes: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.base64,
          nome: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.nome,
          contentType: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.contentType
        };
      }

      await saveDataEditing(user);
      onSubmitProps.setSubmitting(false);
      updateUser();
      util/* Util.showSucessToast */.Z.showSucessToast(toastRef, t("saveDataSuccess"));
    } catch (error) {
      util/* Util.showErrorToast */.Z.showErrorToast(toastRef, t("saveDataError"));
    } finally {
      setLoading(false);
    }
  };

  function getPlaceholder(name) {
    return t(name);
  }

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("title", {
        children: ["Relty - ", t("myProfile")]
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(FormLoading/* default */.Z, {
      show: loading
    }), /*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toastRef,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(Title, {
      children: t("editProfile")
    }), /*#__PURE__*/jsx_runtime_.jsx(RegisterImage, {
      url: (archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.uri) || ((_userEditDto$foto = userEditDto.foto) === null || _userEditDto$foto === void 0 ? void 0 : _userEditDto$foto.url) || "/assets/perfil-default.png",
      onClick: () => {
        inputRef.current.click();
      },
      children: /*#__PURE__*/jsx_runtime_.jsx("input", {
        ref: inputRef,
        type: "file",
        onChange: event => {
          handleOnImageChnage(event);
        }
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
      initialValues: userEditDto,
      validationSchema: validationSchema,
      onSubmit: onSubmit,
      enableReinitialize: true,
      validateOnChange: true,
      validateOnBlur: true,
      children: formik => {
        var _formik$errors$usuari, _formik$touched$usuar, _formik$errors$usuari2, _formik$touched$usuar2, _formik$errors$usuari3, _formik$touched$usuar3, _formik$errors$pessoa, _formik$touched$pesso, _formik$errors$pessoa2, _formik$touched$pesso2, _formik$errors$estabe, _formik$touched$estab, _formik$errors$pessoa3, _formik$errors$pessoa4, _formik$touched$pesso3, _formik$touched$pesso4, _formik$errors$pessoa5, _formik$errors$pessoa6, _formik$touched$pesso5, _formik$touched$pesso6, _formik$errors$pessoa7, _formik$errors$pessoa8, _formik$touched$pesso7, _formik$touched$pesso8, _formik$errors$pessoa9, _formik$errors$pessoa10, _formik$touched$pesso9, _formik$touched$pesso10, _formik$errors$pessoa11, _formik$errors$pessoa12, _formik$touched$pesso11, _formik$touched$pesso12, _formik$errors$pessoa13, _formik$errors$pessoa14, _formik$touched$pesso13, _formik$touched$pesso14;

        return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "nome",
                name: "usuario.nome",
                label: "bennie",
                placeholder: getPlaceholder("placeholder_responsavel"),
                error: ((_formik$errors$usuari = formik.errors.usuario) === null || _formik$errors$usuari === void 0 ? void 0 : _formik$errors$usuari.nome) && ((_formik$touched$usuar = formik.touched.usuario) === null || _formik$touched$usuar === void 0 ? void 0 : _formik$touched$usuar.nome),
                icon: /*#__PURE__*/jsx_runtime_.jsx(user/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "email",
                name: "usuario.email",
                label: t("loginEmail"),
                placeholder: "example@gmail.com",
                validate: validateEmail,
                error: ((_formik$errors$usuari2 = formik.errors.usuario) === null || _formik$errors$usuari2 === void 0 ? void 0 : _formik$errors$usuari2.email) && ((_formik$touched$usuar2 = formik.touched.usuario) === null || _formik$touched$usuar2 === void 0 ? void 0 : _formik$touched$usuar2.email),
                icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "senha",
                type: "password",
                name: "senha",
                label: t("password"),
                placeholder: "******",
                error: formik.errors.senha && formik.touched.senha,
                icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                  width: 20,
                  height: 20
                }),
                onBlur: event => {
                  if (passwordConfirmationValidation(formik.values.senha)) {
                    formik.setFieldTouched("senhaConfirmar", true, true);
                  }
                }
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "senhaConfirmar",
                type: "password",
                name: "senhaConfirmar",
                label: t("repeatPassword"),
                placeholder: "******",
                error: formik.errors.senhaConfirmar && formik.touched.senhaConfirmar,
                icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 3,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "celular",
                name: "usuario.celular",
                placeholder: t("cellPhonePlaceholder"),
                label: t("cellPhone"),
                error: ((_formik$errors$usuari3 = formik.errors.usuario) === null || _formik$errors$usuari3 === void 0 ? void 0 : _formik$errors$usuari3.celular) && ((_formik$touched$usuar3 = formik.touched.usuario) === null || _formik$touched$usuar3 === void 0 ? void 0 : _formik$touched$usuar3.celular),
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.brCellphone */.T.brCellphone(event.nativeEvent.target.value);
                },
                icon: /*#__PURE__*/jsx_runtime_.jsx(cellphone/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "cpfCnpj",
                name: "pessoa.cpfCnpj",
                label: t("cpfCnpj"),
                placeholder: t("cpfCnpj"),
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.cpfCnpj */.T.cpfCnpj(event.nativeEvent.target.value);
                },
                error: ((_formik$errors$pessoa = formik.errors.pessoa) === null || _formik$errors$pessoa === void 0 ? void 0 : _formik$errors$pessoa.cpfCnpj) && ((_formik$touched$pesso = formik.touched.pessoa) === null || _formik$touched$pesso === void 0 ? void 0 : _formik$touched$pesso.cpfCnpj),
                icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* HiDocumentText */.ivT, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "emailUsuario",
                name: "pessoa.email",
                label: t("contactEmail"),
                placeholder: "example@gmail.com",
                validate: validateEmailUser,
                error: ((_formik$errors$pessoa2 = formik.errors.pessoa) === null || _formik$errors$pessoa2 === void 0 ? void 0 : _formik$errors$pessoa2.email) && ((_formik$touched$pesso2 = formik.touched.pessoa) === null || _formik$touched$pesso2 === void 0 ? void 0 : _formik$touched$pesso2.email),
                icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
              id: "descricaoComercial",
              name: "estabelecimento.descricaoComercial",
              label: t("details"),
              placeholder: t("details"),
              as: "textarea",
              error: ((_formik$errors$estabe = formik.errors.estabelecimento) === null || _formik$errors$estabe === void 0 ? void 0 : _formik$errors$estabe.descricaoComercial) && ((_formik$touched$estab = formik.touched.estabelecimento) === null || _formik$touched$estab === void 0 ? void 0 : _formik$touched$estab.descricaoComercial),
              icon: /*#__PURE__*/jsx_runtime_.jsx(cg_index_esm/* CgDetailsMore */.bRw, {
                size: 22,
                color: theme.primaryBackground
              })
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(Container, {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(ContainerText, {
              children: [/*#__PURE__*/jsx_runtime_.jsx(Container, {
                children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
                  fontSize: 16,
                  children: t("paymentInfo")
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(Container, {
                children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
                  fontSize: 12,
                  children: t("warning")
                })
              })]
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                as: "select",
                label: t("bankCode"),
                id: "codigoBanco",
                name: "pessoa.contaBancaria.codigoBanco",
                placeholder: t("placeholder_banco"),
                options: banks,
                icon: /*#__PURE__*/jsx_runtime_.jsx(ai_index_esm/* AiFillBank */.ZY4, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            })
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 2,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "nomeRazaoSocial",
                name: "pessoa.contaBancaria.nomeRazaoSocial",
                label: t("companyName"),
                placeholder: t("placeholder_responsavel"),
                error: ((_formik$errors$pessoa3 = formik.errors.pessoa) === null || _formik$errors$pessoa3 === void 0 ? void 0 : (_formik$errors$pessoa4 = _formik$errors$pessoa3.contaBancaria) === null || _formik$errors$pessoa4 === void 0 ? void 0 : _formik$errors$pessoa4.nomeRazaoSocial) && ((_formik$touched$pesso3 = formik.touched.pessoa) === null || _formik$touched$pesso3 === void 0 ? void 0 : (_formik$touched$pesso4 = _formik$touched$pesso3.contaBancaria) === null || _formik$touched$pesso4 === void 0 ? void 0 : _formik$touched$pesso4.nomeRazaoSocial),
                icon: /*#__PURE__*/jsx_runtime_.jsx(user/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "cpfCnpjResponsavel",
                name: "pessoa.contaBancaria.cpfCnpjResponsavel",
                label: t("ownerCpfCnpj"),
                placeholder: t("cpfCnpj"),
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.cpfCnpj */.T.cpfCnpj(event.nativeEvent.target.value);
                },
                error: ((_formik$errors$pessoa5 = formik.errors.pessoa) === null || _formik$errors$pessoa5 === void 0 ? void 0 : (_formik$errors$pessoa6 = _formik$errors$pessoa5.contaBancaria) === null || _formik$errors$pessoa6 === void 0 ? void 0 : _formik$errors$pessoa6.cpfCnpjResponsavel) && ((_formik$touched$pesso5 = formik.touched.pessoa) === null || _formik$touched$pesso5 === void 0 ? void 0 : (_formik$touched$pesso6 = _formik$touched$pesso5.contaBancaria) === null || _formik$touched$pesso6 === void 0 ? void 0 : _formik$touched$pesso6.cpfCnpjResponsavel),
                icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* HiDocumentText */.ivT, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 3,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "contaBancaria",
                name: "pessoa.contaBancaria.contaBancaria",
                type: "text",
                maxLength: "13",
                label: t("bankAccount"),
                placeholder: t("placeholder_conta"),
                onInput: event => {
                  var _event$nativeEvent$ta;

                  event.nativeEvent.target.value = (_event$nativeEvent$ta = event.nativeEvent.target.value) === null || _event$nativeEvent$ta === void 0 ? void 0 : _event$nativeEvent$ta.replace(/\D/g, "");
                },
                error: ((_formik$errors$pessoa7 = formik.errors.pessoa) === null || _formik$errors$pessoa7 === void 0 ? void 0 : (_formik$errors$pessoa8 = _formik$errors$pessoa7.contaBancaria) === null || _formik$errors$pessoa8 === void 0 ? void 0 : _formik$errors$pessoa8.contaBancaria) && ((_formik$touched$pesso7 = formik.touched.pessoa) === null || _formik$touched$pesso7 === void 0 ? void 0 : (_formik$touched$pesso8 = _formik$touched$pesso7.contaBancaria) === null || _formik$touched$pesso8 === void 0 ? void 0 : _formik$touched$pesso8.contaBancaria),
                icon: /*#__PURE__*/jsx_runtime_.jsx(ai_index_esm/* AiFillBank */.ZY4, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "digitoContaBancaria",
                name: "pessoa.contaBancaria.digitoContaBancaria",
                maxLength: "2",
                label: t("bankAccountDigit"),
                placeholder: t("placeholder_digito"),
                onInput: event => {
                  var _event$nativeEvent$ta2;

                  event.nativeEvent.target.value = (_event$nativeEvent$ta2 = event.nativeEvent.target.value) === null || _event$nativeEvent$ta2 === void 0 ? void 0 : _event$nativeEvent$ta2.replace(/(?!\w|\s)./g, "").replace(/\s+/g, "");
                },
                error: ((_formik$errors$pessoa9 = formik.errors.pessoa) === null || _formik$errors$pessoa9 === void 0 ? void 0 : (_formik$errors$pessoa10 = _formik$errors$pessoa9.contaBancaria) === null || _formik$errors$pessoa10 === void 0 ? void 0 : _formik$errors$pessoa10.digitoContaBancaria) && ((_formik$touched$pesso9 = formik.touched.pessoa) === null || _formik$touched$pesso9 === void 0 ? void 0 : (_formik$touched$pesso10 = _formik$touched$pesso9.contaBancaria) === null || _formik$touched$pesso10 === void 0 ? void 0 : _formik$touched$pesso10.digitoContaBancaria),
                icon: /*#__PURE__*/jsx_runtime_.jsx(ai_index_esm/* AiFillBank */.ZY4, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "agenciaBancaria",
                name: "pessoa.contaBancaria.agenciaBancaria",
                type: "text",
                maxLength: "5",
                label: t("agency"),
                placeholder: t("placeholder_agencia"),
                onInput: event => {
                  var _event$nativeEvent$ta3;

                  event.nativeEvent.target.value = (_event$nativeEvent$ta3 = event.nativeEvent.target.value) === null || _event$nativeEvent$ta3 === void 0 ? void 0 : _event$nativeEvent$ta3.replace(/\D/g, "");
                },
                error: ((_formik$errors$pessoa11 = formik.errors.pessoa) === null || _formik$errors$pessoa11 === void 0 ? void 0 : (_formik$errors$pessoa12 = _formik$errors$pessoa11.contaBancaria) === null || _formik$errors$pessoa12 === void 0 ? void 0 : _formik$errors$pessoa12.agenciaBancaria) && ((_formik$touched$pesso11 = formik.touched.pessoa) === null || _formik$touched$pesso11 === void 0 ? void 0 : (_formik$touched$pesso12 = _formik$touched$pesso11.contaBancaria) === null || _formik$touched$pesso12 === void 0 ? void 0 : _formik$touched$pesso12.agenciaBancaria),
                icon: /*#__PURE__*/jsx_runtime_.jsx(ai_index_esm/* AiFillBank */.ZY4, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                as: "select",
                label: t("transferInterval"),
                id: "intervaloDeTransferencia",
                name: "pessoa.contaBancaria.intervaloDeTransferencia",
                error: ((_formik$errors$pessoa13 = formik.errors.pessoa) === null || _formik$errors$pessoa13 === void 0 ? void 0 : (_formik$errors$pessoa14 = _formik$errors$pessoa13.contaBancaria) === null || _formik$errors$pessoa14 === void 0 ? void 0 : _formik$errors$pessoa14.intervaloDeTransferencia) && ((_formik$touched$pesso13 = formik.touched.pessoa) === null || _formik$touched$pesso13 === void 0 ? void 0 : (_formik$touched$pesso14 = _formik$touched$pesso13.contaBancaria) === null || _formik$touched$pesso14 === void 0 ? void 0 : _formik$touched$pesso14.intervaloDeTransferencia),
                options: dropdownOptions,
                icon: /*#__PURE__*/jsx_runtime_.jsx(bi_index_esm/* BiTransfer */.HZ8, {
                  size: 22,
                  color: theme.primaryBackground
                })
              })
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
            children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
              type: "submit",
              text: t("submit"),
              disabled: formik.isSubmitting || !formik.isValid
            })
          })]
        });
      }
    })]
  });
}

/* harmony default export */ const supplier = (SupplierProfile);
const getServerSideProps = async ctx => {
  const {
    res,
    resolvedUrl
  } = ctx;
  const token = (0,external_nookies_.parseCookies)(ctx).access_token;
  const savedUser = (0,external_nookies_.parseCookies)(ctx).user;

  if (!token) {
    return util/* Util.sendToHomePage */.Z.sendToHomePage(res, undefined);
  }

  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  if (savedUser) {
    let user = JSON.parse(savedUser);

    if (user.perfilAtual == "C") {
      return util/* Util.sendToAnyPage */.Z.sendToAnyPage(res, "/profiles/user");
    }
  }

  return {
    props: _objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 3229:
/***/ ((module) => {

module.exports = require("remask");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 3121:
/***/ ((module) => {

module.exports = require("yup-password");

/***/ }),

/***/ 7815:
/***/ ((module) => {

module.exports = require("yup-phone");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,471,8193,3854,7516,5548,4017,5745,5980,7697,3371,3976,37,4993,2966], () => (__webpack_exec__(9985)));
module.exports = __webpack_exports__;

})();