"use strict";
(() => {
var exports = {};
exports.id = 4749;
exports.ids = [4749];
exports.modules = {

/***/ 5069:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "T": () => (/* binding */ masks)
/* harmony export */ });
/* harmony import */ var remask__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3229);
/* harmony import */ var remask__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(remask__WEBPACK_IMPORTED_MODULE_0__);

const masks = {
  cpfCnpj,
  brCellphone,
  brMoney,
  cep
};

function cpfCnpj(documentValue) {
  documentValue = (0,remask__WEBPACK_IMPORTED_MODULE_0__.unMask)(documentValue);
  return (0,remask__WEBPACK_IMPORTED_MODULE_0__.mask)(documentValue, ["999.999.999-99", "99.999.999/9999-99"]);
}

function brCellphone(documentValue) {
  documentValue = (0,remask__WEBPACK_IMPORTED_MODULE_0__.unMask)(documentValue);
  return (0,remask__WEBPACK_IMPORTED_MODULE_0__.mask)(documentValue, ["(99)9 9999-9999"]);
}

function brMoney(documentValue) {
  documentValue = (0,remask__WEBPACK_IMPORTED_MODULE_0__.unMask)(documentValue);
  return (0,remask__WEBPACK_IMPORTED_MODULE_0__.mask)(documentValue, ["(99)9 9999-9999"]);
}

function cep(documentValue) {
  documentValue = (0,remask__WEBPACK_IMPORTED_MODULE_0__.unMask)(documentValue);
  return (0,remask__WEBPACK_IMPORTED_MODULE_0__.mask)(documentValue, ["99999-999"]);
}

/***/ }),

/***/ 3352:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ AdminUser),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/profiles/admin/user/styles.ts


const Wrapper = (external_styled_components_default()).div`
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    padding: 10px 10px;
    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    border-radius: ${p => p.theme.borderRadius};
    background-color: ${p => p.theme.activeElementBackground};
`;
const Title = (external_styled_components_default()).text`
    font: normal normal 600 24px/18px Poppins;
    margin: 20px 0;
`;
const SearchContainer = (external_styled_components_default()).div`
    padding: 0 16px;
    width: 100%;

    @media screen and (max-width: 767px) {
        padding: 0 0;
    }
`;
const Elements = (external_styled_components_default()).div`
    height: 100%;
    display: flex;
    flex-direction: row;
    gap: 10px;
`;
const InputWrapper = external_styled_components_default()(Elements)`
    width: 50%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    a {
        text {
        color: ${p => p.theme.primaryBackground};
        }
    }
    @media screen and (max-width: 767px) {
        width: 100%;
    }
`;
const ButtonContainer = (external_styled_components_default()).div`
    width: 40%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
        a {
        text {
            color: ${p => p.theme.primaryBackground};
        }
    }
`;
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: ./src/app/components/DataTable/index.tsx + 14 modules
var DataTable = __webpack_require__(676);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: ./src/core/hooks/useFile.ts
var useFile = __webpack_require__(4050);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: external "yup-password"
var external_yup_password_ = __webpack_require__(3121);
var external_yup_password_default = /*#__PURE__*/__webpack_require__.n(external_yup_password_);
// EXTERNAL MODULE: external "yup-phone"
var external_yup_phone_ = __webpack_require__(7815);
// EXTERNAL MODULE: ./src/core/hooks/useUser.ts
var useUser = __webpack_require__(5980);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/password.tsx
var SvgIcons_password = __webpack_require__(3371);
;// CONCATENATED MODULE: ./src/app/components/CreateUserModal/styles.ts


const styles_Wrapper = (external_styled_components_default()).div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  border-radius: ${p => p.theme.borderRadius};
  background-color: ${p => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    padding: 5px;
    width: 100%;
  }
`;
const styles_ButtonContainer = (external_styled_components_default()).div`
  margin-top: 40px;
`;
const RegisterImage = (external_styled_components_default()).div`
  width: 130px;
  height: 130px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  input {
    width: 92px;
    height: 92px;
    border-radius: 100px;
    display: none;
  }
`;
// EXTERNAL MODULE: ./src/app/components/SvgIcons/cellphone.tsx
var cellphone = __webpack_require__(4157);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/mail.tsx
var mail = __webpack_require__(4730);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/user.tsx
var user = __webpack_require__(1475);
// EXTERNAL MODULE: ./src/core/utils/masks.ts
var masks = __webpack_require__(5069);
// EXTERNAL MODULE: ./src/core/utils/exceptions.ts
var exceptions = __webpack_require__(504);
// EXTERNAL MODULE: external "primereact/inputswitch"
var inputswitch_ = __webpack_require__(1775);
;// CONCATENATED MODULE: ./src/app/components/CreateUserModal/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






















external_yup_password_default()(external_yup_);
const defaultPermission = {
  overview: false,
  suppliers: false,
  users: false,
  adventures: false,
  materials: false,
  categorys: false
};
function CreateUsermodal(props) {
  const inputRef = (0,external_react_.useRef)(null);
  const toast = (0,external_react_.useRef)(null);
  const {
    getArchiveByHtmlInput,
    archiveInfos
  } = (0,useFile/* default */.Z)("image");
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: userPermission,
    1: setUserPermission
  } = (0,external_react_.useState)(defaultPermission);
  const {
    createAdminUser
  } = (0,useUser/* default */.Z)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setUserPermission(defaultPermission);
  }, [props.visible]);

  const handleOnImageChange = event => {
    try {
      getArchiveByHtmlInput(event);
    } catch (error) {
      if (error instanceof exceptions/* ImageError */.YA) util/* Util.showErrorToast */.Z.showErrorToast(toast, error.message);else util/* Util.showErrorToast */.Z.showErrorToast(toast, t("onUploadImageError"));
    }
  };

  const onSubmit = async values => {
    let body = {
      foto: archiveInfos !== null && archiveInfos !== void 0 && archiveInfos.base64 ? {
        bytes: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.base64,
        nome: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.nome,
        contentType: archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.contentType
      } : null,
      pessoa: {
        cpfCnpj: values.cpf
      },
      usuario: {
        nome: values.name,
        email: values.email,
        celular: values.cellPhone,
        senha: values.password,
        perfilAtual: "C",
        linguagemAtual: "pt",
        seAventuras: userPermission.adventures ? "S" : "N",
        seCategorias: userPermission.categorys ? "S" : "N",
        seFornecedores: userPermission.suppliers ? "S" : "N",
        seMateriais: userPermission.materials ? "S" : "N",
        seOverview: userPermission.overview ? "S" : "N",
        seUsuarios: userPermission.users ? "S" : "N"
      }
    };

    try {
      const response = await createAdminUser(body);

      if (response.status === 200) {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, `Usuário criado com sucesso!`);
        props.onHide();
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toast, `Erro ao criar usuário!`);
      }
    } catch (error) {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, `Erro ao criar usuário!`);
    }
  };

  const PermissionSwitch = ({
    text,
    permission
  }) => {
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
      style: {
        display: "flex",
        alignItems: "center",
        padding: "5px"
      },
      children: [/*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
        style: {
          position: "relative",
          margin: "5px"
        },
        checked: userPermission[permission],
        onChange: () => setUserPermission(_objectSpread(_objectSpread({}, userPermission), {}, {
          [permission]: !userPermission[permission]
        }))
      }), /*#__PURE__*/jsx_runtime_.jsx("text", {
        children: text
      })]
    });
  };

  const initialValues = {
    name: "",
    email: "",
    cellPhone: "",
    cpf: "",
    password: "",
    repeatPassword: ""
  };
  const validationSchema = external_yup_.object({
    name: external_yup_.string().required(t("requiredField")),
    email: external_yup_.string().email(t("invalidEmail")).required(t("requiredField")),
    cellPhone: external_yup_.string().phone("BR", false, t("invalidCellphone")).required(t("requiredField")),
    cpf: external_yup_.string().test("cpf inválido", value => {
      if (!value) return false;
      return /^(\d{3}\.){2}\d{3}\-\d{2}$/.test(value) || /^(\d{2}\.)(\d{3}\.)\d{3}\/\d{4}-\d{2}$/.test(value);
    }).required(t("requiredField")),
    password: external_yup_.string().password().required(t("requiredField")).minUppercase(0).minLowercase(0).minSymbols(0).minNumbers(0).min(6, t("passwordLength")).max(16, t("passwordLength")),
    repeatPassword: external_yup_.string().when("password", {
      is: value => value && value.length > 0,
      then: external_yup_.string().oneOf([external_yup_.ref("password")], t("passwordsMatch")).required(t("requiredField")),
      otherwise: external_yup_.string().notRequired()
    })
  });
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: "Cria\xE7\xE3o de Usu\xE1rio",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_Wrapper, {
        children: [/*#__PURE__*/jsx_runtime_.jsx(RegisterImage, {
          url: (archiveInfos === null || archiveInfos === void 0 ? void 0 : archiveInfos.uri) || "/assets/perfil-default.png",
          onClick: () => {
            {
              /* @ts-ignore */
            }
            inputRef.current.click();
          },
          children: /*#__PURE__*/jsx_runtime_.jsx("input", {
            ref: inputRef,
            type: "file",
            onChange: event => handleOnImageChange(event)
          })
        }), /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
          initialValues: initialValues,
          validationSchema: validationSchema,
          onSubmit: values => {
            onSubmit(values);
          },
          validateOnChange: true,
          children: formik => {
            return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
              children: [/*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "name",
                name: "name",
                label: t("name"),
                placeholder: "Jo\xE3o Alberto",
                error: formik.errors.name && formik.touched.name,
                icon: /*#__PURE__*/jsx_runtime_.jsx(user/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "email",
                name: "email",
                label: t("email"),
                placeholder: "example@gmail.com",
                error: formik.errors.email && formik.touched.email,
                icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "cellPhone",
                name: "cellPhone",
                label: t("cellPhone"),
                placeholder: "(99) 9 9999-9999",
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.brCellphone */.T.brCellphone(event.nativeEvent.target.value);
                },
                error: formik.errors.cellPhone && formik.touched.cellPhone,
                icon: /*#__PURE__*/jsx_runtime_.jsx(cellphone/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "cpf",
                name: "cpf",
                label: t("cpf"),
                placeholder: "999.999.999-99 | 99.999.999/9999-99",
                onInput: event => {
                  event.nativeEvent.target.value = masks/* masks.cpfCnpj */.T.cpfCnpj(event.nativeEvent.target.value);
                },
                error: formik.errors.cpf && formik.touched.cpf,
                icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "password",
                name: "password",
                label: t("password"),
                type: "password",
                placeholder: "******",
                error: formik.errors.password && formik.touched.password,
                icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "repeatPassword",
                name: "repeatPassword",
                label: t("repeatPassword"),
                type: "password",
                placeholder: "******",
                error: formik.errors.repeatPassword && formik.touched.repeatPassword,
                icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                  width: 20,
                  height: 20
                })
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar Overview",
                permission: "overview"
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar Fornecedores",
                permission: "suppliers"
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar Usu\xE1rios",
                permission: "users"
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar Aventuras",
                permission: "adventures"
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar materiais",
                permission: "materials"
              }), /*#__PURE__*/jsx_runtime_.jsx(PermissionSwitch, {
                text: "Vizualizar categorias",
                permission: "categorys"
              }), /*#__PURE__*/jsx_runtime_.jsx(styles_ButtonContainer, {
                children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                  type: "submit",
                  text: "Criar Usuário",
                  disabled: !formik.isValid
                })
              })]
            });
          }
        })]
      })
    })]
  });
}
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
// EXTERNAL MODULE: external "react-paginate"
var external_react_paginate_ = __webpack_require__(6495);
var external_react_paginate_default = /*#__PURE__*/__webpack_require__.n(external_react_paginate_);
// EXTERNAL MODULE: ./node_modules/react-icons/fa/index.esm.js
var index_esm = __webpack_require__(9583);
// EXTERNAL MODULE: external "primereact/inputtext"
var inputtext_ = __webpack_require__(5333);
// EXTERNAL MODULE: external "react-i18next"
var external_react_i18next_ = __webpack_require__(7789);
;// CONCATENATED MODULE: ./src/pages/profiles/admin/user/index.tsx



function user_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function user_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { user_ownKeys(Object(source), true).forEach(function (key) { user_defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { user_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function user_defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















function AdminUser() {
  const {
    getDataListUserFilter
  } = (0,useEstablishment/* default */.Z)();
  const {
    0: dataContent,
    1: setDataContent
  } = (0,external_react_.useState)({});
  const {
    0: inputSearch,
    1: setInputSearch
  } = (0,external_react_.useState)("");
  const {
    0: visibleCreateUserModal,
    1: setVisibleCreateUserModal
  } = (0,external_react_.useState)(false);
  const theme = (0,external_styled_components_.useTheme)();
  const {
    t
  } = (0,external_react_i18next_.useTranslation)("common");
  const columnsDataTable = [{
    field: "id",
    header: "Código",
    type: "string"
  }, {
    field: "nome",
    header: "Nome",
    type: "string"
  }, {
    field: "telefone",
    header: "Telefone",
    type: "string"
  }, {
    field: "email",
    header: "Email",
    type: "string"
  }, {
    field: "urlFoto",
    header: "Perfil",
    type: "image"
  }, {
    field: "perfis",
    header: "Permissões",
    type: "iconStr"
  }, {
    field: "buttonAction",
    header: "",
    type: "buttonAction",
    typeButton: [{
      page: "user",
      label: "Alterar senha"
    }, {
      page: "user",
      label: "Tornar admin"
    }]
  }];
  const {
    0: filterField,
    1: setFilterField
  } = (0,external_react_.useState)({
    nome: inputSearch
  });
  const {
    0: queryPage,
    1: setQueryPage
  } = (0,external_react_.useState)({
    page: 1,
    size: 6
  });
  const getDataListFilterDto = (0,external_react_.useCallback)(async (filter, query) => {
    const response = await getDataListUserFilter(filter, query);
    setDataContent(response.data);
  }, []);
  const handleKeyDown = (0,external_react_.useCallback)(async event => {
    if (event.key === "Enter") {
      const response = await getDataListUserFilter({
        nome: event.target.value
      }, {
        page: 0,
        size: queryPage.size
      });
      setDataContent(response.data);
    }
  }, []);
  (0,external_react_.useEffect)(() => {
    getDataListFilterDto(filterField, queryPage);
  }, [getDataListFilterDto]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Usu\xE1rios"
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(Title, {
      children: "Usu\xE1rios"
    }), /*#__PURE__*/jsx_runtime_.jsx(CreateUsermodal, {
      visible: visibleCreateUserModal,
      teste: "a",
      onHide: () => setVisibleCreateUserModal(!visibleCreateUserModal)
    }), /*#__PURE__*/jsx_runtime_.jsx(SearchContainer, {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputWrapper, {
        style: {
          margin: "auto"
        },
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("span", {
          className: "p-input-icon-left",
          children: [/*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaSearch */.U41, {
            size: 19,
            color: theme.pageForeground,
            className: "pi pi-search"
          }), /*#__PURE__*/jsx_runtime_.jsx(inputtext_.InputText, {
            placeholder: "Digite sua busca",
            className: "p-inputtext-md",
            onKeyDown: event => handleKeyDown(event),
            onChange: i => setInputSearch(i.target.value)
          })]
        }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
          children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            text: "Buscar",
            onClick: () => getDataListFilterDto({
              nome: inputSearch
            }, {
              page: 0,
              size: queryPage.size
            })
          })
        }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
          children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            text: "Criar Usu\xE1rio",
            onClick: () => {
              setVisibleCreateUserModal(!visibleCreateUserModal);
            }
          })
        })]
      })
    }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(DataTable/* default */.Z, {
      values: dataContent.content,
      columns: columnsDataTable
    }), /*#__PURE__*/jsx_runtime_.jsx((external_react_paginate_default()), {
      forcePage: queryPage.page - 1,
      "data-content": "My Content",
      containerClassName: "Pagination",
      marginPagesDisplayed: 0,
      pageRangeDisplayed: 4,
      pageCount: dataContent.totalPages ? dataContent.totalPages : 0,
      previousLabel: "<",
      nextLabel: ">",
      onPageChange: page => getDataListFilterDto({
        nome: inputSearch
      }, {
        page: page.selected,
        size: queryPage.size
      })
    })]
  });
}
const getServerSideProps = async ctx => {
  const {
    resolvedUrl
  } = ctx;
  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: user_objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 8859:
/***/ ((module) => {

module.exports = require("primereact/column");

/***/ }),

/***/ 6803:
/***/ ((module) => {

module.exports = require("primereact/datatable");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 1775:
/***/ ((module) => {

module.exports = require("primereact/inputswitch");

/***/ }),

/***/ 5333:
/***/ ((module) => {

module.exports = require("primereact/inputtext");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 6495:
/***/ ((module) => {

module.exports = require("react-paginate");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 3229:
/***/ ((module) => {

module.exports = require("remask");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 3121:
/***/ ((module) => {

module.exports = require("yup-password");

/***/ }),

/***/ 7815:
/***/ ((module) => {

module.exports = require("yup-phone");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,9583,5548,4017,5745,5980,7697,3371,6123,3976,37,7568,676,2966], () => (__webpack_exec__(3352)));
module.exports = __webpack_exports__;

})();