"use strict";
(() => {
var exports = {};
exports.id = 5379;
exports.ids = [5379];
exports.modules = {

/***/ 2154:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ supplier),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/profiles/admin/supplier/styles.ts


const Wrapper = (external_styled_components_default()).div`
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    padding: 10px 10px;
    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    border-radius: ${p => p.theme.borderRadius};
    background-color: ${p => p.theme.activeElementBackground};
`;
const Title = (external_styled_components_default()).text`
    font: normal normal 600 24px/18px Poppins;
    margin: 20px 0;
`;
const SearchContainer = (external_styled_components_default()).div`
    padding: 0 16px;
    width: 100%;

    @media screen and (max-width: 767px) {
        padding: 0 0;
    }
`;
const Elements = (external_styled_components_default()).div`
    height: 100%;
    display: flex;
    flex-direction: row;
    gap: 10px;
`;
const InputWrapper = external_styled_components_default()(Elements)`
    width: 50%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    a {
        text {
        color: ${p => p.theme.primaryBackground};
        }
    }
    @media screen and (max-width: 767px) {
        width: 100%;
    }
`;
const ButtonContainer = (external_styled_components_default()).div`
    width: 30%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
        a {
        text {
            color: ${p => p.theme.primaryBackground};
        }
    }
`;
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: ./src/app/components/DataTable/index.tsx + 14 modules
var DataTable = __webpack_require__(676);
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "react-paginate"
var external_react_paginate_ = __webpack_require__(6495);
var external_react_paginate_default = /*#__PURE__*/__webpack_require__.n(external_react_paginate_);
// EXTERNAL MODULE: ./node_modules/react-icons/fa/index.esm.js
var index_esm = __webpack_require__(9583);
// EXTERNAL MODULE: external "primereact/inputtext"
var inputtext_ = __webpack_require__(5333);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: external "react-i18next"
var external_react_i18next_ = __webpack_require__(7789);
;// CONCATENATED MODULE: ./src/pages/profiles/admin/supplier/index.tsx



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















function AdminSupplier() {
  const {
    getDataListFilter
  } = (0,useEstablishment/* default */.Z)();
  const {
    0: dataContent,
    1: setDataContent
  } = (0,external_react_.useState)({});
  const {
    0: inputSearch,
    1: setInputSearch
  } = (0,external_react_.useState)("");
  const theme = (0,external_styled_components_.useTheme)();
  const {
    t
  } = (0,external_react_i18next_.useTranslation)("common");
  const columnsDataTable = [{
    field: "id",
    header: "Código",
    type: "string"
  }, {
    field: "nome",
    header: "Nome",
    type: "string"
  }, {
    field: "cpfCnpj",
    header: "CPF/CNPJ",
    type: "string"
  }, {
    field: "telefone",
    header: "Telefone",
    type: "string"
  }, {
    field: "descricaoComercial",
    header: "Descrição",
    type: "textLong"
  }, {
    field: "email",
    header: "Email",
    type: "string"
  }, {
    field: "urlFoto",
    header: "Perfil",
    type: "image"
  }, {
    field: "buttonAction",
    header: "",
    type: "buttonAction",
    typeButton: [{
      page: "establishment",
      label: "Detalhes"
    }, {
      label: "Alterar comissão",
      page: "establishment"
    }]
  }];
  const {
    0: filterField,
    1: setFilterField
  } = (0,external_react_.useState)({
    nome: inputSearch
  });
  const {
    0: queryPage,
    1: setQueryPage
  } = (0,external_react_.useState)({
    page: 1,
    size: 6
  });
  const getDataListFilterDto = (0,external_react_.useCallback)(async (filter, query) => {
    const response = await getDataListFilter(filter, query);
    setDataContent(response.data);
  }, []);
  const handleKeyDown = (0,external_react_.useCallback)(async event => {
    if (event.key === "Enter") {
      const response = await getDataListFilter({
        nome: event.target.value
      }, {
        page: 0,
        size: queryPage.size
      });
      setDataContent(response.data);
    }
  }, []);
  (0,external_react_.useEffect)(() => {
    getDataListFilterDto(filterField, queryPage);
  }, [getDataListFilterDto]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Fornecedores"
      })
    }), /*#__PURE__*/jsx_runtime_.jsx(Title, {
      children: "Fornecedores"
    }), /*#__PURE__*/jsx_runtime_.jsx(SearchContainer, {
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputWrapper, {
        style: {
          margin: "auto"
        },
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("span", {
          className: "p-input-icon-left",
          children: [/*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaSearch */.U41, {
            size: 19,
            color: theme.pageForeground,
            className: "pi pi-search"
          }), /*#__PURE__*/jsx_runtime_.jsx(inputtext_.InputText, {
            placeholder: "Digite sua busca",
            className: "p-inputtext-md",
            onKeyDown: event => handleKeyDown(event),
            onChange: i => setInputSearch(i.target.value)
          })]
        }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
          children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            text: "Buscar",
            onClick: () => getDataListFilterDto({
              nome: inputSearch
            }, {
              page: 0,
              size: queryPage.size
            })
          })
        })]
      })
    }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(DataTable/* default */.Z, {
      values: dataContent.content,
      columns: columnsDataTable
    }), /*#__PURE__*/jsx_runtime_.jsx((external_react_paginate_default()), {
      forcePage: queryPage.page - 1,
      "data-content": "My Content",
      containerClassName: "Pagination",
      marginPagesDisplayed: 0,
      pageRangeDisplayed: 4,
      pageCount: dataContent.totalPages ? dataContent.totalPages : 0,
      previousLabel: "<",
      nextLabel: ">",
      onPageChange: page => getDataListFilterDto({
        nome: inputSearch
      }, {
        page: page.selected,
        size: queryPage.size
      })
    })]
  });
}

/* harmony default export */ const supplier = (AdminSupplier);
const getServerSideProps = async ctx => {
  const {
    resolvedUrl
  } = ctx;
  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: _objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 8859:
/***/ ((module) => {

module.exports = require("primereact/column");

/***/ }),

/***/ 6803:
/***/ ((module) => {

module.exports = require("primereact/datatable");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 5333:
/***/ ((module) => {

module.exports = require("primereact/inputtext");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 6495:
/***/ ((module) => {

module.exports = require("react-paginate");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 3121:
/***/ ((module) => {

module.exports = require("yup-password");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,9583,5548,4017,5745,5980,7697,3371,6123,3976,7568,676], () => (__webpack_exec__(2154)));
module.exports = __webpack_exports__;

})();