"use strict";
(() => {
var exports = {};
exports.id = 229;
exports.ids = [229];
exports.modules = {

/***/ 7696:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ home),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: ./src/app/components/CardAdventure/index.tsx + 1 modules
var CardAdventure = __webpack_require__(1349);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/pages/home/styles.ts

const CardContainer = (external_styled_components_default()).a`
  margin: 5px 5px;
  cursor: pointer;
  min-width: 300px;
  height: 320px;

  @media screen and (max-width: 767px) {
    width: 100%;
  }
`;
const CardsGrid = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  margin: auto;
`;
const NoData = (external_styled_components_default()).div`
  margin: auto;
  margin-top: 50px;

  h2 {
    text-align: center;
  }
`;
const SearchContainer = (external_styled_components_default()).div`
  padding: 0 16px;
  width: 100%;

  @media screen and (max-width: 767px) {
    padding: 0 0;
  }
`;
// EXTERNAL MODULE: external "react-paginate"
var external_react_paginate_ = __webpack_require__(6495);
var external_react_paginate_default = /*#__PURE__*/__webpack_require__.n(external_react_paginate_);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
// EXTERNAL MODULE: ./src/app/components/HomeSearchBar/index.tsx + 5 modules
var HomeSearchBar = __webpack_require__(2126);
// EXTERNAL MODULE: ./src/core/services/apiServerSide.ts
var apiServerSide = __webpack_require__(9763);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: ./src/core/hooks/useMasks.ts
var useMasks = __webpack_require__(4918);
;// CONCATENATED MODULE: ./src/pages/home/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }















const Home = props => {
  const {
    adventures,
    totalPages
  } = props;
  const {
    unMaskedMoney,
    money
  } = (0,useMasks/* default */.Z)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  const {
    0: parameters,
    1: setParameters
  } = (0,external_react_.useState)({
    page: props.page,
    search: props.search,
    activeElement: props.adventureType,
    price: props.price ? money(parseFloat(String(props.price)).toFixed(2)).maskedValue : props.price,
    order: props.order
  });

  const handleSearchAventure = (event, page) => {
    if (event) {
      if (event.key != "Enter") {
        return;
      } else {
        setParameters(_objectSpread(_objectSpread({}, parameters), {}, {
          page: 1
        }));
      }
    }

    const {
      search,
      activeElement,
      price,
      order
    } = parameters;
    let finalUrl = util/* Util.mountAdventureFilterParams */.Z.mountAdventureFilterParams(search, activeElement, String(unMaskedMoney(price)), order);
    let url = `/home?page=${page || 1}` + finalUrl;
    router_default().replace(url);
  };

  const hrefBuilder = page => {
    const {
      search,
      activeElement,
      price,
      order
    } = parameters;
    return `/home?page=${page || 1}` + util/* Util.mountAdventureFilterParams */.Z.mountAdventureFilterParams(search, activeElement, String(unMaskedMoney(price)), order);
  };

  const clearFilters = () => {
    parameters.order = "";
    parameters.activeElement = null;
    parameters.search = "";
    parameters.price = null;
    parameters.page = 1;
    handleSearchAventure();
  };

  const setActiveElement = newElement => {
    setParameters(_objectSpread(_objectSpread({}, parameters), {}, {
      activeElement: newElement
    }));
    parameters.activeElement = newElement;
    handleSearchAventure();
  };

  const setSearch = text => {
    setParameters(_objectSpread(_objectSpread({}, parameters), {}, {
      search: text
    }));
  };

  const setPrice = text => {
    setParameters(_objectSpread(_objectSpread({}, parameters), {}, {
      price: text
    }));
  };

  const setOrder = text => {
    setParameters(_objectSpread(_objectSpread({}, parameters), {}, {
      order: text
    }));
    parameters.order = text;
    handleSearchAventure(undefined, 1);
  };

  const filters = {
    price: {
      value: parameters.price,
      visible: true,
      setMethod: setPrice
    },
    order: {
      value: parameters.order,
      visible: true,
      setMethod: setOrder
    }
  };
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
    children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)((head_default()), {
      children: [/*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Home"
      }), /*#__PURE__*/jsx_runtime_.jsx("meta", {
        name: "description",
        content: "Relty ativades f\xEDsicas e aventuras"
      }), /*#__PURE__*/jsx_runtime_.jsx("link", {
        rel: "icon",
        href: "/assets/icon.png"
      })]
    }), /*#__PURE__*/jsx_runtime_.jsx(SearchContainer, {
      children: /*#__PURE__*/jsx_runtime_.jsx(HomeSearchBar/* default */.Z, {
        activeElement: parameters.activeElement,
        setActiveElement: setActiveElement,
        search: parameters.search || null,
        setSearch: setSearch,
        handleSearchAventure: handleSearchAventure,
        advancedFilters: filters,
        clearFilters: clearFilters
      })
    }), adventures && adventures.length > 0 ? /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(CardsGrid, {
        children: adventures === null || adventures === void 0 ? void 0 : adventures.map(item => /*#__PURE__*/jsx_runtime_.jsx(CardContainer, {
          children: /*#__PURE__*/jsx_runtime_.jsx(CardAdventure/* default */.Z, {
            adventure: item
          })
        }, item.id))
      }), /*#__PURE__*/jsx_runtime_.jsx((external_react_paginate_default()), {
        forcePage: parameters.page - 1,
        "data-content": "My Content",
        containerClassName: "Pagination",
        pageCount: totalPages ? totalPages : 0,
        marginPagesDisplayed: 0,
        pageRangeDisplayed: 3,
        previousLabel: "<",
        nextLabel: ">",
        hrefBuilder: page => hrefBuilder(page),
        onPageChange: page => handleSearchAventure(undefined, page.selected + 1)
      })]
    }) : /*#__PURE__*/jsx_runtime_.jsx(NoData, {
      children: /*#__PURE__*/jsx_runtime_.jsx("h2", {
        children: t("noResults")
      })
    })]
  });
};

/* harmony default export */ const home = (Home);
const getServerSideProps = async ctx => {
  const {
    query,
    res,
    resolvedUrl
  } = ctx;
  const {
    page: _page,
    adventureType,
    search,
    price: _price,
    order
  } = query;
  const page = Number(_page);
  const price = Number(_price);
  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  const api = (0,apiServerSide/* getApi */.ac)(ctx);

  if (adventureType && util/* Util.getValidAdventureType */.Z.getValidAdventureType(adventureType) === null) {
    return util/* Util.sendToHomePage */.Z.sendToHomePage(res, page);
  }

  if (price && (isNaN(price) || price < 0)) {
    return util/* Util.sendToHomePage */.Z.sendToHomePage(res, page);
  }

  if (isNaN(page) || page < 1) {
    return util/* Util.sendToHomePage */.Z.sendToHomePage(res);
  }

  let body = {
    tipoAventura: util/* Util.getValidAdventureType */.Z.getValidAdventureType(adventureType),
    buscaLivre: search ? search : null,
    filtrarSomenteDisponivel: true,
    preco: price ? price === null || price === void 0 ? void 0 : price.toString() : null
  };
  const adventures = await api.post(`/WS/Aventura/Filtrar?page=${page - 1}&size=12 ${util/* Util.mountAdventureOrder */.Z.mountAdventureOrder(String(order))}`, body);
  return {
    props: _objectSpread(_objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"])), {}, {
      adventures: adventures.data.content,
      totalPages: adventures.data.totalPages,
      adventureType: util/* Util.getValidAdventureType */.Z.getValidAdventureType(adventureType),
      search: search || null,
      page: page,
      order: order || null,
      price: price ? price === null || price === void 0 ? void 0 : price.toString() : null
    })
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8528:
/***/ ((module) => {

module.exports = require("i18next");

/***/ }),

/***/ 3804:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 9325:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 8300:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 5378:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 7162:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 8773:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 2248:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 9372:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 665:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 2747:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 333:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 3456:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 7620:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 5333:
/***/ ((module) => {

module.exports = require("primereact/inputtext");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 2559:
/***/ ((module) => {

module.exports = require("react-collapse");

/***/ }),

/***/ 4979:
/***/ ((module) => {

module.exports = require("react-dropdown");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 1687:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 6495:
/***/ ((module) => {

module.exports = require("react-paginate");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,9583,1664,1649,9352,5434,5548,4017,5745,5980,7697,3371,3802,6123,37,6089,7471,8409,1629,8394,1349,4738,382,3852,2126], () => (__webpack_exec__(7696)));
module.exports = __webpack_exports__;

})();