"use strict";
(() => {
var exports = {};
exports.id = 44;
exports.ids = [44];
exports.modules = {

/***/ 6402:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _apiServerSide__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9763);

const api = (0,_apiServerSide__WEBPACK_IMPORTED_MODULE_0__/* .getApi */ .ac)();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (api);

/***/ }),

/***/ 7066:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ Community),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
// EXTERNAL MODULE: external "next-i18next/serverSideTranslations"
var serverSideTranslations_ = __webpack_require__(3295);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
;// CONCATENATED MODULE: ./src/app/components/CardAdventureCommunity/styles.ts


const Image = (external_styled_components_default()).div`
    position: absolute;
    width: 100%;
    height: 69%;
    background-image: url(${p => p.url});
    background-position: center;
    background-size: cover;
`;
const FavoriteContainer = (external_styled_components_default()).div`
    position: absolute;
    right: 8px;
    top: 8px;
    cursor: pointer;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 10;
`;
const RatingContainer = external_styled_components_default()(FavoriteContainer)`
    left: 8px;
    top: 8px;
    max-width: 55px;
    height: 22px;
    background-color: ${p => p.theme.activeElementBackground};
    border-radius: ${p => p.theme.borderRadius};
    padding: 5px;
    justify-content: space-around;
`;
const Element = external_styled_components_default()(FavoriteContainer)`
    right: 8px;
    top: 195px;
    width: 60px;
`;
const Wrapper = (external_styled_components_default()).div`
    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    width: 100%;
    min-height: 320px;
    color: ${p => p.theme.pageForeground};
    background-color: white;
    position: relative;

    transition: 0.25s ease;
    * {
        transition: 0.25s ease;
    }

    &:hover, &:focus {
        * {
            color: ${p => p.theme.primaryForeground};
        }

        ${Image} {
            height: 100%;
        }

        ${RatingContainer},
        ${Element} {
            text {
                color: ${p => p.theme.pageForeground};
            }   
        }
    }   
`;
const TitleContainer = (external_styled_components_default()).div`
    background-color: rgba(0, 0, 0, 0.5);
    color: #fff;
    text-align: center;
    right: 8px;
    top: 8px;
    top: 100px;
    width: 250px;
    line-height: 30px;
    height: 30px;
`;
const InfoContainer = (external_styled_components_default()).div`
    position: absolute;
    top: 75%;
    height: auto;
    padding: 10px 10px;
    display: flex;
    flex-direction: column;
`;
const InfoContainerHeaderProfile = (external_styled_components_default()).div`
    height: 100%;
    display: flex;
    flex-direction: column;
    max-width: 300px;
    flex: 1;
`;
const TextHeaderProfile = (external_styled_components_default()).text`
font: normal normal normal 11px/20px Poppins;
`;
const Title = (external_styled_components_default()).text`
    text-align: left;
    font: normal normal 600 16px/14px Poppins;
    letter-spacing: 0.2px;
    line-height: 1.1;
    color: ${p => p.theme.pageForeground};
`;
const Text = external_styled_components_default()(Title)`
    cursor: default;
    font: normal normal bold 14px/14px Poppins;
`;
const CardContent = (external_styled_components_default()).div`
    border-${p => p.align || 'top'}-left-radius: ${p => p.theme.borderRadius};
    border-${p => p.align || 'top'}-right-radius: ${p => p.theme.borderRadius};
    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};

    color: ${p => p.theme.activeElementForeground};
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: space-around;
    margin-inline: 0;
    padding: 10px;
`;
const ProfileImage = (external_styled_components_default()).div`
    width: 45px;
    height: 45px;
    background-image: url(${p => p.url});
    background-position: center;
    background-size: cover;
    border-radius: 100px;
    display: flex;
    justify-content: center;
    align-items: center;
    cursor: default;
`;
const BoldText = (external_styled_components_default()).text`   
    font: normal normal 600 20px/30px Poppins;
`;
const Button = (external_styled_components_default()).button`
    padding: 0;
    border: none;
    outline: none;
    background-color: ${p => p.color || p.theme.secondaryBackground};
    border-radius: 6px;
    color: ${p => p.colorSite || p.theme.primaryForeground};
    cursor: pointer;
    padding: 8px;
    box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
`;
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
// EXTERNAL MODULE: ./src/app/components/ElementTag/index.tsx
var ElementTag = __webpack_require__(2175);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/fullHeart.tsx
var fullHeart = __webpack_require__(4605);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/heart.tsx
var heart = __webpack_require__(488);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/star.tsx
var star = __webpack_require__(8409);
// EXTERNAL MODULE: ./node_modules/next/image.js
var next_image = __webpack_require__(5675);
;// CONCATENATED MODULE: ./src/assets/icons/social/like-regular.png
/* harmony default export */ const like_regular = ({"src":"/_next/static/image/src/assets/icons/social/like-regular.b6c8a708b005257bbd72458b4a22a1b1.png","height":24,"width":25,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAmUlEQVR42lWMwQoBYRSFjyEb8QKEZKNskBIJS6NkQ2Ixisk/jzPzv7Dvapr6T53OvV/nXv3lilqZiZz/4LYQGSnQ1+8pbeXybsUALaW+SU7xDs/xS5k/8GFkb66AO77JlBYRbEChD3uIYcXLGUtPCgWLrbChsGAZl7DObl8azBcrrAFLlmF47Tuwkw1PhgS/leVH8kzGpPHJD1MwN4xY7dHQAAAAAElFTkSuQmCC"});
;// CONCATENATED MODULE: ./src/assets/icons/social/like-solid.png
/* harmony default export */ const like_solid = ({"src":"/_next/static/image/src/assets/icons/social/like-solid.a6e20b50f6dd552ce6be3c7b08739a7f.png","height":24,"width":25,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAtUlEQVR4nDWPvQ3CQBSDfeJHSNTMgITEAIEFKCgiZQBER1agZYOkpqahoKGigoIFYAt6EEjBfK8gki9+ts93l1RWklNLUgOWDIWU5kpuy2qSVjWmgT5gAdZgqMRqoiprSDAU+4g8AhlOn8AjGrY4F8ScUI74ZX4T6MGvEWC7z1RknNslyBx1fPadQIWgA5iya4BNAxdO6sB3cQdDTogTxDiXgv/qTTTcGPZghjTGevKPJ77IFD/EKT7gvXgX1AAAAABJRU5ErkJggg=="});
;// CONCATENATED MODULE: ./src/assets/icons/social/comments.png
/* harmony default export */ const comments = ({"src":"/_next/static/image/src/assets/icons/social/comments.c4010869b8524584cf46bceb58a232d5.png","height":27,"width":29,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAHCAYAAAA1WQxeAAAAh0lEQVR42i3OuwrCQBBG4VNZWaazUIOtRRIIbISIomBhFfIO2X0R+2Rf2FNs8c3MD3sZiBuqNZFyZw/Y1TrPWJ56s2w3ltyoNw9mNGK46+yNh/bOqCWtlYcD5dlRUTNx7XXwwMn8xfJRpaN6XUr/qcbSaZK75MEXg3Pj/1f7Dgt6le1LVhLwB5OYP+EoIPIBAAAAAElFTkSuQmCC"});
// EXTERNAL MODULE: ./src/core/hooks/useClient.ts
var useClient = __webpack_require__(7568);
// EXTERNAL MODULE: ./src/core/hooks/useAdventure.ts
var useAdventure = __webpack_require__(3802);
// EXTERNAL MODULE: ./src/core/services/api.ts
var api = __webpack_require__(6402);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
;// CONCATENATED MODULE: ./src/app/components/CardAdventureCommunity/index.tsx




















function CardAdventureCommunity(props) {
  var _props$adventure, _props$adventure2, _props$adventure3, _props$adventure4, _props$adventure4$ave, _props$adventure5, _props$adventure6, _props$adventure7, _props$adventure8, _props$adventure10, _props$adventure10$av;

  const {
    t
  } = (0,external_next_i18next_.useTranslation)();
  const {
    saveDataFollow,
    saveDataUnFollow
  } = (0,useClient/* default */.Z)();
  const {
    favoriteAdventure,
    desfavoriteAdventure,
    getDataRating
  } = (0,useAdventure/* default */.Z)();
  const {
    0: seCurtido,
    1: setSeCurtido
  } = (0,external_react_.useState)(props.adventure.seCurtida == "S" ? true : false);
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);
  const {
    0: seSeguindo,
    1: setSeSeguindo
  } = (0,external_react_.useState)(props.adventure.seSeguindo == "S" ? true : false);
  const {
    0: visibleModalComentarios,
    1: setVisibleModalComentarios
  } = (0,external_react_.useState)(false);
  const {
    seguirCardsIguais,
    mudarSeguindo,
    naoSeguirCardsIguais
  } = props;
  const {
    0: listRating,
    1: setListRating
  } = (0,external_react_.useState)([]);
  (0,external_react_.useEffect)(() => {
    if (mudarSeguindo > 0) if (props.adventure.seSeguindo == "S") {
      setSeSeguindo(true);
    } else {
      setSeSeguindo(false);
    }
  }, [mudarSeguindo]);

  const handleFavoriteOrDesfavorite = async event => {
    event.preventDefault();

    if (props.adventure.aventura.id) {
      if (props.adventure.aventura.seFavorita === "N") {
        await favoriteAdventure(props.adventure.aventura.id).then(() => {
          props.adventure.aventura.seFavorita = "S";
        });
      } else {
        await desfavoriteAdventure(props.adventure.aventura.id).then(() => {
          props.adventure.aventura.seFavorita = "N";
        });
      }
    }

    forceUpdate();
  };

  const followOrUnfollow = async (event, followingOrUnfollowing) => {
    if (followingOrUnfollowing) {
      setSeSeguindo(true);
      seguirCardsIguais(event.idCliente);
      const response = await saveDataFollow(event);

      if (response.status == 200) {
        props.adventure.seSeguindo = "S";
      }
    } else {
      setSeSeguindo(false);
      naoSeguirCardsIguais(event.idCliente);
      const response = await saveDataUnFollow(event);

      if (response.status == 200) {
        props.adventure.seSeguindo = "N";
      }
    }

    forceUpdate();
  };

  function handleLike() {
    setSeCurtido(true);
    api/* default.post */.Z.post("/WS/ClienteAventura/" + props.adventure.id + "/Curtir", null).then(() => {});
  }

  function handleDislike() {
    setSeCurtido(false);
    api/* default.post */.Z.post("/WS/ClienteAventura/" + props.adventure.id + "/Descurtir", null).then(() => {});
  }

  const handleClickRating = async adventureId => {
    const response = await getDataRating(adventureId);
    setListRating(response.data);
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: "Comentarios",
      visible: visibleModalComentarios,
      style: {
        width: '50vw'
      },
      onHide: () => setVisibleModalComentarios(!visibleModalComentarios),
      children: listRating.length ? listRating.map(item => {
        return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
            style: {
              borderBottom: '1px solid whitesmoke'
            },
            children: [/*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(ProfileImage, {
              url: item.urlFotoCliente || "../assets/perfil-default.png"
            }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(TextHeaderProfile, {
              children: ["Nota: ", item === null || item === void 0 ? void 0 : item.notaAvaliacao]
            }), " ", /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(Title, {
              children: (item === null || item === void 0 ? void 0 : item.nomeCliente) + ' - ' + (item === null || item === void 0 ? void 0 : item.dataAvaliacao)
            }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(TextHeaderProfile, {
              children: item === null || item === void 0 ? void 0 : item.descricaoAvaliacao
            })]
          })
        });
      }) : 'Nenhum comentario'
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(CardContent, {
      align: "top",
      children: [/*#__PURE__*/jsx_runtime_.jsx(ProfileImage, {
        url: props.adventure.urlFotoCliente || "/assets/perfil-default.png"
      }), /*#__PURE__*/jsx_runtime_.jsx(InfoContainerHeaderProfile, {
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
          style: {
            marginLeft: '10px'
          },
          children: [" ", props.adventure.nome, " "]
        })
      }), seSeguindo && props.adventure.seSeguindo == "S" ? /*#__PURE__*/jsx_runtime_.jsx(Button, {
        colorSite: "",
        color: "",
        onClick: () => followOrUnfollow(props.adventure, false),
        children: " Seguindo "
      }) : /*#__PURE__*/jsx_runtime_.jsx(Button, {
        colorSite: "#0084B9",
        color: "white",
        onClick: () => followOrUnfollow(props.adventure, true),
        children: " Seguir "
      })]
    }), /*#__PURE__*/jsx_runtime_.jsx(next_link.default, {
      href: `/adventure-details/${props.adventure.aventura.id}/${(_props$adventure = props.adventure) === null || _props$adventure === void 0 ? void 0 : _props$adventure.aventura.slug}`,
      passHref: true,
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
        children: [/*#__PURE__*/jsx_runtime_.jsx(FavoriteContainer, {
          onClick: event => handleFavoriteOrDesfavorite(event),
          children: props.adventure.aventura.seFavorita === "S" ? /*#__PURE__*/jsx_runtime_.jsx(fullHeart/* default */.Z, {
            width: 24,
            height: 26
          }) : /*#__PURE__*/jsx_runtime_.jsx(heart/* default */.Z, {
            fill: "#FFFFFF",
            width: 24,
            height: 26
          })
        }), ((_props$adventure2 = props.adventure) === null || _props$adventure2 === void 0 ? void 0 : _props$adventure2.aventura.avaliacao) && !isNaN((_props$adventure3 = props.adventure) === null || _props$adventure3 === void 0 ? void 0 : _props$adventure3.aventura.avaliacao) && /*#__PURE__*/(0,jsx_runtime_.jsxs)(RatingContainer, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(star/* default */.Z, {}), /*#__PURE__*/jsx_runtime_.jsx(Text, {
            children: parseFloat((_props$adventure4 = props.adventure) === null || _props$adventure4 === void 0 ? void 0 : (_props$adventure4$ave = _props$adventure4.aventura.avaliacao) === null || _props$adventure4$ave === void 0 ? void 0 : _props$adventure4$ave.toString()).toFixed(1)
          })]
        }), /*#__PURE__*/jsx_runtime_.jsx(Image, {
          url: (_props$adventure5 = props.adventure) === null || _props$adventure5 === void 0 ? void 0 : _props$adventure5.aventura.urlFoto,
          children: /*#__PURE__*/jsx_runtime_.jsx(Element, {
            children: /*#__PURE__*/jsx_runtime_.jsx(ElementTag/* default */.ZP, {
              adventureType: (_props$adventure6 = props.adventure) === null || _props$adventure6 === void 0 ? void 0 : _props$adventure6.aventura.tipo
            })
          })
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InfoContainer, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Title, {
            children: (_props$adventure7 = props.adventure) === null || _props$adventure7 === void 0 ? void 0 : _props$adventure7.aventura.titulo
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            children: [t("where"), ": ", (_props$adventure8 = props.adventure) === null || _props$adventure8 === void 0 ? void 0 : _props$adventure8.aventura.local]
          })]
        })]
      })
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(CardContent, {
      align: "bottom",
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        children: [seCurtido == false && /*#__PURE__*/jsx_runtime_.jsx(next_image.default, {
          onClick: handleLike,
          src: like_regular,
          alt: "like"
        }), seCurtido == true && /*#__PURE__*/jsx_runtime_.jsx(next_image.default, {
          onClick: handleDislike,
          src: like_solid,
          alt: "dislike"
        })]
      }), /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        onClick: () => setVisibleModalComentarios(!visibleModalComentarios),
        children: [/*#__PURE__*/jsx_runtime_.jsx(next_image.default, {
          src: comments,
          onClick: () => {
            var _props$adventure9, _props$adventure9$ave;

            return handleClickRating((_props$adventure9 = props.adventure) === null || _props$adventure9 === void 0 ? void 0 : (_props$adventure9$ave = _props$adventure9.aventura) === null || _props$adventure9$ave === void 0 ? void 0 : _props$adventure9$ave.id);
          }
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
          children: [" ", (_props$adventure10 = props.adventure) === null || _props$adventure10 === void 0 ? void 0 : (_props$adventure10$av = _props$adventure10.aventura) === null || _props$adventure10$av === void 0 ? void 0 : _props$adventure10$av.quantidadeAvaliacoes, " "]
        })]
      })]
    })]
  });
}

/* harmony default export */ const components_CardAdventureCommunity = (/*#__PURE__*/external_react_default().memo(CardAdventureCommunity));
;// CONCATENATED MODULE: ./src/pages/community/styles.ts

const CardContainer = (external_styled_components_default()).a`
    margin: 10px 0 10px 0;
    cursor: pointer;
    min-width: 300px;
    min-height: 440px;

    @media screen and (max-width: 767px) {
        width: 100%;
    }
`;
const CardsGrid = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    margin: auto;
    gap: 10px;
`;
const NoData = (external_styled_components_default()).div`
    margin: auto;
    margin-top: 50px;

    h2 {
        text-align: center;
    }
`;
// EXTERNAL MODULE: external "react-paginate"
var external_react_paginate_ = __webpack_require__(6495);
var external_react_paginate_default = /*#__PURE__*/__webpack_require__.n(external_react_paginate_);
;// CONCATENATED MODULE: ./src/pages/community/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











function Community(props) {
  const {
    getCommunityAdventures
  } = (0,useAdventure/* default */.Z)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)();
  const {
    0: queryPage,
    1: setQueryPage
  } = (0,external_react_.useState)({
    page: 0,
    size: 10
  });
  const {
    0: dataContent,
    1: setDataContent
  } = (0,external_react_.useState)({});
  const {
    0: mudarSeSeguindo,
    1: setMudarSeSeguindo
  } = (0,external_react_.useState)(0);
  const getCommunityAdventuresDto = (0,external_react_.useCallback)(async queryPage => {
    const response = await getCommunityAdventures(queryPage);
    setDataContent(response.data);
  }, []);

  const seguirCardsIguais = id => {
    for (let index = 0; index < dataContent.content.length; index++) {
      if (dataContent.content[index].idCliente == id) {
        dataContent.content[index].seSeguindo = "S";
      }
    }

    setDataContent(dataContent);
    setMudarSeSeguindo(mudarSeSeguindo + 1);
  };

  const naoSeguirCardsIguais = id => {
    for (let index = 0; index < dataContent.content.length; index++) {
      if (dataContent.content[index].idCliente == id) {
        dataContent.content[index].seSeguindo = "N";
      }
    }

    setDataContent(dataContent);
    setMudarSeSeguindo(mudarSeSeguindo + 1);
  };

  (0,external_react_.useEffect)(() => {
    getCommunityAdventuresDto(queryPage);
  }, []);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
    children: [/*#__PURE__*/jsx_runtime_.jsx((head_default()), {
      children: /*#__PURE__*/jsx_runtime_.jsx("title", {
        children: "Relty - Comunidade"
      })
    }), dataContent.content && dataContent.content.length > 0 ? /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(CardsGrid, {
        children: dataContent === null || dataContent === void 0 ? void 0 : dataContent.content.map(item => /*#__PURE__*/jsx_runtime_.jsx(CardContainer, {
          children: /*#__PURE__*/jsx_runtime_.jsx(components_CardAdventureCommunity, {
            adventure: item,
            mudarSeguindo: mudarSeSeguindo,
            naoSeguirCardsIguais: naoSeguirCardsIguais,
            seguirCardsIguais: seguirCardsIguais
          })
        }, item.id))
      }), /*#__PURE__*/jsx_runtime_.jsx((external_react_paginate_default()), {
        forcePage: queryPage.page - 1,
        "data-content": "My Content",
        containerClassName: "Pagination",
        pageCount: dataContent !== null && dataContent !== void 0 && dataContent.totalPages ? dataContent === null || dataContent === void 0 ? void 0 : dataContent.totalPages : 0,
        marginPagesDisplayed: 0,
        pageRangeDisplayed: 3,
        previousLabel: "<",
        nextLabel: ">",
        onPageChange: page => getCommunityAdventuresDto({
          page: page.selected,
          size: queryPage.size
        })
      })]
    }) : /*#__PURE__*/jsx_runtime_.jsx(NoData, {
      children: /*#__PURE__*/jsx_runtime_.jsx("h2", {
        children: t("noResults")
      })
    }), /*#__PURE__*/jsx_runtime_.jsx("br", {})]
  });
}
;
const getServerSideProps = async ctx => {
  const {
    query,
    resolvedUrl
  } = ctx;
  const {
    page: _page
  } = query;
  let language = (0,external_nookies_.parseCookies)(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return util/* Util.redirectToSelectedLanguage */.Z.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: _objectSpread({}, await (0,serverSideTranslations_.serverSideTranslations)(ctx.locale, ["common"]))
  };
};

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 3295:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 9325:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 822:
/***/ ((module) => {

module.exports = require("next/dist/server/image-config.js");

/***/ }),

/***/ 6695:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 8300:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 5378:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 7162:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 8773:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 2248:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 9372:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 665:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 2747:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 333:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 3456:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 556:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/to-base-64.js");

/***/ }),

/***/ 7620:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 6495:
/***/ ((module) => {

module.exports = require("react-paginate");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [1664,5675,5548,3802,6089,8409,7568,8394], () => (__webpack_exec__(7066)));
module.exports = __webpack_exports__;

})();