"use strict";
(() => {
var exports = {};
exports.id = 2888;
exports.ids = [2888];
exports.modules = {

/***/ 141:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ _app)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: ./src/styles/theme.ts
var theme = __webpack_require__(8315);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
;// CONCATENATED MODULE: ./src/styles/globaStyles.ts




var cookie = (0,external_nookies_.parseCookies)().language;
/* harmony default export */ const globaStyles = (external_styled_components_.createGlobalStyle`

    *{
        margin:0;

        padding: 0;

        box-sizing: border-box;
    }

    html,
    body{
        overflow-x:hidden;
    }

    body{
        background-color: ${p => p.theme.pageBackground};
        color: ${p => p.theme.pageForeground};
        font-family: 'Poppins', sans-serif;
    }

  .Pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    list-style: none;
    margin-top:25px;
    li {
      a {
        padding: 0 8px;
        min-width: 28px;
        height: 34px;
        transition: .25s ease;
        display: flex;
        justify-content: center;
        align-items: center;
        text-decoration: none;
        background-color: ${p => p.theme.inactiveElementBackground};
        color: ${p => p.theme.inactiveElementForeground};
        border-radius: ${p => p.theme.borderRadius};
        font-size: 12px;
        margin: 0 2px;
      }
      &.disabled a {
        cursor: not-allowed;
        opacity: ${p => p.theme.inactiveElementOpacity};
      }
      &.selected a {
        background-color: ${p => p.theme.primaryBackground};
        color: ${p => p.theme.primaryForeground};
        cursor: default;
        &::before {
          content: "${() => cookie == "en" ? "Page" : "Página"}";;
          display: inline-block;
          margin-right: 4px;
        }
      }
      &:not(.selected,.disabled) {
        &:hover,
        &:focus {
          a {
            transform: translateY(-3px);
            box-shadow: 0 3px 6px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
          }
        }
      }
    }
  }
  // ------- overwrite css input prime react
    .p-inputtext {
      background: #ffffff 0% 0% no-repeat padding-box;
      box-shadow: 0px 3px 10px #00000021;
      border-radius: 4px;
      opacity: 1;
      width: 100%;
      border: none;
      font-family: 'Poppins', sans-serif;
      
      &::placeholder {
        color: #c3c3c3;
        font-size: 16px;
      }
    
    }
    .p-input-icon-left {
      width: 100%;
      font-size: 16px;
      .p-inputtext:enabled:hover {
        border-color: none;
      }
      .p-inputtext:enabled:focus {
        background: #ffffff 0% 0% no-repeat padding-box;
        box-shadow: 0px 3px 10px #00000021;
      }
    }
      .p-inputtext-md{
        height: 45px;
      }
  // ------- overwrite css input prime react

  // ------- overwrite css Dialog prime react
  .p-dialog {
    width: 500px;
    min-width: 300px;
    max-width: 500px;
    margin: 10px;
    font-family: "Poppins", sans-serif;
    border-radius: ${p => p.theme.borderRadius};
    p {
      text-align: center;
    }

    .p-dialog-header-icons {
      .p-dialog-header-icon {
        border: none;
        :active,
        &:focus {
          box-shadow: 0 0 0 2px ${p => (0,external_polished_.transparentize)(0.7, p.theme.primaryBackground)};
        }
      }
    }
    
  }


  // ------- overwrite css Dialog prime react




   // ------- overwrite css Sidebar prime react


  .p-component-overlay{
      height: 100vh;

  } 
  .p-sidebar{
    font-family: 'Poppins', sans-serif;
    box-shadow: 0 3px 6px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    color: ${p => p.theme.pageForeground};
    list-style: none;
    height: 100%;
    max-width: 240px;

    h3 {
      text-align: center;
    }

    .li-active{
        background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.inactiveElementBackground)};
      
      }

    li{
      width: 100%;
      border-bottom: 1px solid ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
    }

      a {
        height: 40px;
        color: ${p => p.theme.pageForeground};
        text-decoration: none;
        text-transform: capitalize;
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
        padding-left:10px;
       

        text {
          width: 90%;
          text-align: left;
          font: normal normal 600 12px/13px Poppins;
          letter-spacing: 0px;
          color: #006993;
          opacity: 1;
        }
        &:hover,
        &:focus,
        &:active {
          color: ${p => p.theme.activeElementForeground};
          background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.inactiveElementBackground)};
        }
    }

    .p-sidebar-content{
      padding: 0 0;
      margin: 0 0 0 0;
      height: 100%;

      .logout-item{
        cursor: pointer;
        position: absolute;
        bottom: 0px;
        width: 100%;
        display: flex;
        align-self: flex-end;
        border: none;

        text{
          color:${p => p.theme.red}
        }

        li{
          border: none;
        }
      }
    }

    .p-sidebar-header .p-sidebar-close:enabled:hover,
    .p-sidebar-header .p-sidebar-icon{
      border: none;

      :enabled:hover {
        color: #495057;
        border-color: transparent;
        background:  ${p => (0,external_polished_.transparentize)(0.8, p.theme.inactiveElementBackground)};
      }
      :active,
      &:focus {
        box-shadow: 0 0 0 2px ${p => (0,external_polished_.transparentize)(0.7, p.theme.primaryBackground)};
      }
    }
}


 // ------- overwrite css Sidebar prime react

 // ------- Formik form
  .form-control {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    margin: 20px 0;
    background-color: transparent;
  }
 // ------- Formik form


  // ------- Prime Checkbox

  .p-checkbox .p-checkbox-box.p-highlight {
    border-color: ${p => p.theme.primaryBackground};
    background: ${p => p.theme.primaryBackground};
  } 
  .p-checkbox .p-checkbox-box.p-highlight:not(.p-disabled):hover {
    border-color: ${p => p.theme.secondaryBackground};
    background: ${p => p.theme.secondaryBackground};
    color: #ffffff;
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box:hover {
    border-color: ${p => p.theme.primaryBackground};
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-focus {
    outline: 0 none;
    outline-offset: 0;
    box-shadow: 0 0 0 2px ${p => (0,external_polished_.transparentize)(0.7, p.theme.primaryBackground)};
    border-color: ${p => p.theme.primaryBackground};
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-highlight:hover {
    border-color: ${p => p.theme.secondaryBackground};
    background: ${p => p.theme.secondaryBackground};
    color: #ffffff;
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-focus {
    outline: 0 none;
    outline-offset: 0;
    box-shadow: 0 0 0 2px ${p => (0,external_polished_.transparentize)(0.7, p.theme.primaryBackground)};
    border-color: ${p => p.theme.primaryBackground};;
  }
  .p-field-checkbox{
    label{
      font-size: 14px;
    }
  }
  // ------- Prime Checkbox


//Google map css
.gm-style .gm-style-iw-c {
  padding: 0;
}
.gm-style-iw-d{
  overflow: auto !important;
  
}
.gm-ui-hover-effect{
  width: 25px !important;;
  height: 25px !important;;
  background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.activeElementBackground)} !important;
  position: absolute !important;
  right: 5px !important;
  top: 5px !important;
  padding: 0 0 !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  border-radius: 100px;
  
  img{
    width: 20px !important;
    height: auto !important;
    margin: auto !important;
    align-self: center !important;
    align-items: center !important;
  }

}

//Google map css

//Map cluster

.cluster{
  object-fit: cover;
  display: flex;
  justify-content: center;
  align-items: center;

  img{
    height: auto;
    width:100%;
  }

}
//Map cluster


/// primeReact Menu override css
  .p-tieredmenu {
    border-radius: ${p => p.theme.borderRadius}
  }

  .p-submenu-list .p-submenu-list-flipped{
    border-radius: ${p => p.theme.borderRadius}
  }
  .p-submenu-list{
    border-radius: ${p => p.theme.borderRadius}
  }

  .p-menuitem .p-menuitem-active{
    background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.inactiveElementBackground)};
  }

  .p-tieredmenu .p-menuitem-link .p-menuitem-text {
    color: #495057;
    font-family: Poppins;
  }

  /// primeReact Menu override css


  /// Input swtich
  .p-inputswitch .p-inputswitch-slider {
    background: ${p => p.theme.inactiveElementBackground};
    transition: background-color 0.2s, color 0.2s, border-color 0.2s, box-shadow 0.2s;
    border-radius: 30px;
  }

  .p-inputswitch.p-inputswitch-checked .p-inputswitch-slider {
    background: ${p => p.theme.primaryBackground};
  }

  .p-inputswitch.p-inputswitch-checked:not(.p-disabled):hover .p-inputswitch-slider {
    background: ${p => p.theme.secondaryBackground};
  }
  
  .mini-switch{
    .p-inputswitch{
      position: absolute;
      right: 18px;
      height: 20px;
      width: 40px;
  
    }
    .p-inputswitch .p-inputswitch-slider:before {
      background: #ffffff;
      width: 15px;
      height: 15px;
      left: 0.15rem;
      margin-top: -0.475rem;
      border-radius: 50%;
      -webkit-transition-duration: 0.2s;
      transition-duration: 0.2s;
    }
  }

  .Dropdown-arrow{
      top: 20px;
  }

  .select-filter{
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    padding: 6px 12px;
    font-size: 16px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    background: #ffffff 0% 0% no-repeat padding-box;
    box-shadow: 0px 3px 10px #00000021;
    border-color: none;
    border: none;
    outline: none;
    padding-left: 40px;
    height: 45px;
    font-family: "Poppins";
  }

    .Dropdown-control {
        :hover{
          box-shadow: 0px 3px 10px #00000021;
        }
      }

    .dropdown-filter{
      border: none;
      border-radius: ${p => p.theme.borderRadius};
      .Dropdown-option{
        :hover{
          background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.inactiveElementBackground)};
        }
      }
      .is-selected{
        background-color: ${p => (0,external_polished_.transparentize)(0.6, p.theme.inactiveElementBackground)};
      }
    }

  /// Datatable override

  .datatable-responsive .p-datatable-responsive .p-datatable-tbody > tr > td .p-column-title {
      display: none;
  }

  .datatable-responsive .p-datatable-responsive .p-datatable-tbody > tr > td {
    text-align: center;
    word-break: break-all;
  }

  .datatable-responsive .p-datatable-responsive .p-datatable-thead > tr > th {
    text-align: center;
  }

  @media screen and (max-width: 50em) {
      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-thead > tr > th,
      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tfoot > tr > td {
          display: none !important;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td {
          text-align: left;
          display: block;
          width: 100%;
          float: left;
          clear: left;
          border: 0 none;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td .p-column-title {
          padding: .4rem;
          min-width: 30%;
          display: inline-block;
          margin: -.4em 1em -.4em -.4rem;
          font-weight: bold;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td:last-child {
          border-bottom: 1px solid var(--surface-d);
      }
  }

  /*========== SCROLL BAR ==========*/
  ::-webkit-scrollbar{
      width: .60rem;
      background-color: hsl(230, 12%, 90%);
      border-radius: .5rem;
  }

  ::-webkit-scrollbar-thumb{
      background-color: hsl(230, 12%, 80%);
      border-radius: .5rem;
  }

  ::-webkit-scrollbar-thumb:hover{
      background-color: hsl(230, 8%, 65%);
  }
`);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
;// CONCATENATED MODULE: ./src/app/components/Logo/index.tsx





function Logo() {
  return /*#__PURE__*/jsx_runtime_.jsx(next_link.default, {
    href: "/home?page=1",
    passHref: true,
    children: /*#__PURE__*/jsx_runtime_.jsx(Wrapper, {})
  });
}

/* harmony default export */ const components_Logo = (Logo);
const Wrapper = (external_styled_components_default()).div`
  height: 100%;
  width: 150px;
  cursor: pointer;
  background-image: url("/assets/logo.png");
  background-position: center;
  background-size: cover;
`;
// EXTERNAL MODULE: ./src/app/components/SvgIcons/heart.tsx
var heart = __webpack_require__(488);
// EXTERNAL MODULE: ./src/app/components/WithAuthModal/index.tsx + 1 modules
var WithAuthModal = __webpack_require__(1629);
;// CONCATENATED MODULE: external "primereact/sidebar"
const sidebar_namespaceObject = require("primereact/sidebar");
// EXTERNAL MODULE: ./node_modules/react-icons/io5/index.esm.js
var index_esm = __webpack_require__(155);
// EXTERNAL MODULE: ./node_modules/react-icons/ri/index.esm.js
var ri_index_esm = __webpack_require__(9352);
;// CONCATENATED MODULE: external "primereact/tieredmenu"
const tieredmenu_namespaceObject = require("primereact/tieredmenu");
// EXTERNAL MODULE: external "primereact/inputswitch"
var inputswitch_ = __webpack_require__(1775);
// EXTERNAL MODULE: ./node_modules/react-icons/ai/index.esm.js
var ai_index_esm = __webpack_require__(8193);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
// EXTERNAL MODULE: ./src/core/contexts/UserContext.tsx
var UserContext = __webpack_require__(9263);
// EXTERNAL MODULE: ./src/core/hooks/useAuth.ts
var useAuth = __webpack_require__(7471);
// EXTERNAL MODULE: ./src/core/hooks/useUser.ts
var useUser = __webpack_require__(5980);
// EXTERNAL MODULE: ./src/core/contexts/PreferencesContext.tsx
var PreferencesContext = __webpack_require__(7909);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
;// CONCATENATED MODULE: ./src/app/components/SvgIcons/adventure.tsx


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



function Adventures(props) {
  return /*#__PURE__*/jsx_runtime_.jsx("svg", _objectSpread(_objectSpread({
    xmlns: "http://www.w3.org/2000/svg",
    width: 26.209,
    height: 26.21
  }, props), {}, {
    children: /*#__PURE__*/jsx_runtime_.jsx("path", {
      d: "M25.97 4.335l-2.217-2.217a1.638 1.638 0 00-1.158-.48h-7.852V.819A.819.819 0 0013.924 0h-1.638a.819.819 0 00-.819.819v.819h-8.6a1.229 1.229 0 00-1.229 1.228v4.1A1.229 1.229 0 002.867 8.19h19.731a1.638 1.638 0 001.158-.48l2.217-2.217a.818.818 0 00-.003-1.158zm-14.5 21.056a.819.819 0 00.819.819h1.638a.819.819 0 00.819-.819v-5.734h-3.281v5.734zm11.874-13.924h-8.6V9.829h-3.276v1.638H3.616a1.638 1.638 0 00-1.158.48L.24 14.164a.819.819 0 000 1.158l2.218 2.218a1.638 1.638 0 001.158.48h19.728a1.229 1.229 0 001.229-1.229V12.7a1.23 1.23 0 00-1.229-1.233z",
      fill: "#006993"
    })
  }));
}

/* harmony default export */ const adventure = (Adventures);
// EXTERNAL MODULE: ./node_modules/react-icons/fa/index.esm.js
var fa_index_esm = __webpack_require__(9583);
;// CONCATENATED MODULE: ./src/app/components/NavBar/index.tsx

























function NavBar({
  setAuthModalOnLogin
}) {
  const {
    0: showSideBar,
    1: setShowSideBar
  } = (0,external_react_.useState)(false);
  const theme = (0,external_styled_components_.useTheme)();
  const {
    user,
    isAuthenticated
  } = (0,UserContext/* useUserContext */.SE)();
  const {
    changeLanguage,
    preferences
  } = (0,PreferencesContext/* usePreferencesContext */.A0)();
  const {
    0: isMobile,
    1: setIsMobile
  } = (0,external_react_.useState)(false);
  const {
    t
  } = (0,external_next_i18next_.useTranslation)('common');
  const menu = (0,external_react_.useRef)();
  const menuLanguage = (0,external_react_.useRef)();
  const {
    logout
  } = (0,useAuth/* default */.Z)();
  const {
    alterProfile
  } = (0,useUser/* default */.Z)();
  const {
    0: isSupplier,
    1: setIsSupplier
  } = (0,external_react_.useState)((user === null || user === void 0 ? void 0 : user.perfilAtual) == 'E' ? true : false);
  const {
    0: isAdmin,
    1: setIsAdmin
  } = (0,external_react_.useState)(false);

  const hideSideBar = () => {
    setShowSideBar(false);
  };

  const hideMenu = () => {
    var _menu$current;

    (_menu$current = menu.current) === null || _menu$current === void 0 ? void 0 : _menu$current.hide();
  };

  const getClassActive = href => {
    try {
      return href.includes(window.location.pathname) ? 'li-active' : '';
    } catch (error) {
      return '';
    }
  };

  const SidebarMobileItem = ({
    href = '/',
    icon,
    text,
    needAuth
  }) => {
    if (needAuth && !isAuthenticated) {
      return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    }

    return /*#__PURE__*/jsx_runtime_.jsx("li", {
      className: getClassActive(href),
      children: /*#__PURE__*/jsx_runtime_.jsx(next_link.default, {
        href: href,
        passHref: true,
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
          children: [icon, /*#__PURE__*/(0,jsx_runtime_.jsxs)(MobileItemName, {
            children: [" ", text]
          })]
        })
      })
    });
  };

  const SidebarMobileItemWithoutLink = ({
    icon,
    text,
    needAuth,
    onClick,
    withSwitch = false
  }) => {
    if (needAuth && !isAuthenticated) {
      return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    }

    return /*#__PURE__*/jsx_runtime_.jsx("li", {
      onClick: onClick,
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
        className: ' mini-switch',
        children: [icon, /*#__PURE__*/(0,jsx_runtime_.jsxs)(MobileItemName, {
          children: [" ", text]
        }), withSwitch && /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
          checked: isSupplier,
          onChange: e => {
            handleAlterProfile(!isSupplier);
          }
        })]
      })
    });
  };

  const SidebarMobileItemWithoutLinkAdmin = ({
    icon,
    text,
    needAuth,
    onClick,
    withSwitch = false
  }) => {
    if (needAuth && !isAuthenticated) {
      return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    }

    return /*#__PURE__*/jsx_runtime_.jsx("li", {
      onClick: onClick,
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
        className: " mini-switch",
        children: [icon, /*#__PURE__*/(0,jsx_runtime_.jsxs)("text", {
          children: [" ", text]
        }), withSwitch && /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
          checked: isAdmin,
          onChange: e => {
            handleAlterProfileAdmin(!isAdmin);
          }
        })]
      })
    });
  };

  const SidebarItem = ({
    href = "",
    icon,
    text,
    needAuth
  }) => {
    if (needAuth && !isAuthenticated) {
      return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    }

    return /*#__PURE__*/jsx_runtime_.jsx("li", {
      children: /*#__PURE__*/jsx_runtime_.jsx(next_link.default, {
        href: href,
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
          children: [icon, /*#__PURE__*/(0,jsx_runtime_.jsxs)("text", {
            children: [" ", text]
          })]
        })
      })
    });
  };

  const SidebarItemWithoutLink = ({
    icon,
    text,
    needAuth,
    onClick
  }) => {
    if (needAuth && !isAuthenticated) {
      return /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {});
    }

    return /*#__PURE__*/jsx_runtime_.jsx("li", {
      onClick: onClick,
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
        children: [icon, /*#__PURE__*/(0,jsx_runtime_.jsxs)("text", {
          children: [" ", text]
        })]
      })
    });
  };

  const CustomMenuItem = (item, options, withSwitch = false, url) => {
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
      className: options.className + ' mini-switch',
      style: item.style,
      target: item.target,
      onClick: options.onClick,
      children: [/*#__PURE__*/jsx_runtime_.jsx("span", {
        className: options.iconClassName,
        style: item.style,
        children: url && /*#__PURE__*/jsx_runtime_.jsx(LanguageIcon, {
          url: url
        })
      }), /*#__PURE__*/jsx_runtime_.jsx("span", {
        className: options.labelClassName,
        style: item.style,
        children: item.label
      }), withSwitch && /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
        checked: isSupplier,
        onChange: e => {
          handleAlterProfile(!isSupplier);
        }
      })]
    });
  };

  const CustomMenuItemAdmin = (item, options, withSwitch = false, url) => {
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
      className: options.className + " mini-switch",
      style: item.style,
      target: item.target,
      onClick: options.onClick,
      children: [/*#__PURE__*/jsx_runtime_.jsx("span", {
        className: options.iconClassName,
        style: item.style,
        children: url && /*#__PURE__*/jsx_runtime_.jsx(LanguageIcon, {
          url: url
        })
      }), /*#__PURE__*/jsx_runtime_.jsx("span", {
        className: options.labelClassName,
        style: item.style,
        children: item.label
      }), withSwitch && /*#__PURE__*/jsx_runtime_.jsx(inputswitch_.InputSwitch, {
        checked: isAdmin,
        onChange: e => {
          handleAlterProfileAdmin(!isAdmin);
        }
      })]
    });
  };

  const getImageUrlByProfile = () => {
    let imageUrl = "/assets/perfil-default.png";

    if (user.perfilAtual == "E" && user.urlFotoEstabelecimento) {
      imageUrl = user.urlFotoEstabelecimento;
    }

    if (user.perfilAtual == "C" && user.urlFotoCliente) {
      imageUrl = user.urlFotoCliente;
    }

    if (!isSupplier && isAdmin) {
      imageUrl = "/assets/perfil-default.png";
    }

    return imageUrl;
  };

  const getImageByLanguage = () => {
    if (preferences.language === 'en') {
      return '/assets/english.png';
    } else if (preferences.language === 'es') {
      return '/assets/spain.png';
    }

    return '/assets/brazil.png';
  };

  const handleAlterProfile = async isSupplier => {
    await alterProfile(isSupplier ? 'E' : 'C');
    setIsSupplier(isSupplier);
    setIsAdmin(false);
  };

  const handleAlterProfileAdmin = async isAdmin => {
    setIsAdmin(isAdmin);
    setIsSupplier(false);
  };

  const openTerms = () => {
    window.open('https://reltyapp.com.br/termos-usuario');
    hideMenu();
  };

  const sendToFriends = async () => {
    if (isMobile) {
      const shareData = {
        title: t("downloadRelty"),
        text: t("downloadRelty") + " " + "https://reltyapp.com.br"
      };
      await navigator.share(shareData);
    } else {
      window.open('https://api.whatsapp.com/send?text=' + t('downloadRelty') + ' ' + 'https://reltyapp.com.br', '_blank');
    }

    hideMenu();
  };

  const itemsRender = () => {
    if (user.seAdministrador == 'S') {
      return [{
        label: t("editProfileMenu"),
        icon: "pi pi-fw pi-pencil",
        command: () => {
          router_default().push(`/profiles/${isSupplier ? "supplier" : "user"}`);
        }
      }, {
        icon: "pi pi-fw pi pi-home",
        label: t("supplier"),
        template: (item, options) => CustomMenuItem(item, options, true)
      }, {
        icon: "pi pi-fw pi pi-user",
        label: "Admin",
        template: (item, options) => CustomMenuItemAdmin(item, options, true)
      }, {
        label: t("recommendToAFriend"),
        icon: "pi pi-fw pi-user",
        command: sendToFriends
      }, {
        label: t("termsOfService"),
        icon: "pi pi-fw pi-file",
        command: openTerms
      }, {
        separator: true
      }, {
        icon: "pi pi-fw pi-power-off",
        label: t("logout"),
        style: {
          color: theme.red
        },
        command: logout,
        template: (item, options) => CustomMenuItem(item, options)
      }];
    } else {
      return [{
        label: t("editProfileMenu"),
        icon: "pi pi-fw pi-pencil",
        command: () => {
          router_default().push(`/profiles/${isSupplier ? "supplier" : "user"}`);
        }
      }, {
        icon: "pi pi-fw pi pi-home",
        label: t("supplier"),
        template: (item, options) => CustomMenuItem(item, options, true)
      }, {
        label: t("recommendToAFriend"),
        icon: "pi pi-fw pi-user",
        command: sendToFriends
      }, {
        label: t("termsOfService"),
        icon: "pi pi-fw pi-file",
        command: openTerms
      }, {
        separator: true
      }, {
        icon: "pi pi-fw pi-power-off",
        label: t("logout"),
        style: {
          color: theme.red
        },
        command: logout,
        template: (item, options) => CustomMenuItem(item, options)
      }];
    }
  };

  const changeLanguageAndReload = language => {
    changeLanguage(language);
  };

  const handleWantToOfferButton = () => {
    if (util/* Util.isMobile */.Z.isMobile()) {
      setTimeout(function () {
        if (util/* Util.isMobile */.Z.isMobile()) {
          window.location.href = 'https://relty.app.link/';
        }

        return;
      }, 800);
      window.location.href = `relty://?cadastrarAventura=true`;
    } else {
      window.location.href = '/profiles/supplier/adventures/create';
    }
  };

  const languageItems = [{
    label: 'English - EN',
    command: () => changeLanguageAndReload('en'),
    template: (item, options) => CustomMenuItem(item, options, false, '/assets/english.png')
  }, {
    label: 'Español - ES',
    command: () => changeLanguageAndReload('es'),
    template: (item, options) => CustomMenuItem(item, options, false, '/assets/spain.png')
  }, {
    label: 'Português - PT',
    command: () => changeLanguageAndReload('pt'),
    template: (item, options) => CustomMenuItem(item, options, false, '/assets/brazil.png')
  }];
  (0,external_react_.useEffect)(() => {
    router_.Router.events.on('routeChangeStart', hideSideBar);
    router_.Router.events.on('routeChangeStart', hideMenu);
    setIsMobile(util/* Util.isMobile */.Z.isMobile());
  }, []);
  (0,external_react_.useEffect)(() => {
    setIsSupplier((user === null || user === void 0 ? void 0 : user.perfilAtual) == 'E' ? true : false);
  }, [user]);
  return /*#__PURE__*/jsx_runtime_.jsx("nav", {
    style: {
      height: '50%'
    },
    children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(NavBar_Wrapper, {
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(NavBarDesktop, {
        children: [isSupplier && isAuthenticated && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            onClick: handleWantToOfferButton,
            text: t('wantToOfferAnAdventure')
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/supplier/overview",
            text: t('overview'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLineChartFill */.l5b, {
              size: 26,
              color: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/supplier/adventures",
            text: t('adventures'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(adventure, {
              width: 24,
              height: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/supplier/clients",
            text: t('customers'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiTeamLine */.jU4, {
              size: 26,
              color: theme.primaryBackground
            })
          })]
        }), !isAuthenticated && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarItemWithoutLink, {
            text: t('login'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLoginBoxLine */.OUv, {
              size: 26,
              color: theme.primaryBackground
            }),
            onClick: () => setAuthModalOnLogin()
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/register",
            text: t('register'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoPersonOutline */.FJ3, {
              size: 26,
              color: theme.primaryBackground
            })
          })]
        }), isAuthenticated && isAdmin && !isSupplier && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/admin/overview",
            text: t("overview"),
            icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLineChartFill */.l5b, {
              size: 26,
              color: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/admin/supplier",
            text: "Fornecedores",
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaUsers */.I$, {
              size: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/admin/user",
            text: "Usu\xE1rios",
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaUsers */.I$, {
              size: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/admin/materials",
            text: "Materiais",
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaRegFileAlt */.bz6, {
              size: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/profiles/admin/categories",
            text: "Categorias",
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaClipboardList */.W95, {
              size: 26,
              fill: theme.primaryBackground
            })
          })]
        }), isAuthenticated && !isSupplier && !isAdmin && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/map",
            text: t("exploreInMap"),
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiRoadMapLine */.m$q, {
              size: 26,
              color: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/favorites?page=1",
            text: t("favorites"),
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(heart/* default */.Z, {
              width: 24,
              height: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarItem, {
            href: "/adventures?page=1",
            text: "Aventuras",
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(adventure, {
              width: 24,
              height: 26,
              color: theme.primaryBackground
            })
          })]
        }), isAuthenticated && /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
          children: /*#__PURE__*/jsx_runtime_.jsx("li", {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
              children: [/*#__PURE__*/jsx_runtime_.jsx(tieredmenu_namespaceObject.TieredMenu, {
                model: itemsRender(),
                popup: true,
                ref: menu,
                id: "overlay_tmenu"
              }), /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
                url: getImageUrlByProfile(),
                onClick: event => {
                  var _menu$current2;

                  return (_menu$current2 = menu.current) === null || _menu$current2 === void 0 ? void 0 : _menu$current2.toggle(event);
                }
              })]
            })
          })
        }), /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
          children: /*#__PURE__*/jsx_runtime_.jsx("li", {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
              children: [/*#__PURE__*/jsx_runtime_.jsx(tieredmenu_namespaceObject.TieredMenu, {
                model: languageItems,
                popup: true,
                ref: menuLanguage,
                id: "overlay_tmenu"
              }), /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
                url: getImageByLanguage(),
                onClick: event => {
                  var _menuLanguage$current;

                  (_menuLanguage$current = menuLanguage.current) === null || _menuLanguage$current === void 0 ? void 0 : _menuLanguage$current.toggle(event);
                }
              })]
            })
          })
        })]
      }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(NavBarMobile, {
        children: [isSupplier && isAuthenticated && /*#__PURE__*/(0,jsx_runtime_.jsxs)(AdventureIconWrapper, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(adventure, {
            onClick: handleWantToOfferButton
          }), /*#__PURE__*/jsx_runtime_.jsx("text", {
            children: t('newAdventure')
          })]
        }), /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
          children: /*#__PURE__*/jsx_runtime_.jsx("li", {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
              children: [/*#__PURE__*/jsx_runtime_.jsx(tieredmenu_namespaceObject.TieredMenu, {
                model: languageItems,
                popup: true,
                ref: menuLanguage,
                id: "overlay_tmenu"
              }), /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
                url: getImageByLanguage(),
                onClick: event => {
                  var _menuLanguage$current2;

                  return (_menuLanguage$current2 = menuLanguage.current) === null || _menuLanguage$current2 === void 0 ? void 0 : _menuLanguage$current2.toggle(event);
                }
              })]
            })
          })
        }), /*#__PURE__*/jsx_runtime_.jsx(ai_index_esm/* AiOutlineMenuFold */.mFO, {
          size: 35,
          color: theme.pageForeground,
          onClick: () => setShowSideBar(true)
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(sidebar_namespaceObject.Sidebar, {
          visible: showSideBar,
          position: "right",
          onHide: () => setShowSideBar(false),
          children: [/*#__PURE__*/jsx_runtime_.jsx(ContainerImage, {
            children: /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
              url: getImageUrlByProfile()
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
            href: "/home?page=1",
            text: t('home'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoHomeOutline */.yl6, {
              size: 24,
              color: theme.primaryBackground
            })
          }), isAuthenticated && /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItemWithoutLink, {
            text: t('supplier'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoHomeOutline */.yl6, {
              size: 24,
              color: theme.primaryBackground
            }),
            withSwitch: true
          }), isAuthenticated && user.seAdministrador == "S" && /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItemWithoutLinkAdmin, {
            text: "Admin",
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoHomeOutline */.yl6, {
              size: 24,
              color: theme.primaryBackground
            }),
            withSwitch: true
          }), isSupplier && isAuthenticated && !isAdmin && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/supplier/overview",
              text: t("overview"),
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLineChartFill */.l5b, {
                size: 26,
                color: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/supplier/adventures",
              text: t("adventures"),
              icon: /*#__PURE__*/jsx_runtime_.jsx(adventure, {
                width: 24,
                height: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/supplier/clients",
              text: t("customers"),
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiTeamLine */.jU4, {
                size: 26,
                color: theme.primaryBackground
              })
            })]
          }), isAuthenticated && !isSupplier && isAdmin && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/admin/overview",
              text: "Overview",
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiRoadMapLine */.m$q, {
                size: 26,
                color: theme.primaryBackground
              }),
              needAuth: true
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/admin/supplier",
              text: "Fornecedores",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaUsers */.I$, {
                size: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/admin/user",
              text: "Usu\xE1rios",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaUsers */.I$, {
                size: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/admin/materials",
              text: "Materiais",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaRegFileAlt */.bz6, {
                size: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/profiles/admin/categories",
              text: "Categorias",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaClipboardList */.W95, {
                size: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/favorites?page=1",
              text: "_Aventuras",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiTeamLine */.jU4, {
                size: 26,
                color: theme.primaryBackground
              })
            })]
          }), isAuthenticated && !isSupplier && !isAdmin && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/map",
              text: t("exploreInMap"),
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiRoadMapLine */.m$q, {
                size: 26,
                color: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/favorites?page=1",
              text: t("favorites"),
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(heart/* default */.Z, {
                width: 24,
                height: 26,
                fill: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/adventures?page=1",
              text: "Aventuras",
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(adventure, {
                width: 24,
                height: 26,
                color: theme.primaryBackground
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/community",
              text: t("community"),
              needAuth: true,
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiTeamLine */.jU4, {
                size: 26,
                color: theme.primaryBackground
              })
            })]
          }), !isAuthenticated && /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItemWithoutLink, {
              text: t('login'),
              icon: /*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLoginBoxLine */.OUv, {
                size: 26,
                color: theme.primaryBackground
              }),
              onClick: () => {
                setAuthModalOnLogin();
                setShowSideBar(false);
              }
            }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
              href: "/register",
              text: t('register'),
              icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoPersonOutline */.FJ3, {
                size: 26,
                color: theme.primaryBackground
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
            href: "/favorites?page=1",
            text: t('favorites'),
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(heart/* default */.Z, {
              width: 24,
              height: 26,
              fill: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItem, {
            href: `/profiles/${isSupplier ? 'supplier' : 'user'}`,
            text: t('editProfileMenu'),
            needAuth: true,
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoPersonOutline */.FJ3, {
              size: 24,
              color: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItemWithoutLink, {
            onClick: openTerms,
            text: t('termsOfService'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoDocumentTextOutline */.jyt, {
              size: 24,
              color: theme.primaryBackground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(SidebarMobileItemWithoutLink, {
            onClick: sendToFriends,
            text: t('recommendToAFriend'),
            icon: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* IoShareSocialSharp */.Qs7, {
              size: 24,
              color: theme.primaryBackground
            })
          }), isAuthenticated && /*#__PURE__*/jsx_runtime_.jsx(LogoutContainer, {
            className: 'logout-item',
            onClick: () => logout(),
            children: /*#__PURE__*/jsx_runtime_.jsx("li", {
              children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
                children: [/*#__PURE__*/jsx_runtime_.jsx(ri_index_esm/* RiLogoutBoxLine */.aIK, {
                  size: 24,
                  color: theme.red
                }), /*#__PURE__*/(0,jsx_runtime_.jsxs)("text", {
                  children: [t('logout'), " "]
                })]
              })
            })
          })]
        })]
      })]
    })
  });
}

/* harmony default export */ const components_NavBar = ((0,WithAuthModal/* default */.Z)(NavBar));
const NavBar_Wrapper = (external_styled_components_default()).ul`
  display: flex;
  list-style: none;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  a {
    color: ${p => p.theme.pageForeground};
    text-decoration: none;
    text-transform: capitalize;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    margin: 0 5px 0 5px;

    text {
      text-align: center;
      font: normal normal 600 9px/13px Poppins;
      letter-spacing: 0px;
      color: #006993;
      opacity: 1;
    }
    &:hover {
      color: ${p => p.theme.primaryBackground};
    }
  }
`;
const NavBarDesktop = (external_styled_components_default()).div`
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;

  @media screen and (max-width: 767px) {
    display: none;
  }

  li {
    height: 100%;
    min-width: 64px;
    position: relative;
    align-self: flex-start;
    text {
      width: 36;
      position: absolute;
      bottom: -20px;
    }
  }
`;
const ImageRadius = (external_styled_components_default()).div`
  width: 40px;
  height: 40px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  cursor: pointer;
`;
const LanguageIcon = (external_styled_components_default()).div`
  width: 24px;
  height: 24px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  cursor: pointer;
`;
const ContainerImage = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-bottom: 10px;
`;
const MobileItemName = (external_styled_components_default()).text`
  color: red;
  margin-left: 5px;
`;
const NavBarMobile = (external_styled_components_default()).div`
  display: none;
  cursor: pointer;

  @media screen and (max-width: 767px) {
    display: flex;
    justify-content: center;
    align-items: center;
  }

  :active {
    opacity: 0.5;
  }
`;
const AdventureIconWrapper = (external_styled_components_default()).div`
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  margin-right: 15px;
  position: relative;

  text {
    min-width: 60px;
    width: 50px;
    font-size: 8px;
    position: absolute;
    text-align: center;
    bottom: -13px;
    color: ${p => p.theme.primaryBackground};
  }
`;
const LogoutContainer = (external_styled_components_default()).div``;
// EXTERNAL MODULE: ./src/_constants.ts
var _constants = __webpack_require__(8965);
;// CONCATENATED MODULE: ./src/app/components/Header/index.tsx









function Header() {
  return /*#__PURE__*/jsx_runtime_.jsx(Header_Wrapper, {
    children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Container, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(components_Logo, {}), /*#__PURE__*/jsx_runtime_.jsx(components_NavBar, {})]
    })
  });
}

/* harmony default export */ const components_Header = (/*#__PURE__*/external_react_default().memo(Header));
const Container = (external_styled_components_default()).div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  max-width: ${_constants/* CONTAINER_WIDTH */.RZ}px;
  margin: auto;
  height: 100%;
  padding: 0px 16px;
`;
const Header_Wrapper = (external_styled_components_default()).div`
  background-color: ${p => p.theme.activeElementBackground};
  color: ${p => p.theme.activeElementForeground};
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  width: 100%;
  height: ${_constants/* HEADER_HEIGHT */.Mz}px;
`;
;// CONCATENATED MODULE: ./src/app/components/Footer/index.tsx









function Footer() {
  const theme = (0,external_styled_components_.useTheme)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(Footer_Wrapper, {
    children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Footer_Container, {
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(HalfLeft, {
        children: [/*#__PURE__*/jsx_runtime_.jsx("text", {
          children: t("followSocialMedia")
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(ContainerIcons, {
          children: [/*#__PURE__*/jsx_runtime_.jsx("a", {
            href: "https://www.instagram.com/reltyapp/",
            target: "_blank",
            rel: "noreferrer",
            children: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaInstagram */.Zf_, {
              size: 35,
              color: theme.primaryForeground
            })
          }), /*#__PURE__*/jsx_runtime_.jsx("a", {
            href: "https://m.facebook.com/reltyapp/",
            target: "_blank",
            rel: "noreferrer",
            children: /*#__PURE__*/jsx_runtime_.jsx(fa_index_esm/* FaFacebook */.Am9, {
              size: 35,
              color: theme.primaryForeground
            })
          })]
        })]
      }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(HalfRight, {
        children: [/*#__PURE__*/jsx_runtime_.jsx("text", {
          children: t("contactUs")
        }), /*#__PURE__*/jsx_runtime_.jsx(ContainerIcons, {
          children: /*#__PURE__*/jsx_runtime_.jsx("text", {
            children: "contato@reltyapp.com"
          })
        })]
      })]
    }), /*#__PURE__*/jsx_runtime_.jsx(HalfBottom, {
      children: /*#__PURE__*/jsx_runtime_.jsx("text", {
        children: t("copyright")
      })
    })]
  });
}

/* harmony default export */ const components_Footer = (/*#__PURE__*/external_react_default().memo(Footer));
const Footer_Container = (external_styled_components_default()).div`
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: row;
  max-width: 848px;
  margin: auto;
  height: 80%;
  text-align: center;

  text {
    font-size: 22px;
  }

  @media screen and (max-width: 767px) {
    flex-direction: column;
    padding-top: 20px;
  }
`;
const Footer_Wrapper = (external_styled_components_default()).footer`
  background-color: ${p => p.theme.primaryBackground};
  color: ${p => p.theme.primaryForeground};
  width: 100%;
  height: ${_constants/* FOOTER_HEIGHT */.Tx}px;
`;
const HalfLeft = (external_styled_components_default()).div`
  height: 50%;
  width: 50%;
`;
const ContainerIcons = (external_styled_components_default()).div`
  display: flex;
  align-items: center;
  justify-content: center;
  a {
    text-decoration: none;
    margin: 0 10px;
  }
  text {
    font-size: 18px;
  }
`;
const HalfRight = (external_styled_components_default()).div`
  height: 50%;
  width: 50%;
`;
const HalfBottom = (external_styled_components_default()).div`
  height: 20%;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;
  max-width: 848px;
  margin: auto;
`;
// EXTERNAL MODULE: ./src/app/components/Content/index.tsx
var Content = __webpack_require__(5490);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(701);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
;// CONCATENATED MODULE: external "@badrap/bar-of-progress"
const bar_of_progress_namespaceObject = require("@badrap/bar-of-progress");
var bar_of_progress_default = /*#__PURE__*/__webpack_require__.n(bar_of_progress_namespaceObject);
;// CONCATENATED MODULE: external "@djpfs/react-vlibras"
const react_vlibras_namespaceObject = require("@djpfs/react-vlibras");
var react_vlibras_default = /*#__PURE__*/__webpack_require__.n(react_vlibras_namespaceObject);
// EXTERNAL MODULE: external "react-intl"
var external_react_intl_ = __webpack_require__(1687);
// EXTERNAL MODULE: ./src/core/contexts/GeolocationContext.tsx
var GeolocationContext = __webpack_require__(382);
;// CONCATENATED MODULE: external "react-onesignal"
const external_react_onesignal_namespaceObject = require("react-onesignal");
var external_react_onesignal_default = /*#__PURE__*/__webpack_require__.n(external_react_onesignal_namespaceObject);
;// CONCATENATED MODULE: ./src/core/hooks/useOneSignal.ts


function useOneSignal() {
  const {
    updateOneSignalToken
  } = (0,useUser/* default */.Z)();

  const initOneSignal = async () => {
    {
      /* @ts-ignore */
    }
    await external_react_onesignal_default().init({
      appId: process.env.NEXT_PUBLIC_ONESIGNAL_ID,
      safari_web_id: process.env.NEXT_PUBLIC_ONESIGNAL_SAFARI_ID,
      allowLocalhostAsSecureOrigin: true
    }).then(() => {
      registerUserForNotifications();
    });
  };

  const registerUserForNotifications = () => {
    external_react_onesignal_default().registerForPushNotifications().then(() => {
      external_react_onesignal_default().getUserId(userId => {
        if (userId) {
          updateOneSignalToken(userId);
        }
      });
    }).catch(error => {
      console.log(error);
    });
  };

  return {
    initOneSignal
  };
}
// EXTERNAL MODULE: ./next-i18next.config.js
var next_i18next_config = __webpack_require__(2147);
var next_i18next_config_default = /*#__PURE__*/__webpack_require__.n(next_i18next_config);
;// CONCATENATED MODULE: ./src/pages/_app.tsx




function _app_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _app_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { _app_ownKeys(Object(source), true).forEach(function (key) { _app_defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { _app_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _app_defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











 //Prime















const progress = new (bar_of_progress_default())({
  size: 3,
  color: theme/* light.primaryBackground */.R.primaryBackground,
  delay: 100
});

function MyApp({
  Component,
  pageProps
}) {
  const {
    initOneSignal
  } = useOneSignal();
  const {
    i18n
  } = (0,external_next_i18next_.useTranslation)("common");
  (0,external_react_.useEffect)(() => {
    initOneSignal();
  }, []);
  return /*#__PURE__*/jsx_runtime_.jsx(external_react_intl_.IntlProvider, {
    messages: __webpack_require__(3169),
    locale: "pt-BR",
    defaultLocale: "pt-BR",
    children: /*#__PURE__*/jsx_runtime_.jsx(external_styled_components_.ThemeProvider, {
      theme: theme/* light */.R,
      children: /*#__PURE__*/jsx_runtime_.jsx(PreferencesContext/* PreferencesProvider */.CE, {
        children: /*#__PURE__*/jsx_runtime_.jsx(UserContext/* UserProvider */.dr, {
          children: /*#__PURE__*/jsx_runtime_.jsx(GeolocationContext/* GeolocationProvider */.SO, {
            children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
              children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)((head_default()), {
                children: [/*#__PURE__*/jsx_runtime_.jsx("meta", {
                  name: "theme-color",
                  content: theme/* light.primaryBackground */.R.primaryBackground
                }), /*#__PURE__*/jsx_runtime_.jsx("meta", {
                  name: "viewport",
                  content: "width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"
                }), /*#__PURE__*/jsx_runtime_.jsx("link", {
                  rel: "shortcut icon",
                  href: "/assets/icon.png"
                })]
              }), /*#__PURE__*/jsx_runtime_.jsx(globaStyles, {}), /*#__PURE__*/jsx_runtime_.jsx(components_Header, {}), /*#__PURE__*/jsx_runtime_.jsx((react_vlibras_default()), {}), /*#__PURE__*/jsx_runtime_.jsx(Content/* default */.Z, {
                children: /*#__PURE__*/jsx_runtime_.jsx(Component, _app_objectSpread({}, pageProps))
              }), /*#__PURE__*/jsx_runtime_.jsx(components_Footer, {})]
            })
          })
        })
      })
    })
  });
}

router_.Router.events.on("routeChangeStart", progress.start);
router_.Router.events.on("routeChangeComplete", progress.finish);
router_.Router.events.on("routeChangeError", progress.finish);
/* harmony default export */ const _app = ((0,external_next_i18next_.appWithTranslation)(MyApp, (next_i18next_config_default())));

/***/ }),

/***/ 9443:
/***/ ((module) => {

module.exports = require("@googlemaps/markerclustererplus");

/***/ }),

/***/ 2376:
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ 7717:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 8475:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 9325:
/***/ ((module) => {

module.exports = require("next/dist/server/denormalize-page-path.js");

/***/ }),

/***/ 8300:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/detect-domain-locale.js");

/***/ }),

/***/ 5378:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 7162:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 8773:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 2248:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 9372:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 665:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 2747:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 333:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 3456:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 7620:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 701:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 6731:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 5998:
/***/ ((module) => {

module.exports = require("nookies");

/***/ }),

/***/ 7158:
/***/ ((module) => {

module.exports = require("polished");

/***/ }),

/***/ 3601:
/***/ ((module) => {

module.exports = require("primereact/dialog");

/***/ }),

/***/ 1775:
/***/ ((module) => {

module.exports = require("primereact/inputswitch");

/***/ }),

/***/ 5439:
/***/ ((module) => {

module.exports = require("primereact/toast");

/***/ }),

/***/ 6850:
/***/ ((module) => {

module.exports = require("qs");

/***/ }),

/***/ 9297:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 7789:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 4951:
/***/ ((module) => {

module.exports = require("react-input-mask");

/***/ }),

/***/ 1687:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 5282:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 9914:
/***/ ((module) => {

module.exports = require("styled-components");

/***/ }),

/***/ 9440:
/***/ ((module) => {

module.exports = require("yup");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [9127,9583,1664,9352,8193,155,5548,4017,5745,5980,7697,3371,37,6089,7471,1629,382,5490,6709], () => (__webpack_exec__(141)));
module.exports = __webpack_exports__;

})();