"use strict";
exports.id = 7568;
exports.ids = [7568];
exports.modules = {

/***/ 7568:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useClient)
/* harmony export */ });
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6402);

function useClient() {
  const getDataListUserFilter = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/ClienteEstabelecimento/Filtrar`, filtro);
  };

  const getDataUserDetails = async clienteId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`WS/Cliente/${clienteId}/Perfil`);
  };

  const getDataUserLastAdventure = async () => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/ClienteAventura/Aventura/Filtrar`);
  };

  const saveDataSubscribed = async (companion, newStatus) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/ClienteAventuraAcompanhante/AlterarPresenca/${companion.acompanhanteId}?novoStatus=${newStatus}`, {});
  };

  const saveDataCloseClasse = async classeId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/AventuraTurma/AlterarSituacao/${classeId}`, {});
  };

  const saveDataFollow = async client => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/Cliente/${client.idCliente}/Seguir`, null);
  };

  const saveDataUnFollow = async client => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/Cliente/${client.idCliente}/DeixarDeSeguir`, null);
  };

  const getDataAdress = async clientId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`WS/Cliente/Endereco/${clientId}`);
  };

  return {
    getDataListUserFilter,
    getDataUserDetails,
    getDataUserLastAdventure,
    saveDataSubscribed,
    saveDataCloseClasse,
    saveDataFollow,
    saveDataUnFollow,
    getDataAdress
  };
}

/***/ })

};
;