"use strict";
exports.id = 7471;
exports.ids = [7471];
exports.modules = {

/***/ 7471:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useAuth)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2376);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _contexts_UserContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9263);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6850);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(qs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_exceptions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(504);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9763);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6731);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7789);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_7__);








function useAuth() {
  const userContext = (0,_contexts_UserContext__WEBPACK_IMPORTED_MODULE_1__/* .useUserContext */ .SE)();
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_7__.useTranslation)("common");

  const login = async (email, password) => {
    let body = {
      client: "NAVEGADOR",
      username: email,
      password: password,
      grant_type: "password"
    };
    console.log('login =>', _services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .baseURL */ .v2, 'body', body);
    await axios__WEBPACK_IMPORTED_MODULE_0___default().post(_services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .baseURL */ .v2 + "/oauth/token", qs__WEBPACK_IMPORTED_MODULE_2___default().stringify(body), _services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .tokenConfig */ .Y2).then(result => {
      var _result$data, _result$data2;

      console.log('result ==>', result);
      userContext.setUser(result.data);
      (0,nookies__WEBPACK_IMPORTED_MODULE_4__.setCookie)(undefined, "user", JSON.stringify(result.data), {
        path: "/",
        maxAge: 30 * 24 * 60 * 60 * 2
      });
      (0,nookies__WEBPACK_IMPORTED_MODULE_4__.setCookie)(undefined, "access_token", JSON.stringify((_result$data = result.data) === null || _result$data === void 0 ? void 0 : _result$data.access_token), {
        path: "/",
        maxAge: 30 * 24 * 60 * 60 * 2
      });
      (0,nookies__WEBPACK_IMPORTED_MODULE_4__.setCookie)(undefined, "refresh_token", JSON.stringify((_result$data2 = result.data) === null || _result$data2 === void 0 ? void 0 : _result$data2.refresh_token), {
        path: "/",
        maxAge: 30 * 24 * 60 * 60 * 2
      });
    }).catch(error => {
      console.log('errorLogin ==>', error);
      console.log('errorLoginrequest ==>', _services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .baseURL */ .v2 + "/oauth/token", qs__WEBPACK_IMPORTED_MODULE_2___default().stringify(body), _services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .tokenConfig */ .Y2);

      if (error.response && error.response.status == 400) {
        throw new _utils_exceptions__WEBPACK_IMPORTED_MODULE_3__/* .BadCredentialsException */ .RD(t("emailAndPasswordError"));
      } else {
        throw new Error(t("errorLogin"));
      }
    });
  };

  const recoverPassword = async () => {};

  const registerUser = async user => {
    await axios__WEBPACK_IMPORTED_MODULE_0___default().post(_services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .baseURL */ .v2 + "/WS/UsuarioRelty/Criar", user).then(() => {
      login(user.email, user.senha);
    }).catch(() => {
      throw new Error(t("registrationError"));
    });
  };

  const logout = async () => {
    (0,_services_apiServerSide__WEBPACK_IMPORTED_MODULE_5__/* .cleanSession */ .D7)();
    setTimeout(() => {
      next_router__WEBPACK_IMPORTED_MODULE_6___default().replace("/home");
    }, 300);
  };

  return {
    login,
    recoverPassword,
    logout,
    registerUser
  };
}

/***/ })

};
;