"use strict";
exports.id = 676;
exports.ids = [676];
exports.modules = {

/***/ 6642:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ CategoryModal)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/app/components/CategoryModal/styles.ts

const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const InputContainer = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
`;
// EXTERNAL MODULE: ./src/core/hooks/useCategory.ts
var useCategory = __webpack_require__(2156);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
;// CONCATENATED MODULE: ./src/app/components/CategoryModal/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










function CategoryModal(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    saveDataCategory
  } = (0,useCategory/* default */.Z)();
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: category,
    1: setCategory
  } = (0,external_react_.useState)({
    nome: null,
    nomePt: null,
    nomeEn: null,
    nomeEs: null,
    tipoAventura: null
  });
  const dropdownOptions = [{
    key: "Selecione um elemento",
    value: null
  }, {
    key: "Ar",
    value: "A"
  }, {
    key: "Água",
    value: "G"
  }, {
    key: "Terra",
    value: "T"
  }];
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);

  const saveCategoryDataDto = async () => {
    if (props.data && props.data.id) {
      setCategory(prevState => {
        return _objectSpread(_objectSpread({}, prevState), {}, {
          id: props.data.id
        });
      });
      props.data.nomePt = category.nomePt;
      props.data.nomeEn = category.nomeEn;
      props.data.nomeEs = category.nomeEs;
      props.data.tipoAventura = category.tipoAventura;
    }

    if (category && category.nomePt && category.nomeEn && category.nomeEs && category.tipoAventura) {
      category.nome = category.nomePt;
      const response = await saveDataCategory(category);

      if (response.status === 200) {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Categoria salva com sucesso");
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao salvar categoria");
      }
    } else {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, "Preencha todos os campos");
    }

    forceUpdate();
    setCategory({
      nome: null,
      nomePt: null,
      nomeEn: null,
      nomeEs: null,
      tipoAventura: null
    });
    props.onHide();
  };

  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setCategory(props.data);
  }, [props.visible]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: category !== null && category !== void 0 && category.id ? 'Salvar categoria' : 'Nova categoria',
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 1,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomePortugues",
                label: "Nome em portugues",
                placeholder: "Cachoeirismo",
                value: (category === null || category === void 0 ? void 0 : category.nomePt) || "",
                onChange: i => setCategory(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    nomePt: i.target.value
                  });
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomeIngles",
                label: "Nome em ingl\xEAs",
                placeholder: "Waterfall",
                value: (category === null || category === void 0 ? void 0 : category.nomeEn) || "",
                onChange: i => setCategory(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    nomeEn: i.target.value
                  });
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomeEspanhol",
                label: "Nome em espanhol",
                placeholder: "Cascada",
                value: (category === null || category === void 0 ? void 0 : category.nomeEs) || "",
                onChange: i => setCategory(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    nomeEs: i.target.value
                  });
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomeElemento",
                label: "Elemento",
                as: "select",
                options: dropdownOptions,
                onChange: i => setCategory(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    tipoAventura: i.target.value
                  });
                }),
                value: (category === null || category === void 0 ? void 0 : category.tipoAventura) || null
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            type: "button",
            onClick: () => saveCategoryDataDto(),
            text: "Salvar altera\xE7\xF5es"
          })]
        })
      })
    })]
  });
}

/***/ }),

/***/ 676:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ DataTableCustom)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "primereact/datatable"
var datatable_ = __webpack_require__(6803);
// EXTERNAL MODULE: external "primereact/column"
var column_ = __webpack_require__(8859);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./node_modules/react-icons/fa/index.esm.js
var index_esm = __webpack_require__(9583);
// EXTERNAL MODULE: ./src/app/components/MaterialModal/index.tsx + 1 modules
var MaterialModal = __webpack_require__(1244);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
;// CONCATENATED MODULE: ./src/app/components/CategoryModal/DeleteModal/styles.ts

const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: ./src/core/hooks/useCategory.ts
var useCategory = __webpack_require__(2156);
;// CONCATENATED MODULE: ./src/app/components/CategoryModal/DeleteModal/index.tsx










function DeleteModalCategory(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: category,
    1: setCategory
  } = (0,external_react_.useState)({});
  const {
    deleteDataCategory
  } = (0,useCategory/* default */.Z)();
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setCategory(props.data);
  }, [props.visible]);

  const deleteCategoriaDataDto = async () => {
    {
      /* @ts-ignore */
    }

    if (category && category !== null && category !== void 0 && category.id) {
      const response = await deleteDataCategory(category);

      if (response.status === 204) {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Categoria excluido com sucesso");
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao excluir categoria");
      }
    }

    props.onHide();
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Excluir categoria",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA tem certeza que deseja excluir o categoria ? A opera\xE7\xE3o n\xE3o poder desfeita."
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => props.onHide(),
          text: "N\xE3o"
        }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          onClick: () => deleteCategoriaDataDto(),
          text: "Sim"
        })]
      })]
    })]
  });
}
;// CONCATENATED MODULE: ./src/app/components/MaterialModal/DeleteModal/styles.ts

const styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
// EXTERNAL MODULE: ./src/core/hooks/useMaterial.ts
var useMaterial = __webpack_require__(8726);
;// CONCATENATED MODULE: ./src/app/components/MaterialModal/DeleteModal/index.tsx










function DeleteModalMaterial(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: material,
    1: setMaterial
  } = (0,external_react_.useState)({});
  const {
    deleteDataMaterial
  } = (0,useMaterial/* default */.Z)();
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setMaterial(props.data);
  }, [props.visible]);

  const deleteMaterialDataDto = async () => {
    {
      /* @ts-ignore */
    }

    if (material && material !== null && material !== void 0 && material.id) {
      const response = await deleteDataMaterial(material);

      if (response.status === 204) {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Material excluido com sucesso");
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao excluir material");
      }
    }

    props.onHide();
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Excluir material",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA tem certeza que deseja excluir o material ? A opera\xE7\xE3o n\xE3o poder desfeita."
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(styles_InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => props.onHide(),
          text: "N\xE3o"
        }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          onClick: () => deleteMaterialDataDto(),
          text: "Sim"
        })]
      })]
    })]
  });
}
// EXTERNAL MODULE: ./src/app/components/CategoryModal/index.tsx + 1 modules
var CategoryModal = __webpack_require__(6642);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
;// CONCATENATED MODULE: ./src/app/components/SupplierModalComission/styles.ts

const SupplierModalComission_styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const InputContainer = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
`;
// EXTERNAL MODULE: ./src/core/hooks/useEstablishment.ts
var useEstablishment = __webpack_require__(3976);
;// CONCATENATED MODULE: ./src/app/components/SupplierModalComission/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










function SupplierModalComission(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: comission,
    1: setComission
  } = (0,external_react_.useState)({});
  const {
    saveSupplierComission
  } = (0,useEstablishment/* default */.Z)();

  const saveComissionSupplier = async () => {
    {
      /* @ts-ignore */
    }

    if (comission.porcentagemCobrada == null || comission.porcentagemCobrada == undefined) {
      {
        /* @ts-ignore */
      }
      comission.porcentagemCobrada = 20;
    }

    try {
      const response = await saveSupplierComission(comission);
      console.log(response);

      if (response.status === 200) {
        setVisible(!visible);
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Comissão alterada com sucesso");
      }
    } catch (e) {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao alterar comissão");
    }
  };

  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setComission({
      id: props.data.id,
      porcentagemCobrada: null
    });
  }, [props.visible]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: "Porcentagem de cobran\xE7a",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
            children: ["Voc\xEA est\xE1 alterando a porcentagem de cobran\xE7a ", /*#__PURE__*/(0,jsx_runtime_.jsxs)("b", {
              children: [" ", props.data.nome, " "]
            }), " (valor em branco significa 20%)"]
          }), /*#__PURE__*/jsx_runtime_.jsx(SupplierModalComission_styles_InputGroup, {
            inputs: 1,
            children: /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "comission",
                placeholder: "Comiss\xE3o",
                type: "number",
                min: "1",
                max: "100",
                value: comission === null || comission === void 0 ? void 0 : comission.porcentagemCobrada,
                onChange: e => {
                  const value = e.target.value;

                  if (value.length >= 3) {
                    {
                      /* @ts-ignore */
                    }
                    setComission(prevState => {
                      return _objectSpread(_objectSpread({}, prevState), {}, {
                        porcentagemCobrada: 100
                      });
                    });
                  } else {
                    {
                      /* @ts-ignore */
                    }
                    setComission(prevState => {
                      return _objectSpread(_objectSpread({}, prevState), {}, {
                        porcentagemCobrada: parseInt(value)
                      });
                    });
                  }
                }
              })
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            type: "button",
            onClick: () => saveComissionSupplier(),
            text: "Salvar altera\xE7\xF5es"
          })]
        })
      })
    })]
  });
}
;// CONCATENATED MODULE: ./src/app/components/SubscribedModal/styles.ts

const SubscribedModal_styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
// EXTERNAL MODULE: ./src/core/hooks/useClient.ts
var useClient = __webpack_require__(7568);
;// CONCATENATED MODULE: ./src/app/components/SubscribedModal/index.tsx









function SubscribedModal_DeleteModalCategory(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: subscribed,
    1: setSubscribed
  } = (0,external_react_.useState)({});
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);
  const {
    saveDataSubscribed
  } = (0,useClient/* default */.Z)();
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setSubscribed(props.data);
  }, [props.visible]);

  const saveNewStatus = async (subscribed, newStatus) => {
    const response = await saveDataSubscribed(subscribed, newStatus);

    if (response.status === 200) {
      props.data.statusPresenca = newStatus;
      forceUpdate();
      props.onHide();
    }
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Aten\xE7\xE3o",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA deve informar se o cliente esteve presente durante a aventura. o Cliente:"
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(SubscribedModal_styles_InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => saveNewStatus(subscribed, "AUSENTE"),
          text: "N\xE3o comparaceu"
        }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          text: "Compareceu",
          onClick: () => saveNewStatus(subscribed, "PRESENTE")
        })]
      })]
    })]
  });
}
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: external "yup-password"
var external_yup_password_ = __webpack_require__(3121);
var external_yup_password_default = /*#__PURE__*/__webpack_require__.n(external_yup_password_);
// EXTERNAL MODULE: ./src/core/hooks/useUser.ts
var useUser = __webpack_require__(5980);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/password.tsx
var SvgIcons_password = __webpack_require__(3371);
;// CONCATENATED MODULE: ./src/app/components/UserModal/ChangeUserPasswordModal/styles.ts

const ChangeUserPasswordModal_styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
;// CONCATENATED MODULE: ./src/app/components/UserModal/ChangeUserPasswordModal/index.tsx
















external_yup_password_default()(external_yup_);
function ChangeUserPasswordModal(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    changeUserPassword
  } = (0,useUser/* default */.Z)();
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
  }, [props.visible]);

  const onSubmit = async password => {
    const response = await changeUserPassword(props.data.id, password);

    if (response.status === 200) {
      util/* Util.showSucessToast */.Z.showSucessToast(toast, `A senha do usuário '${props.data.nome}' foi alterada com sucesso!`);
      props.onHide();
    } else {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, `Erro ao alterar senha do usuário '${props.data.nome}'!`);
    }
  };

  const initialValues = {
    password: ""
  };
  const validationSchema = external_yup_.object({
    password: external_yup_.string().password().required(t("requiredField")).minUppercase(0).minLowercase(0).minSymbols(0).minNumbers(0).min(6, t("passwordLength")).max(16, t("passwordLength"))
  });
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Altera\xE7\xE3o de senha",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        children: ["Voc\xEA est\xE1 alterando a senha de '", props.data.nome, "', digite a nova senha abaixo:"]
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
        initialValues: initialValues,
        validationSchema: validationSchema,
        onSubmit: values => {
          onSubmit(values.password);
        },
        validateOnChange: true,
        children: formik => {
          return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(ChangeUserPasswordModal_styles_InputGroup, {
              inputs: 1,
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                id: "password",
                name: "password",
                label: "Senha:",
                placeholder: "******",
                type: "password",
                error: formik.errors.password && formik.touched.password,
                icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                  width: 20,
                  height: 20
                })
              })
            }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(ChangeUserPasswordModal_styles_InputGroup, {
              inputs: 2,
              children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                type: "button",
                color: "#495057a3",
                onClick: () => props.onHide(),
                text: "Cancelar"
              }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                type: "submit",
                text: "Enviar nova senha",
                disabled: !formik.isValid
              })]
            })]
          });
        }
      })]
    })]
  });
}
// EXTERNAL MODULE: ./src/app/components/SvgIcons/air.tsx
var air = __webpack_require__(1010);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/earth.tsx
var earth = __webpack_require__(2387);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/water.tsx
var water = __webpack_require__(4285);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
;// CONCATENATED MODULE: ./src/app/components/ClosedClasseModal/styles.ts

const ClosedClasseModal_styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
;// CONCATENATED MODULE: ./src/app/components/ClosedClasseModal/index.tsx









function ClosedClasseModal(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: classe,
    1: setClasse
  } = (0,external_react_.useState)({});
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);
  const {
    saveDataCloseClasse
  } = (0,useClient/* default */.Z)();
  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setClasse(props.data);
  }, [props.visible]);

  const serviceClosedClasse = async classe => {
    {
      /* @ts-ignore */
    }
    const response = await saveDataCloseClasse(classe.id);

    if (response.status === 200) {
      if (props.data.situacaoTurma === 'ABERTA') {
        props.data.situacaoTurma = 'FECHADA';
      } else {
        props.data.situacaoTurma = 'ABERTA';
      }

      props.onHide();
      forceUpdate();
    }
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Aten\xE7\xE3o",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA deve informar se a turma vai est\xE1 aberta ou fechada"
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(ClosedClasseModal_styles_InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => props.onHide(),
          text: "Cancelar"
        }), props.data.situacaoTurma == 'ABERTA' ? /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          text: "Fechar turma",
          onClick: () => serviceClosedClasse(classe)
        }) : /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          text: "Abrir turma",
          onClick: () => serviceClosedClasse(classe)
        })]
      })]
    })]
  });
}
;// CONCATENATED MODULE: ./src/app/components/ModalMakeAdmin/styles.tsx

const ModalMakeAdmin_styles_InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const styles_InputContainer = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
`;
;// CONCATENATED MODULE: ./src/app/components/ModalMakeAdmin/index.tsx










function ModalMakeAdmin(props) {
  var _props$data$perfis;

  const toast = (0,external_react_.useRef)(null);
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    makeUserAdm
  } = (0,useUser/* default */.Z)();
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);

  const makeAdm = async usuario => {
    const response = await makeUserAdm(usuario.id);

    if (response.status === 200) {
      if (!usuario.profiles.includes('adm')) {
        props.data.perfis += "adm";
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Usuario tornou Admin");
      } else {
        props.data.perfis = usuario.profiles.replace("adm", "");
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Permissão Admin removido");
      }

      forceUpdate();
    }

    props.onHide();
  };

  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
  }, [props.visible]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Aten\xE7\xE3o",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: [((_props$data$perfis = props.data.perfis) === null || _props$data$perfis === void 0 ? void 0 : _props$data$perfis.indexOf('adm')) != -1 ? /*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA tem certeza que deseja remover esta permiss\xE3o de administrador para este usu\xE1rio ?"
      }) : /*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Voc\xEA tem certeza que deseja tornar este usu\xE1rio um administrador?"
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(ModalMakeAdmin_styles_InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => props.onHide(),
          text: "N\xE3o"
        }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          text: "Sim",
          onClick: () => makeAdm({
            id: props.data.id,
            profiles: props.data.perfis
          })
        })]
      })]
    })]
  });
}
;// CONCATENATED MODULE: ./src/app/components/DataTable/index.tsx






















/**
 * Types of data that this component supports:
 * - string: plain text
 * - textLong: for long text
 * - image: for image
 * - buttonAction: this data type follows an example to be followed to correctly work the component
 * example of the buttonAaction
 * { field: 'buttonAction', header: '', type: 'buttonAction', typeButton: [
        {
            page: 'establishment',
            label: 'Detalhes'
        },
        {
            page: 'establishment'
            label: 'Alterar comissão',
        }
    ]}
 *  the "buttonActionValidatorPage" function
 *   the logic of each page is applied to be able to work these events
 */

function DataTableCustom(props) {
  var _props$columns;

  const {
    0: visibleModalMaterial,
    1: setVisibleModalMaterial
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalCategory,
    1: setVisibleModalCategory
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalMaterialDelete,
    1: setVisibleModalMaterialDelete
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalCategoryDelete,
    1: setVisibleModalCategoryDelete
  } = (0,external_react_.useState)(false);
  const {
    0: dataModalMaterial,
    1: setDataModalMaterial
  } = (0,external_react_.useState)({});
  const {
    0: dataModalCategory,
    1: setDataModalCategory
  } = (0,external_react_.useState)({});
  const {
    0: dataModalSupplierComission,
    1: setDataModalSupplierComission
  } = (0,external_react_.useState)({});
  const {
    0: visibleModalSupplierComission,
    1: setVisibleModalSupplierComission
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalSubscribed,
    1: setVisibleModalSubscribed
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalChangePassword,
    1: setVisibleModalChangePassword
  } = (0,external_react_.useState)(false);
  const {
    0: visibleModalTurnUserAdmin,
    1: setVisibleModalTurnUserAdmin
  } = (0,external_react_.useState)(false);
  const {
    0: dataModalUser,
    1: setDataModalUser
  } = (0,external_react_.useState)({});
  const {
    0: dataModalSubscribed,
    1: setDataModalSubscribed
  } = (0,external_react_.useState)({});
  const {
    0: visibleModalClosedClasse,
    1: setVisibleModalClosedClasse
  } = (0,external_react_.useState)(false);
  const {
    0: dataModalClosedClasse,
    1: setDataModalClosedClasse
  } = (0,external_react_.useState)({});
  const {
    0: dataModalMakeAdmin,
    1: setDataModalMakeAdmin
  } = (0,external_react_.useState)({});
  const {
    0: visibleModalMakkeAdmin,
    1: setVisibleModalMakeAdmin
  } = (0,external_react_.useState)(false);
  const typeData = Object.values(props.columns).map(i => {
    return {
      field: i.field,
      type: i.type,
      typeButton: i.typeButton || []
    };
  });

  const buttonActionValidatorPage = (rowData, typeButton) => {
    // Page list client
    if (typeButton.page.includes("clients")) {
      if (typeButton.label.includes("Detalhes")) {
        router_default().push(`/profiles/supplier/clients/${rowData.idCliente}`);
      }
    } // Page list establishment


    if (typeButton.page.includes("establishment")) {
      if (typeButton.label.includes("Detalhes")) {
        router_default().push(`/profiles/admin/supplier/${rowData.id}`);
      }

      if (typeButton.label.includes("Alterar comissão")) {
        setDataModalSupplierComission(rowData);
        setVisibleModalSupplierComission(!visibleModalSupplierComission);
      }
    } //Page list user


    if (typeButton.page.includes("user")) {
      if (typeButton.label.includes('Alterar senha')) {
        setVisibleModalChangePassword(!visibleModalChangePassword);
      }

      if (typeButton.label.includes("Tornar admin") || typeButton.label.includes("Remover admin")) {
        setDataModalMakeAdmin(rowData);
        setVisibleModalMakeAdmin(!visibleModalMakkeAdmin);
      }
    } // Page list category


    if (typeButton.page.includes('category')) {
      setDataModalCategory(rowData);

      if (typeButton.label.includes('Editar categoria')) {
        setVisibleModalCategory(!visibleModalCategory);
      }

      if (typeButton.label.includes('Apagar categoria')) {
        setVisibleModalCategoryDelete(!visibleModalCategoryDelete);
      }

      return;
    } // Page list material


    if (typeButton.page.includes('material')) {
      setDataModalMaterial(rowData);

      if (typeButton.label.includes("Editar material")) {
        setVisibleModalMaterial(!visibleModalMaterial);
      }

      if (typeButton.label.includes("Apagar material")) {
        setVisibleModalMaterialDelete(!visibleModalMaterialDelete);
      }

      return;
    } // Page list classes


    if (typeButton.page.includes('classes')) {
      if (typeButton.label.includes("Inscritos")) {
        router_default().push(`/profiles/supplier/classes/${rowData.aventuraId}/subscribed/${rowData.id}`);
      }

      if (typeButton.label.includes("Alterar status")) {
        setDataModalClosedClasse(rowData);
        setVisibleModalClosedClasse(!visibleModalClosedClasse);
      }

      return;
    } // Page list subscribed


    if (typeButton.page.includes('subscribed')) {
      setDataModalSubscribed(rowData);

      if (typeButton.label.includes("Alterar status")) {
        setVisibleModalSubscribed(!visibleModalSubscribed);
      }

      return;
    }
  };

  const imageBodyTemplate = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("image")) {
        if (rowData[i.field]) {
          return /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
            url: rowData[i.field]
          }, i.field);
        }

        return /*#__PURE__*/jsx_runtime_.jsx(ImageRadius, {
          url: "/assets/perfil-default.png"
        }, i.field);
      }
    });
    return listItemRender;
  };

  const textLongBodyTemplate = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("textLong")) {
        if (rowData[i.field]) {
          return /*#__PURE__*/(0,jsx_runtime_.jsxs)("p", {
            title: rowData[i.field],
            children: [" ", rowData[i.field].slice(0, 50) + "...", " "]
          }, i.field);
        }

        return /*#__PURE__*/jsx_runtime_.jsx("p", {
          children: " - "
        }, i.field);
      }
    });
    return listItemRender;
  };

  const buttonActionBodyTemplate = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("buttonAction")) {
        return /*#__PURE__*/jsx_runtime_.jsx("div", {
          children: i.typeButton.map((y, index) => {
            if (y.page === 'user' && y.label.includes('Tornar admin') || y.label.includes('Remover admin')) {
              if (rowData.perfis.includes('adm')) {
                y.label = "Remover admin";
              } else {
                y.label = "Tornar admin";
              }
            }

            return /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
              style: {
                padding: "2px 2px 0px 2px",
                margin: "2px"
              },
              onClick: () => buttonActionValidatorPage(rowData, y),
              text: y.label,
              sizeText: 13
            }, index);
          })
        }, i.field);
      }
    });
    return listItemRender;
  };

  const iconStrBodyTemplatePageDepends = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("iconStr")) {
        let typeIconRender = rowData[i.field].split(","); // @ts-ignore

        return typeIconRender.map((i, index) => {
          if (i.includes("estabelecimento")) {
            return /*#__PURE__*/(0,jsx_runtime_.jsxs)("span", {
              children: [/*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaStore */.KSn, {
                color: "#006993",
                size: 18,
                title: i
              }), " \xA0"]
            }, index);
          }

          if (i.includes("cliente")) {
            return /*#__PURE__*/(0,jsx_runtime_.jsxs)("span", {
              children: [/*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaUserAlt */.q1E, {
                color: "#006993",
                size: 18,
                title: i
              }), " \xA0"]
            }, index);
          }

          if (i.includes("adm")) {
            return /*#__PURE__*/jsx_runtime_.jsx("span", {
              children: /*#__PURE__*/jsx_runtime_.jsx(index_esm/* FaUserCog */.VRY, {
                color: "#006993",
                size: 18,
                title: i
              })
            }, index);
          }
        });
      }
    });
    return listItemRender;
  };

  const dateBodyTemplate = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("date")) {
        if (rowData[i.field]) {
          return /*#__PURE__*/(0,jsx_runtime_.jsxs)("p", {
            children: [" ", rowData[i.field].split("-").reverse().join("/"), " "]
          }, i.field);
        }

        return /*#__PURE__*/jsx_runtime_.jsx("p", {
          children: " - "
        }, i.field);
      }
    });
    return listItemRender;
  };

  const iconStrBodyTemplateElement = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("elementIcon")) {
        var _rowData$i$field, _rowData$i$field2, _rowData$i$field3;

        if ((_rowData$i$field = rowData[i.field]) !== null && _rowData$i$field !== void 0 && _rowData$i$field.includes('T')) {
          return /*#__PURE__*/jsx_runtime_.jsx(earth/* default */.Z, {
            width: 55,
            height: 55,
            active: true
          });
        } else if ((_rowData$i$field2 = rowData[i.field]) !== null && _rowData$i$field2 !== void 0 && _rowData$i$field2.includes('G')) {
          return /*#__PURE__*/jsx_runtime_.jsx(water/* default */.Z, {
            width: 55,
            height: 55,
            active: true
          });
        }

        if ((_rowData$i$field3 = rowData[i.field]) !== null && _rowData$i$field3 !== void 0 && _rowData$i$field3.includes('A')) {
          return /*#__PURE__*/jsx_runtime_.jsx(air/* default */.Z, {
            width: 55,
            height: 55,
            active: true
          });
        }

        return '-';
      }
    });
    return listItemRender;
  };

  const labelStrBodyTemplate = rowData => {
    const listItemRender = typeData.map(i => {
      if (i.type.includes("labelData")) {
        if (rowData[i.field] && rowData[i.field] === 'PENDENTE' || rowData[i.field] === 'FECHADA') {
          return /*#__PURE__*/jsx_runtime_.jsx("div", {
            style: {
              backgroundColor: '#FBCB20',
              padding: '5px',
              borderRadius: '100px',
              color: 'white'
            },
            children: rowData[i.field]
          });
        }

        if (rowData[i.field] && rowData[i.field] === 'PRESENTE' || rowData[i.field] === 'ABERTA') {
          return /*#__PURE__*/jsx_runtime_.jsx("div", {
            style: {
              backgroundColor: '#4CD964',
              padding: '5px',
              borderRadius: '100px',
              color: 'white'
            },
            children: rowData[i.field]
          });
        }

        if (rowData[i.field]) {
          return /*#__PURE__*/jsx_runtime_.jsx("div", {
            style: {
              backgroundColor: '#D5403B',
              padding: '5px',
              borderRadius: '100px',
              color: 'white'
            },
            children: rowData[i.field]
          });
        }

        return '-';
      }
    });
    return listItemRender;
  };

  {
    /* @ts-ignore */
  }
  const dynamicColumns = (_props$columns = props.columns) === null || _props$columns === void 0 ? void 0 : _props$columns.map((col, i) => {
    if (col.type.includes('image')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: imageBodyTemplate
      }, col.field);
    }

    if (col.type.includes('textLong')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: textLongBodyTemplate
      }, col.field);
    }

    if (col.type.includes('buttonAction')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: buttonActionBodyTemplate
      }, col.field);
    }

    if (col.type.includes('iconStr')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: iconStrBodyTemplatePageDepends
      }, col.field);
    }

    if (col.type.includes('elementIcon')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: iconStrBodyTemplateElement
      }, col.field);
    }

    if (col.type.includes('date')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: dateBodyTemplate
      }, col.field);
    }

    if (col.type.includes('labelData')) {
      {
        /* @ts-ignore */
      }
      return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
        field: col.field,
        header: col.header,
        body: labelStrBodyTemplate
      }, col.field);
    }

    {
      /* @ts-ignore */
    }
    return /*#__PURE__*/jsx_runtime_.jsx(column_.Column, {
      field: col.field,
      header: col.header
    }, col.field);
  });
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(MaterialModal/* default */.Z, {
      visible: visibleModalMaterial,
      data: dataModalMaterial,
      onHide: () => {
        setVisibleModalMaterial(!visibleModalMaterial);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(DeleteModalMaterial, {
      visible: visibleModalMaterialDelete,
      data: dataModalMaterial,
      onHide: () => {
        setVisibleModalMaterialDelete(!visibleModalMaterialDelete);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(CategoryModal/* default */.Z, {
      visible: visibleModalCategory,
      data: dataModalCategory,
      onHide: () => {
        setVisibleModalCategory(!visibleModalCategory);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(DeleteModalCategory, {
      visible: visibleModalCategoryDelete,
      data: dataModalCategory,
      onHide: () => {
        setVisibleModalCategoryDelete(!visibleModalCategoryDelete);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(SupplierModalComission, {
      visible: visibleModalSupplierComission,
      data: dataModalSupplierComission,
      onHide: () => {
        setVisibleModalSupplierComission(!visibleModalSupplierComission);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(ModalMakeAdmin, {
      visible: visibleModalMakkeAdmin,
      data: dataModalMakeAdmin,
      onHide: () => {
        setVisibleModalMakeAdmin(!visibleModalMakkeAdmin);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(SubscribedModal_DeleteModalCategory, {
      visible: visibleModalSubscribed,
      data: dataModalSubscribed,
      onHide: () => {
        setVisibleModalSubscribed(!visibleModalSubscribed);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(ClosedClasseModal, {
      visible: visibleModalClosedClasse,
      data: dataModalClosedClasse,
      onHide: () => {
        setVisibleModalClosedClasse(!visibleModalClosedClasse);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx(ChangeUserPasswordModal, {
      visible: visibleModalChangePassword,
      data: dataModalUser,
      onHide: () => {
        setVisibleModalChangePassword(!visibleModalChangePassword);
      }
    }), /*#__PURE__*/jsx_runtime_.jsx("div", {
      className: "datatable-responsive",
      children: /*#__PURE__*/jsx_runtime_.jsx(datatable_.DataTable, {
        value: props.values,
        className: "p-datatable-responsive",
        children: dynamicColumns
      })
    })]
  });
}
const ImageRadius = (external_styled_components_default()).div`
  width: 40px;
  height: 40px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  margin-inline: auto;
`;

/***/ }),

/***/ 1244:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ MaterialModal)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/app/components/MaterialModal/styles.ts

const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const InputContainer = (external_styled_components_default()).div`
    width: 100%;
    display: flex;
`;
// EXTERNAL MODULE: ./src/core/hooks/useMaterial.ts
var useMaterial = __webpack_require__(8726);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
;// CONCATENATED MODULE: ./src/app/components/MaterialModal/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










function MaterialModal(props) {
  const toast = (0,external_react_.useRef)(null);
  const {
    saveDataMaterial
  } = (0,useMaterial/* default */.Z)();
  const {
    0: visible,
    1: setVisible
  } = (0,external_react_.useState)(false);
  const {
    0: material,
    1: setMaterial
  } = (0,external_react_.useState)({
    descricao: null,
    descricaoEn: null,
    descricaoEs: null
  });
  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);

  const saveMaterialDataDto = async () => {
    if (props.data && props.data.id) {
      setMaterial(prevState => {
        return _objectSpread(_objectSpread({}, prevState), {}, {
          id: props.data.id
        });
      });
      props.data.descricao = material.descricao;
      props.data.descricaoEn = material.descricaoEn;
      props.data.descricaoEs = material.descricaoEs;
    }

    if (material && material.descricao && material.descricaoEn && material.descricaoEs) {
      const response = await saveDataMaterial(material);

      if (response.status === 200) {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, "Material salvo com sucesso");
      } else {
        util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao salvar material");
      }
    } else {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, "Preencha todos os campos");
    }

    forceUpdate();
    setMaterial({
      descricao: null,
      descricaoEn: null,
      descricaoEs: null
    });
    props.onHide();
  };

  (0,external_react_.useEffect)(() => {
    setVisible(props.visible);
    setMaterial(props.data);
  }, [props.visible]);
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
      header: material !== null && material !== void 0 && material.id ? "Salvar Material" : "Novo material",
      visible: visible,
      style: {
        width: '50vw'
      },
      onHide: () => props.onHide(),
      children: /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
        children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
          children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
            inputs: 1,
            children: [/*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomePortugues",
                label: "Nome em portugues",
                placeholder: "Capacete",
                value: (material === null || material === void 0 ? void 0 : material.descricao) || "",
                onChange: i => setMaterial(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    descricao: i.target.value
                  });
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomeIngles",
                label: "Nome em ingl\xEAs",
                placeholder: "Helmet",
                value: (material === null || material === void 0 ? void 0 : material.descricaoEn) || "",
                onChange: i => setMaterial(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    descricaoEn: i.target.value
                  });
                })
              })
            }), /*#__PURE__*/jsx_runtime_.jsx(InputContainer, {
              children: /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                name: "nomeEspanhol",
                label: "Nome em espanhol",
                placeholder: "Casco",
                value: (material === null || material === void 0 ? void 0 : material.descricaoEs) || "",
                onChange: i => setMaterial(prevState => {
                  return _objectSpread(_objectSpread({}, prevState), {}, {
                    descricaoEs: i.target.value
                  });
                })
              })
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
            type: "button",
            onClick: () => saveMaterialDataDto(),
            text: "Salvar altera\xE7\xF5es"
          })]
        })
      })
    })]
  });
}

/***/ }),

/***/ 2156:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useCategory)
/* harmony export */ });
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6402);

function useCategory() {
  const getDataCategory = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Categoria/Filtrar/Pageable`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC',
        sortField: 'nome'
      }
    });
  };

  const saveDataCategory = async category => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Categoria`, category);
  };

  const deleteDataCategory = async category => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.delete */ .Z.delete(`/WS/Categoria/${category.id}`);
  };

  return {
    getDataCategory,
    saveDataCategory,
    deleteDataCategory
  };
}

/***/ }),

/***/ 8726:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useMaterial)
/* harmony export */ });
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6402);

function useMaterial() {
  const getDataMaterial = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Material/Listagem/Filtrar`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC',
        sortField: 'descricao'
      }
    });
  };

  const saveDataMaterial = async material => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Material`, material);
  };

  const deleteDataMaterial = async material => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.delete */ .Z.delete(`/WS/Material/${material.id}`);
  };

  return {
    getDataMaterial,
    saveDataMaterial,
    deleteDataMaterial
  };
}

/***/ })

};
;