"use strict";
exports.id = 5980;
exports.ids = [5980];
exports.modules = {

/***/ 7909:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CE": () => (/* binding */ PreferencesProvider),
/* harmony export */   "A0": () => (/* binding */ usePreferencesContext)
/* harmony export */ });
/* unused harmony export PreferencesContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5282);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9297);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5980);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6731);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);





const PreferencesContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)({});
const PreferencesProvider = ({
  children
}) => {
  const {
    0: preferences,
    1: setPreferences
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({
    language: "pt"
  });
  const {
    updateUserLanguage
  } = (0,_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .default */ .Z)();

  const changeLanguage = language => {
    if (language != preferences.language) {
      //**Garantindo que o cookie não será setado como pt-BR */
      if (language && language.toLowerCase().includes("br")) {
        language = "pt";
      }

      (0,nookies__WEBPACK_IMPORTED_MODULE_1__.setCookie)(undefined, "language", language, {
        path: "/",
        maxAge: 30 * 24 * 60 * 60 * 2
      });
      updateUserLanguage(language);
      next_router__WEBPACK_IMPORTED_MODULE_4___default().reload();
    }
  };

  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    setPreferences({
      language: (0,nookies__WEBPACK_IMPORTED_MODULE_1__.parseCookies)(undefined, {
        path: "/"
      }).language || "pt"
    });
  }, []);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(PreferencesContext.Provider, {
    value: {
      preferences,
      changeLanguage,
      setPreferences
    },
    children: children
  });
};
const usePreferencesContext = () => (0,react__WEBPACK_IMPORTED_MODULE_2__.useContext)(PreferencesContext);

/***/ }),

/***/ 9263:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dr": () => (/* binding */ UserProvider),
/* harmony export */   "SE": () => (/* binding */ useUserContext)
/* harmony export */ });
/* unused harmony export UserContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5282);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6731);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9297);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5980);
/* harmony import */ var _PreferencesContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7909);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






const UserContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_3__.createContext)({});
var savedUser = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(undefined, {
  path: "/"
}).user;
const UserProvider = ({
  children
}) => {
  const {
    0: isAuthenticated,
    1: setIsAutheticated
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const {
    0: user,
    1: setUser
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(savedUser ? JSON.parse(savedUser) : {});
  const {
    getUpdatedProfile
  } = (0,_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .default */ .Z)();
  const {
    changeLanguage,
    preferences,
    setPreferences
  } = (0,_PreferencesContext__WEBPACK_IMPORTED_MODULE_5__/* .usePreferencesContext */ .A0)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_1__.useRouter)();
  const updateUser = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(async () => {
    let savedUser = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(undefined, {
      path: "/"
    }).user;
    let token = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(undefined, {
      path: "/"
    }).access_token;
    setIsAutheticated(true);

    if (savedUser && token) {
      getUpdatedProfile(JSON.parse(savedUser).id).then(result => {
        setUser(result.data);
        (0,nookies__WEBPACK_IMPORTED_MODULE_2__.setCookie)(undefined, "user", JSON.stringify(result.data), {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2
        });

        if (result.data.linguagemAtual != router.locale) {
          changeLanguage(result.data.linguagemAtual);
          setPreferences(_objectSpread(_objectSpread({}, preferences), {}, {
            language: result.data.linguagemAtual
          }));
        }
      });
    }
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    updateUser();
  }, [updateUser]);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    let savedUser = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(undefined, {
      path: "/"
    }).user;
    let token = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(undefined, {
      path: "/"
    }).access_token;

    if (savedUser && token) {
      setIsAutheticated(true);
    } else {
      setIsAutheticated(false);
    }
  }, [user]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(UserContext.Provider, {
    value: {
      user,
      setUser,
      isAuthenticated,
      updateUser
    },
    children: children
  });
};
const useUserContext = () => (0,react__WEBPACK_IMPORTED_MODULE_3__.useContext)(UserContext);

/***/ }),

/***/ 5980:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useUser)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6731);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _contexts_UserContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9263);
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6402);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





function useUser() {
  const {
    user,
    isAuthenticated,
    setUser
  } = (0,_contexts_UserContext__WEBPACK_IMPORTED_MODULE_2__/* .useUserContext */ .SE)();

  const getDataEditing = async () => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.get */ .Z.get(`/WS/UsuarioRelty/${user.id}/Dto/Cliente`);
  };

  const saveDataEditing = async userEditDto => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post(`/WS/UsuarioRelty/Editar`, userEditDto);
  };

  const alterProfile = async profile => {
    await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post(`WS/UsuarioRelty/AlterarPerfil/${profile}`).then(result => {
      let updatedUser = _objectSpread({}, user);

      updatedUser.perfilAtual = profile;
      updatedUser.clienteId = result.data.clienteId;
      updatedUser.estabelecimentoId = result.data.estabelecimentoId;
      updateUserInCookie(updatedUser);
    });
  };

  const changeUserPassword = async (id, password) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post(`/WS/UsuarioRelty/AlterarSenha`, {
      id: id,
      senha: password
    });
  };

  const turnUserIntoAdmin = async id => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post(`/WS/UsuarioRelty/AlternarAdm/${id}`, {});
  };

  const createAdminUser = async body => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post("/WS/UsuarioRelty/Criar/Admin", body);
  };

  const updateUserInCookie = user => {
    setUser(user);
    (0,nookies__WEBPACK_IMPORTED_MODULE_1__.setCookie)(undefined, "user", JSON.stringify(user), {
      path: "/",
      maxAge: 30 * 24 * 60 * 60 * 2
    });
    redirectByUserProfile(user);
  };

  const getUpdatedProfile = async id => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.get */ .Z.get(`WS/UsuarioRelty/Dados/${id}`);
  }; ///Esses metodos usam o cookie por questão de serem chamados no contexto
  // de Preferencias e não ter acesso ao userContext


  const updateUserLanguage = async language => {
    if ((0,nookies__WEBPACK_IMPORTED_MODULE_1__.parseCookies)(undefined, {
      path: "/"
    }).access_token) {
      await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post("/WS/UsuarioRelty/Linguagem", {
        linguagem: language
      });
    }
  };

  const updateOneSignalToken = async token => {
    if ((0,nookies__WEBPACK_IMPORTED_MODULE_1__.parseCookies)(undefined, {
      path: "/"
    }).access_token) {
      await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post("/WS/UsuarioRelty/OneSignal", {
        onesignalToken: token
      });
    }
  };

  async function makeUserAdm(id) {
    return await _services_api__WEBPACK_IMPORTED_MODULE_3__/* .default.post */ .Z.post(`/WS/UsuarioRelty/AlternarAdm/${id}`, null);
  }

  const redirectByUserProfile = user => {
    let pathname = window.location.pathname;

    if (pathname.includes("/profiles/supplier") && user.perfilAtual == "C") {
      next_router__WEBPACK_IMPORTED_MODULE_0___default().replace("/profiles/user");
      return;
    }

    if (pathname.includes("/profiles/user") && user.perfilAtual == "E") {
      next_router__WEBPACK_IMPORTED_MODULE_0___default().replace("/profiles/supplier");
      return;
    }
  };

  return {
    getDataEditing,
    saveDataEditing,
    alterProfile,
    changeUserPassword,
    turnUserIntoAdmin,
    createAdminUser,
    getUpdatedProfile,
    updateUserInCookie,
    updateUserLanguage,
    updateOneSignalToken,
    makeUserAdm
  };
}

/***/ })

};
;