"use strict";
exports.id = 5548;
exports.ids = [5548];
exports.modules = {

/***/ 7139:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "u": () => (/* binding */ AdventureType)
/* harmony export */ });
let AdventureType;

(function (AdventureType) {
  AdventureType["T"] = "T";
  AdventureType["A"] = "A";
  AdventureType["G"] = "G";
})(AdventureType || (AdventureType = {}));

/***/ }),

/***/ 9763:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "v2": () => (/* binding */ baseURL),
/* harmony export */   "Y2": () => (/* binding */ tokenConfig),
/* harmony export */   "ac": () => (/* binding */ getApi),
/* harmony export */   "D7": () => (/* binding */ cleanSession)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2376);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6850);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(qs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_2__);



const baseURL = "https://reltyapp.com.br/api"; //process.env.NEXT_PUBLIC_API;

console.log('apiServerSide ==>', baseURL);
const tokenConfig = {
  headers: {
    Authorization: "Basic QVBQOjRQUA==",
    "Content-Type": "application/x-www-form-urlencoded"
  }
};
function getApi(ctx) {
  const instance = axios__WEBPACK_IMPORTED_MODULE_0___default().create({
    baseURL: baseURL,
    headers: {
      "Content-Type": "application/json;charset=UTF-8"
    }
  });
  instance.interceptors.request.use(function (config) {
    const access_token = getToken(ctx);

    if (access_token) {
      config.headers = {
        "Content-Type": "application/json;charset=UTF-8",
        Authorization: "Bearer " + access_token
      };
    }

    return config;
  }, function (error) {
    // Faça algo com erro da solicitação
    return Promise.reject(error);
  });
  instance.interceptors.response.use(response => {
    return response;
  }, async function (error) {
    var _error$response;

    const access_token = getToken(ctx);

    if (((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 401 && access_token) {
      await refreshToken(error);
      const newToken = getToken(ctx);

      if (newToken) {
        error.config.headers = {
          "Content-Type": "application/json;charset=UTF-8",
          Authorization: "Bearer " + newToken
        };
        return Promise.resolve(axios__WEBPACK_IMPORTED_MODULE_0___default().request(error.config));
      }
    }

    return Promise.reject(error);
  });
  return instance;
}

async function refreshToken(error) {
  return new Promise((resolve, reject) => {
    try {
      const refresh_token = getRefreshToken();
      let url = "/oauth/token";
      let body = {
        client: "NAVEGADOR",
        refresh_token: refresh_token,
        grant_type: "refresh_token"
      };
      axios__WEBPACK_IMPORTED_MODULE_0___default().post(baseURL + url, qs__WEBPACK_IMPORTED_MODULE_1___default().stringify(body), tokenConfig).then(async res => {
        (0,nookies__WEBPACK_IMPORTED_MODULE_2__.setCookie)(undefined, "access_token", res.data.access_token, {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2
        });
        (0,nookies__WEBPACK_IMPORTED_MODULE_2__.setCookie)(undefined, "refresh_token", res.data.refresh_token, {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2
        });
        return resolve(res);
      }).catch(err => {
        console.log(err);
        cleanSession();
        return reject(error);
      });
    } catch (err) {
      return reject(err);
    }
  });
}

function getToken(ctx) {
  let token = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(ctx).access_token;

  if (token) {
    try {
      return JSON.parse(token);
    } catch (error) {
      return token;
    }
  }
}

function getRefreshToken(ctx) {
  let refreshToken = (0,nookies__WEBPACK_IMPORTED_MODULE_2__.parseCookies)(ctx).refresh_token;

  if (refreshToken) {
    try {
      return JSON.parse(refreshToken);
    } catch (error) {
      return refreshToken;
    }
  }
}

function cleanSession() {
  (0,nookies__WEBPACK_IMPORTED_MODULE_2__.destroyCookie)(undefined, "user", {
    path: "/"
  });
  (0,nookies__WEBPACK_IMPORTED_MODULE_2__.destroyCookie)(undefined, "refresh_token", {
    path: "/"
  });
  (0,nookies__WEBPACK_IMPORTED_MODULE_2__.destroyCookie)(undefined, "access_token", {
    path: "/"
  });
}

/***/ }),

/***/ 27:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Util)
});

// EXTERNAL MODULE: external "nookies"
var external_nookies_ = __webpack_require__(5998);
;// CONCATENATED MODULE: ./src/core/models/enums/AdventureOrder.ts
let AdventureOrder;

(function (AdventureOrder) {
  AdventureOrder["M"] = "M";
})(AdventureOrder || (AdventureOrder = {}));
// EXTERNAL MODULE: ./src/core/models/enums/AdventureType.ts
var AdventureType = __webpack_require__(7139);
;// CONCATENATED MODULE: ./src/core/utils/util.ts




function showSucessToast(ref, message) {
  if (ref.current && message) {
    var _ref$current;

    (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.show({
      severity: "success",
      summary: message,
      detail: "",
      contentClassName: ""
    });
  }
}

function showWarnToast(ref, message) {
  if (ref.current && message) {
    var _ref$current2;

    (_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.show({
      severity: "warn",
      summary: message,
      detail: "",
      contentClassName: ""
    });
  }
}

function showErrorToast(ref, message) {
  if (ref.current && message) {
    var _ref$current3;

    (_ref$current3 = ref.current) === null || _ref$current3 === void 0 ? void 0 : _ref$current3.show({
      severity: "error",
      summary: message,
      detail: "",
      contentClassName: ""
    });
  }
}

function sendToAnyPage(res, path) {
  res.statusCode = 302;
  res.setHeader("Location", path);
  return {
    props: {}
  };
}

function redirectToSelectedLanguage(ctx, baseUrl) {
  const {
    res
  } = ctx;
  res.statusCode = 302;
  const language = `/${(0,external_nookies_.parseCookies)(ctx).language || "pt"}`;
  let url = `${!language || language == "/pt" || language.toLowerCase() == "/pt-br" ? "" : language}${baseUrl}`;
  return {
    redirect: {
      destination: url,
      permanent: false
    },
    props: {}
  };
}

function sendToHomePage(res, page = 1) {
  res.statusCode = 302;
  res.setHeader("Location", `/home?page=${page}`);
  return {
    props: {
      page
    }
  };
}

function sendToSupplierAdventures(res, page = 1) {
  res.statusCode = 302;
  res.setHeader("Location", `/profiles/supplier/adventures?page=${page}`);
  return {
    props: {
      page
    }
  };
}

function sendToUserAdventures(res, page = 1) {
  res.statusCode = 302;
  res.setHeader("Location", `/adventures?page=${page}`);
  return {
    props: {
      page
    }
  };
}

function sendToFavoritesPage(res, page = 1) {
  res.statusCode = 302;
  res.setHeader("Location", `/favorites?page=${page}`);
  return {
    props: {
      page
    }
  };
}

function getColorByAdventureType(type) {
  switch (type) {
    case AdventureType/* AdventureType.A */.u.A:
      return "#58BCFF";

    case AdventureType/* AdventureType.G */.u.G:
      return "#00CBC5";

    case AdventureType/* AdventureType.T */.u.T:
      return "#D15E34";

    default:
      return "#006993";
  }
}

function getColorByDifficulty(type) {
  switch (type) {
    case "F":
      return "#4CD964";

    case "M":
      return "#FBCB20";

    case "D":
      return "#D5403B";

    default:
      return "#FFFFFF";
  }
}

function getNameByAdventureType(type) {
  switch (type) {
    case AdventureType/* AdventureType.A */.u.A:
      return "air";

    case AdventureType/* AdventureType.G */.u.G:
      return "water";

    case AdventureType/* AdventureType.T */.u.T:
      return "earth";

    default:
      return "";
  }
}

function getNameByAdventureDifficulty(difficulty) {
  switch (difficulty) {
    case "F":
      return "easy";

    case "M":
      return "medium";

    case "D":
      return "hard";

    default:
      return "";
  }
}

function getValidAdventureType(type) {
  switch (type) {
    case "A":
      return AdventureType/* AdventureType.A */.u.A;

    case "G":
      return AdventureType/* AdventureType.G */.u.G;

    case "T":
      return AdventureType/* AdventureType.T */.u.T;

    default:
      return null;
  }
}

function mountAdventureFilterParams(search, adventureType, price, mostPracticed) {
  let newUrl = "";

  if (adventureType) {
    newUrl = newUrl + "&adventureType=" + adventureType;
  }

  if (search && search != "") {
    newUrl = newUrl + "&search=" + search;
  }

  if (price && price != "") {
    newUrl = newUrl + "&price=" + price;
  }

  if (mostPracticed && mostPracticed == AdventureOrder.M) {
    newUrl = newUrl + "&order=" + mostPracticed;
  }

  return newUrl;
}

function mountAdventureOrder(order) {
  let newUrl = "";

  if (order && order == AdventureOrder.M) {
    newUrl = newUrl + "&sortField=analise.quantidadeVezesPraticada&sortDirection=DESC";
  }

  return newUrl;
}
/**
 *
 * A função deve ser chamada sempre dentro de um useEffect ao montar o componente por não funcionar do lado do servidor
 */


function isMobile() {
  try {
    if (navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPod/i) || navigator.userAgent.match(/BlackBerry/i) || navigator.userAgent.match(/Windows Phone/i)) {
      return true; // está utilizando celular
    } else {
      return false; // não é celular
    }
  } catch (error) {
    return false;
  }
}

const isAndroid = () => {
  try {
    if (navigator.userAgent.match(/Android/i)) {
      return true; // está utilizando android
    } else {
      return false; // não é android
    }
  } catch (error) {}
};

const getPinImageByAdventureType = type => {
  switch (type) {
    case AdventureType/* AdventureType.A */.u.A:
      return "/assets/airpin.svg";

    case AdventureType/* AdventureType.G */.u.G:
      return "/assets/waterpin.svg";

    case AdventureType/* AdventureType.T */.u.T:
      return "/assets/earthpin.svg";

    default:
      return "/assets/normalpin.svg";
  }
};

const Util = {
  //toasts
  showErrorToast,
  showWarnToast,
  showSucessToast,
  //adventures
  getColorByAdventureType,
  getColorByDifficulty,
  getNameByAdventureType,
  getNameByAdventureDifficulty,
  getValidAdventureType,
  mountAdventureFilterParams,
  mountAdventureOrder,
  getPinImageByAdventureType,
  //adventures
  isMobile,
  isAndroid,
  //redirects
  sendToHomePage,
  sendToSupplierAdventures,
  sendToFavoritesPage,
  sendToUserAdventures,
  sendToAnyPage,
  redirectToSelectedLanguage
};

/***/ })

};
;