"use strict";
exports.id = 3976;
exports.ids = [3976];
exports.modules = {

/***/ 3976:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useEstablishment)
/* harmony export */ });
/* harmony import */ var _contexts_UserContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9263);
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6402);


function useEstablishment() {
  const {
    user
  } = (0,_contexts_UserContext__WEBPACK_IMPORTED_MODULE_0__/* .useUserContext */ .SE)();

  const getDataEditing = async () => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.get */ .Z.get(`/WS/UsuarioRelty/${user.id}/Dto/Estabelecimento`);
  };

  const saveDataEditing = async userEditDto => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`/WS/UsuarioRelty/Editar`, userEditDto);
  };

  const getDataCategoria = async () => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.get */ .Z.get(`/WS/Categoria`);
  };

  const getDataMaterial = async () => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.get */ .Z.get(`/WS/Material`);
  };

  const getListTimeLocalStorage = () => {
    {
      /* @ts-ignore */
    }
    return JSON.parse(sessionStorage.getItem('horarios')) == null ? [] : JSON.parse(sessionStorage.getItem('horarios'));
  };

  const saveListTimeLocalStorage = value => {
    sessionStorage.setItem('horarios', JSON.stringify(value));
  };

  const getDataOverview = async filtro => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`/WS/Estabelecimento/Overview`, filtro);
  };

  const getDataOverviewAdmin = async filtro => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`/WS/UsuarioRelty/Admin/Overview`, filtro);
  };

  const getDataListFilter = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`WS/Estabelecimento/Listagem/Filtrar`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC'
      }
    });
  };

  const getDataListUserFilter = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`WS/UsuarioRelty/Listagem/Filtrar`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC',
        sortField: 'nome'
      }
    });
  };

  const getDataDetailSupplier = async supplierId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.get */ .Z.get(`WS/UsuarioRelty/Estabelecimento/${supplierId}/Dto/Estabelecimento`);
  };

  const saveSupplierComission = async comission => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_1__/* .default.post */ .Z.post(`WS/Estabelecimento/AlterarPorcentagem`, comission);
  };

  return {
    getDataEditing,
    saveDataEditing,
    getDataCategoria,
    getDataMaterial,
    getListTimeLocalStorage,
    saveListTimeLocalStorage,
    getDataOverview,
    getDataListFilter,
    getDataListUserFilter,
    getDataOverviewAdmin,
    getDataDetailSupplier,
    saveSupplierComission
  };
}

/***/ })

};
;