"use strict";
exports.id = 3962;
exports.ids = [3962];
exports.modules = {

/***/ 3962:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "X2": () => (/* binding */ Row),
/* harmony export */   "sg": () => (/* binding */ Column),
/* harmony export */   "W2": () => (/* binding */ Container),
/* harmony export */   "WS": () => (/* binding */ ContainerText),
/* harmony export */   "xv": () => (/* binding */ Text),
/* harmony export */   "BZ": () => (/* binding */ InputGroup),
/* harmony export */   "Jd": () => (/* binding */ NoData),
/* harmony export */   "tY": () => (/* binding */ ImageAndNameContainer),
/* harmony export */   "Pn": () => (/* binding */ RateImage),
/* harmony export */   "lU": () => (/* binding */ TextContainer),
/* harmony export */   "WZ": () => (/* binding */ SupplierName),
/* harmony export */   "tS": () => (/* binding */ Stars)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9914);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var polished__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7158);
/* harmony import */ var polished__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(polished__WEBPACK_IMPORTED_MODULE_1__);


const Row = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    display: grid;
    position: relative;
    grid-template-columns: repeat(${p => p.col || '2'}, 1fr);
    justify-content: center;
    align-items: center;
    margin: auto;
    flex-direction: row;
    gap: 10px;
    padding: 10px 10px;
    max-width: 100%;

    @media screen and (max-width: 450px) {
        grid-template-columns: repeat(1, 1fr);
    }
`;
const Column = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    
    text-align: center;
    display: flex;
    width: 100%;
    flex-direction: column;
    padding: 10px 10px;
    align-itens: center;

    box-shadow: 0 3px 10px ${p => (0,polished__WEBPACK_IMPORTED_MODULE_1__.transparentize)(0.9, p.theme.pageForeground)};
    border-radius: ${p => p.theme.borderRadius};
    background-color: ${p => p.theme.activeElementBackground};
`;
const Container = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    display: flex;
    width: 100%;
    justify-content: center;
`;
const ContainerText = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    flex-direction: column;
    width: 100%;
    justify-content: center;
    display: grid;
`;
const Text = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().text)`
    font: normal normal ${p => p.fontWeight || 'normal'} ${p => p.fontSize || 16}px Poppins;
    margin: 10px 0;
    text-align: center;
`;
const InputGroup = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
const NoData = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    margin: auto;
    margin-top: 50px;

    h2 {
        text-align: center;
    }
`;
const ImageAndNameContainer = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    width: 100%;
    text-align: left;
    display: flex;
    flex-direction: row;
    justify-content: flex-start;
    align-items: start;
    margin: 1rem;
    color: ${p => p.theme.pageForeground};
    gap: 10px;
    padding: 10px;
    width: auto;
    border-bottom: 1px solid whitesmoke;
`;
const RateImage = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    width: 46px;
    height: 46px;
    background-image: url(${p => p.url});
    background-position: center;
    background-size: cover;
    border-radius: 100px;
`;
const TextContainer = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    display: flex;
    flex-direction: column;
    justify-content: center;
`;
const SupplierName = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().text)`
    font: normal normal bold 14px/21px Poppins;
`;
const Stars = (styled_components__WEBPACK_IMPORTED_MODULE_0___default().div)`
    display: flex;
    flex-direction: row;
    justify-content: start;
    align-items: center;
    gap: 5px;
`;

/***/ })

};
;