"use strict";
exports.id = 3852;
exports.ids = [3852];
exports.modules = {

/***/ 3046:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useMap)
/* harmony export */ });
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8528);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9297);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9914);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_googleMaps__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4738);
/* harmony import */ var _contexts_GeolocationContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(382);





function useMap() {
  const mapRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const userMarker = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const circleRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const theme = (0,styled_components__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
  const {
    setLocalizationMaps
  } = (0,_contexts_GeolocationContext__WEBPACK_IMPORTED_MODULE_4__/* .useGeolocationContext */ .kL)();

  const loadMap = (position, callback) => {
    (0,_utils_googleMaps__WEBPACK_IMPORTED_MODULE_3__/* .loadGoogleMaps */ ._)(() => {
      callback();
      mapRef.current = new window.google.maps.Map(mapRef.current, {
        center: position,
        zoom: 7
      });
      setMapCenter(position);
      map().setCenter(position);
      map().addListener('click', event => {
        setLocalizationMaps({
          lat: event.latLng.lat(),
          lng: event.latLng.lng()
        });
        setMapCenter({
          lat: event.latLng.lat(),
          lng: event.latLng.lng()
        });
      });
    });
  };

  const setMapCenter = (userPosition, legend = false, icon = "/assets/normalpin.svg") => {
    var infoWindow = new google.maps.InfoWindow();
    const marker = new window.google.maps.Marker({
      position: userPosition,
      title: i18next__WEBPACK_IMPORTED_MODULE_0___default().t("yourLocation"),
      map: map(),
      icon: icon
    });

    if (userMarker.current) {
      userMarker.current.setMap(null);
    }

    userMarker.current = marker;

    if (legend) {
      infoWindow.setPosition(marker.getPosition());
      infoWindow.setContent(`<div style='width:100%; text-align: center; font-family: Poppins'>${i18next__WEBPACK_IMPORTED_MODULE_0___default().t("yourLocation")}</div>`);
      infoWindow.setOptions({});
      infoWindow.setOptions({
        minWidth: 65
      });
      infoWindow.open(map(), marker);
      setTimeout(() => {
        infoWindow.close();
      }, 5000);
    }
  };

  const createCircle = (position, radius) => {
    if (circleRef.current) {
      circleRef.current.setMap(null);
    }

    circleRef.current = new google.maps.Circle({
      strokeColor: theme.primaryBackground,
      strokeOpacity: 0.8,
      strokeWeight: 2,
      fillColor: theme.primaryBackground,
      fillOpacity: 0.35,
      map: map(),
      center: position,
      radius: radius * 1000
    });
  };

  const searchPlaces = async text => {
    console.log(text);
    let results = await new window.google.maps.places.AutocompleteService().getPlacePredictions({
      input: text,
      types: ["(cities)"]
    });
    return results.predictions;
  };

  const getPlaceDetail = async (placeId, callBack) => {
    const placeService = new window.google.maps.places.PlacesService(map());
    let response = null;
    await placeService.getDetails({
      placeId: placeId,
      fields: ["geometry", "formatted_address"]
    }, result => {
      if (callBack) callBack(result);
    });
  };

  const map = () => {
    return mapRef.current;
  };

  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    return () => {
      (0,_utils_googleMaps__WEBPACK_IMPORTED_MODULE_3__/* .removeGoogleMaps */ .G)();
    };
  }, []);
  return {
    mapRef,
    circleRef,
    map,
    setMapCenter,
    loadMap,
    createCircle,
    searchPlaces,
    getPlaceDetail
  };
}

/***/ }),

/***/ 4918:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useMasks)
/* harmony export */ });
function useMasks() {
  const onlyNumbers = value => {
    value = value.replace(/\D/g, "");
    return !value ? "" : value;
  };

  const money = value => {
    return mask(value);
  };

  const unMaskedMoney = value => {
    return mask(value).value;
  };

  return {
    onlyNumbers,
    money,
    unMaskedMoney
  };

  function mask(value, precision = 2, decimalSeparator = ",", thousandSeparator = ".", allowNegative = false, prefix = "R$", suffix = "") {
    // provide some default values and arg validation.
    if (precision < 0) {
      precision = 0;
    } // precision cannot be negative


    if (precision > 20) {
      precision = 20;
    } // precision cannot be greater than 20


    if (value === null || value === undefined) {
      return {
        value: 0,
        maskedValue: ""
      };
    }

    value = String(value); //if the given value is a Number, let's convert into String to manipulate that

    if (value.length == 0) {
      return {
        value: 0,
        maskedValue: ""
      };
    } // extract digits. if no digits, fill in a zero.


    let digits = value.match(/\d/g) || ["0"];
    let numberIsNegative = false;

    if (allowNegative) {
      let negativeSignCount = (value.match(/-/g) || []).length; // number will be negative if we have an odd number of "-"
      // ideally, we should only ever have 0, 1 or 2 (positive number, making a number negative
      // and making a negative number positive, respectively)

      numberIsNegative = negativeSignCount % 2 === 1; // if every digit in the array is '0', then the number should never be negative

      let allDigitsAreZero = true;

      for (let idx = 0; idx < digits.length; idx += 1) {
        if (digits[idx] !== "0") {
          allDigitsAreZero = false;
          break;
        }
      }

      if (allDigitsAreZero) {
        numberIsNegative = false;
      }
    } // zero-pad a input


    while (digits.length <= precision) {
      digits.unshift("0");
    }

    if (precision > 0) {
      // add the decimal separator
      digits.splice(digits.length - precision, 0, ".");
    } // clean up extraneous digits like leading zeros.


    digits = Number(digits.join("")).toFixed(precision).split("");
    let raw = Number(digits.join(""));
    let decimalpos = digits.length - precision - 1; // -1 needed to position the decimal separator before the digits.

    if (precision > 0) {
      // set the final decimal separator
      digits[decimalpos] = decimalSeparator;
    } else {
      // when precision is 0, there is no decimal separator.
      decimalpos = digits.length;
    } // add in any thousand separators


    for (let x = decimalpos - 3; x > 0; x = x - 3) {
      digits.splice(x, 0, thousandSeparator);
    } // if we have a prefix or suffix, add them in.


    if (prefix.length > 0) {
      digits.unshift(prefix);
    }

    if (suffix.length > 0) {
      digits.push(suffix);
    } // if the number is negative, insert a "-" to
    // the front of the array and negate the raw value


    if (allowNegative && numberIsNegative) {
      digits.unshift("-");
      raw = -raw;
    }

    return {
      value: raw,
      maskedValue: digits.join("").trim()
    };
  }
}

/***/ })

};
;