"use strict";
exports.id = 382;
exports.ids = [382];
exports.modules = {

/***/ 382:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SO": () => (/* binding */ GeolocationProvider),
/* harmony export */   "kL": () => (/* binding */ useGeolocationContext)
/* harmony export */ });
/* unused harmony export GeolocationContext */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5282);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5998);
/* harmony import */ var nookies__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(nookies__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9297);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);



const GeolocationContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)({});
var savedLocation = (0,nookies__WEBPACK_IMPORTED_MODULE_1__.parseCookies)(undefined, {
  path: "/"
}).last_location;
const GeolocationProvider = ({
  children
}) => {
  const {
    0: lastLocation,
    1: setLastLocation
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(savedLocation ? JSON.parse(savedLocation) : {
    lat: -14.5512,
    lng: -52.5795
  });
  const {
    0: localizationMaps,
    1: setLocalizationMaps
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(position => {
        const userPosition = {
          lat: position.coords.latitude,
          lng: position.coords.longitude
        };
        (0,nookies__WEBPACK_IMPORTED_MODULE_1__.setCookie)(undefined, "last_location", JSON.stringify(userPosition), {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2
        });
        setLastLocation(userPosition);
      }, error => {
        ///VERIFICAR COMO SE COMPORTA EM OUTRAS APLICAÇÕES,
        // MAC PRECISA DAR PERMISSÃO DE LOCALIZAÇÃO NAS PREFERENCAS
        console.log(error);
      });
    } else {//NAVEGADOR SEM ACESSO A GEOLOCALIZAÇÃO
    }
  }, []);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(GeolocationContext.Provider, {
    value: {
      lastLocation,
      setLastLocation,
      localizationMaps,
      setLocalizationMaps
    },
    children: children
  });
};
const useGeolocationContext = () => (0,react__WEBPACK_IMPORTED_MODULE_2__.useContext)(GeolocationContext);

/***/ })

};
;