"use strict";
exports.id = 3802;
exports.ids = [3802];
exports.modules = {

/***/ 3802:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useAdventure)
/* harmony export */ });
/* harmony import */ var _services_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6402);

function useAdventure() {
  const favoriteAdventure = async id => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Aventura/${id}/Favoritar`);
  };

  const desfavoriteAdventure = async id => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`/WS/Aventura/${id}/Desfavoritar`);
  };

  const createAdventure = async body => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post("/WS/Aventura", body);
  };

  const getSchedulesAdventures = async adventureId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`WS/Aventura/${adventureId}/Horarios`);
  };

  const getAdventuresTime = async (adventureId, dateFormat) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`/WS/Aventura/${adventureId}/Horarios/${dateFormat}`);
  };

  const getListClasses = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/AventuraTurma/Filtrar/Pageable`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC'
      }
    });
  };

  const getListSubscribed = async (filtro, query) => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/ClienteAventuraAcompanhante/Filtrar`, filtro, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size,
        sortDirection: 'ASC'
      }
    });
  };

  const getCommunityAdventures = async query => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.post */ .Z.post(`WS/ClienteAventura/Comunidade/Pageable`, {}, {
      params: {
        page: query === null || query === void 0 ? void 0 : query.page,
        size: query === null || query === void 0 ? void 0 : query.size
      }
    });
  };

  const getDataPuchaseClientAdventure = async cliendId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`/WS/Cliente/${cliendId}/DadosCompra`);
  };

  const deleteDataAventure = async adventureId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.delete */ .Z.delete(`/WS/Aventura/${adventureId}`);
  };

  const getDataRating = async adventureId => {
    return await _services_api__WEBPACK_IMPORTED_MODULE_0__/* .default.get */ .Z.get(`/WS/Aventura/${adventureId}/Avaliacoes`);
  };

  return {
    favoriteAdventure,
    desfavoriteAdventure,
    getSchedulesAdventures,
    getListClasses,
    getListSubscribed,
    createAdventure,
    getCommunityAdventures,
    getAdventuresTime,
    getDataPuchaseClientAdventure,
    deleteDataAventure,
    getDataRating
  };
}

/***/ })

};
;