"use strict";
exports.id = 1760;
exports.ids = [1760];
exports.modules = {

/***/ 1760:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5282);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9297);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8475);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9914);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_3__);






function HeaderProfile(props) {
  const {
    publicProfile: profile
  } = props;
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)("common");
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(Wrapper, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(ProfileImage, {
      url: (profile === null || profile === void 0 ? void 0 : profile.urlFoto) || "/assets/perfil-default.png"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(InfosContainer, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(BoldText, {
        children: profile === null || profile === void 0 ? void 0 : profile.nome
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Text, {
        children: t("performed") + " " + ((profile === null || profile === void 0 ? void 0 : profile.quantidadeAventuras) || 0) + " " + t("adventures")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(FollowsContainer, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(BoldText, {
            children: (profile === null || profile === void 0 ? void 0 : profile.quantidadeSeguindo) || 0
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Text, {
            children: t("following")
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(BoldText, {
            children: (profile === null || profile === void 0 ? void 0 : profile.quantidadeSeguidores) || 0
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Text, {
            children: t("followers")
          })]
        })]
      })]
    })]
  });
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().memo(HeaderProfile));
const Wrapper = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().div)`
  width: 100%;
  color: ${p => p.theme.activeElementForeground};
  display: flex;
  flex-direction: row;
  align-items: center;
  margin-bottom: 20px;
`;
const InfosContainer = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().div)`
  height: 100%;
  display: flex;
  flex-direction: column;
  max-width: 300px;
  flex: 1;
  margin-left: 10px;
`;
const BoldText = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().text)`
  font: normal normal 600 20px/30px Poppins;
`;
const Text = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().text)`
  font: normal normal normal 11px/20px Poppins;
`;
const FollowsContainer = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().div)`
  display: flex;
  justify-content: space-between;
  min-width: 100px;

  div {
    display: flex;
    flex-direction: column;
    text-align: center;
  }
`;
const ProfileImage = (styled_components__WEBPACK_IMPORTED_MODULE_3___default().div)`
  width: 92px;
  height: 92px;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
`;

/***/ })

};
;