"use strict";
exports.id = 1629;
exports.ids = [1629];
exports.modules = {

/***/ 1629:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ WithAuthModal)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: ./src/app/components/CustomInput/index.tsx
var CustomInput = __webpack_require__(7697);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: external "formik"
var external_formik_ = __webpack_require__(7717);
// EXTERNAL MODULE: external "yup"
var external_yup_ = __webpack_require__(9440);
// EXTERNAL MODULE: ./src/core/hooks/useAuth.ts
var useAuth = __webpack_require__(7471);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: ./src/core/utils/exceptions.ts
var exceptions = __webpack_require__(504);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/mail.tsx
var mail = __webpack_require__(4730);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/password.tsx
var SvgIcons_password = __webpack_require__(3371);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
;// CONCATENATED MODULE: ./src/app/components/WithAuthModal/styles.ts

const ContentWrapper = (external_styled_components_default()).div`
  display: flex;
  justify-content: space-around;
  align-items: column;
  flex-direction: column;
`;
const ButtonContainer = (external_styled_components_default()).div`
  width: 100%;
  display: flex;
  flex-direction: column;
  margin-top: 20px;

  justify-content: center;
  align-items: center;

  span {
    margin-top: 12px;
    width: 100%;
  }
`;
const ForgotPassword = (external_styled_components_default()).div`
  display: flex;
  justify-content: center;
  margin-top: 10px;
`;
const Text = (external_styled_components_default()).text`
  font: normal normal normal 16px/25px Poppins;
  text-align: center;
  color: ${p => p.theme.primaryBackground};
  cursor: pointer;

  :active {
    opacity: 0.5;
  }
`;
// EXTERNAL MODULE: external "axios"
var external_axios_ = __webpack_require__(2376);
var external_axios_default = /*#__PURE__*/__webpack_require__.n(external_axios_);
// EXTERNAL MODULE: ./src/core/services/apiServerSide.ts
var apiServerSide = __webpack_require__(9763);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
;// CONCATENATED MODULE: ./src/app/components/WithAuthModal/index.tsx




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



















function WithAuthModal(Component) {
  const Wrapper = props => {
    const {
      t
    } = (0,external_next_i18next_.useTranslation)("common");
    const {
      0: authModal,
      1: setAuthModal
    } = (0,external_react_.useState)(false);
    const {
      0: loginActive,
      1: setLoginActive
    } = (0,external_react_.useState)(false);
    const {
      0: forgotPassword,
      1: setForgotPassword
    } = (0,external_react_.useState)(false);
    const {
      login
    } = (0,useAuth/* default */.Z)();
    const theme = (0,external_styled_components_.useTheme)();
    const toast = (0,external_react_.useRef)(null);

    const onHide = () => {
      setAuthModal(false);
      setLoginActive(false);
      setForgotPassword(false);
    };

    const setAuthModalOnLogin = () => {
      setAuthModal(true);
      setLoginActive(true);
    };

    const createAccount = () => {
      router_default().push("/register");
      onHide();
    };

    async function recoverPassword(email) {
      await external_axios_default().post(apiServerSide/* baseURL */.v2 + "/WS/UsuarioRelty/RecuperarSenha", {
        email: email
      }).then(result => {
        util/* Util.showSucessToast */.Z.showSucessToast(toast, t("passwordToEmail"));
        setForgotPassword(false);
      }).catch(error => {
        if (error.response.status == 412) {
          var _error$response$data;

          util/* Util.showErrorToast */.Z.showErrorToast(toast, (_error$response$data = error.response.data) === null || _error$response$data === void 0 ? void 0 : _error$response$data.descricao);
        } else {
          util/* Util.showErrorToast */.Z.showErrorToast(toast, t("onRecoverPasswordError"));
        }
      });
    }

    const initialValues = {
      email: "",
      password: ""
    };

    const onSubmit = async values => {
      try {
        await login(values.email, values.password);
        util/* Util.showSucessToast */.Z.showSucessToast(toast, t("successLogin"));
        onHide();
        setTimeout(() => {
          router_default().reload();
        }, 800);
      } catch (error) {
        console.log('errorLogin 2 ==>', error);

        if (error instanceof exceptions/* BadCredentialsException */.RD) {
          console.log('errorLogin 3 ==>', error.message);
          util/* Util.showWarnToast */.Z.showWarnToast(toast, error.message);
        } else {
          console.log('errorLogin 4 ==>', error);
          util/* Util.showErrorToast */.Z.showErrorToast(toast, t("errorLogin"));
        }
      }
    };

    const validationSchema = external_yup_.object({
      email: external_yup_.string().email(t("invalidEmail")).required(t("requiredField")),
      password: external_yup_.string().required(t("requiredField"))
    });
    return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
        ref: toast,
        position: "top-center"
      }), /*#__PURE__*/jsx_runtime_.jsx(dialog_.Dialog, {
        header: t(forgotPassword ? "emailToRecover" : loginActive ? "emailAndPassword" : "registerOrLogin"),
        visible: authModal,
        onHide: () => onHide(),
        children: /*#__PURE__*/jsx_runtime_.jsx(ContentWrapper, {
          children: loginActive ? /*#__PURE__*/jsx_runtime_.jsx(external_formik_.Formik, {
            initialValues: initialValues,
            validationSchema: validationSchema,
            onSubmit: onSubmit,
            validateOnChange: true,
            children: formik => {
              return /*#__PURE__*/(0,jsx_runtime_.jsxs)(external_formik_.Form, {
                children: [/*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                  id: "email",
                  name: "email",
                  label: t("email"),
                  placeholder: "example@gmail.com",
                  error: formik.errors.email && formik.touched.email,
                  icon: /*#__PURE__*/jsx_runtime_.jsx(mail/* default */.Z, {
                    width: 20,
                    height: 20
                  })
                }), !forgotPassword && /*#__PURE__*/jsx_runtime_.jsx(CustomInput/* default */.Z, {
                  id: "password",
                  name: "password",
                  label: t("password"),
                  type: "password",
                  placeholder: "******",
                  error: formik.errors.password && formik.touched.password,
                  icon: /*#__PURE__*/jsx_runtime_.jsx(SvgIcons_password/* default */.Z, {
                    width: 20,
                    height: 20
                  })
                }), /*#__PURE__*/jsx_runtime_.jsx(ButtonContainer, {
                  children: !forgotPassword ? /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                    children: [/*#__PURE__*/jsx_runtime_.jsx("span", {
                      children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                        text: t("login"),
                        disabled: !formik.isValid,
                        onClick: () => setLoginActive(true)
                      })
                    }), /*#__PURE__*/jsx_runtime_.jsx("span", {
                      children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                        type: "button",
                        text: t("createAccount"),
                        color: theme.secondaryBackground,
                        onClick: createAccount
                      })
                    })]
                  }) : /*#__PURE__*/jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                    children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                      type: "button",
                      text: t("recoverPassword"),
                      disabled: formik.errors.email ? true : false,
                      onClick: () => recoverPassword(formik.values.email)
                    })
                  })
                }), /*#__PURE__*/jsx_runtime_.jsx(ForgotPassword, {
                  children: /*#__PURE__*/jsx_runtime_.jsx(Text, {
                    onClick: () => setForgotPassword(!forgotPassword),
                    children: t(forgotPassword ? "login" : "forgotPassword")
                  })
                })]
              });
            }
          }) : /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
            children: [/*#__PURE__*/jsx_runtime_.jsx("p", {
              children: t("registerOrLoginToAcess")
            }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(ButtonContainer, {
              children: [/*#__PURE__*/jsx_runtime_.jsx("span", {
                children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                  text: t("login"),
                  onClick: () => setLoginActive(true)
                })
              }), /*#__PURE__*/jsx_runtime_.jsx("span", {
                children: /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
                  text: t("register"),
                  color: theme.secondaryBackground,
                  onClick: () => router_default().push("/register")
                })
              })]
            })]
          })
        })
      }), /*#__PURE__*/jsx_runtime_.jsx(Component, _objectSpread({
        setAuthModalOnLogin: setAuthModalOnLogin,
        setAuthModal: setAuthModal
      }, props))]
    });
  };

  return Wrapper;
}

/***/ })

};
;