"use strict";
exports.id = 1349;
exports.ids = [1349];
exports.modules = {

/***/ 1349:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ components_CardAdventure)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(5282);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(9297);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
// EXTERNAL MODULE: external "styled-components"
var external_styled_components_ = __webpack_require__(9914);
var external_styled_components_default = /*#__PURE__*/__webpack_require__.n(external_styled_components_);
// EXTERNAL MODULE: external "polished"
var external_polished_ = __webpack_require__(7158);
;// CONCATENATED MODULE: ./src/app/components/CardAdventure/styles.ts


const Image = (external_styled_components_default()).div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 69%;
  background-image: url(${p => p.url});
  background-position: center;
  background-size: cover;
  border-top-left-radius: ${p => p.theme.borderRadius};
  border-top-right-radius: ${p => p.theme.borderRadius};
`;
const FavoriteContainer = (external_styled_components_default()).div`
  position: absolute;
  right: 8px;
  top: 8px;
  cursor: pointer;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 10;
`;
const RatingContainer = external_styled_components_default()(FavoriteContainer)`
  left: 8px;
  top: 8px;
  max-width: 55px;
  height: 22px;
  background-color: ${p => p.theme.activeElementBackground};
  border-radius: ${p => p.theme.borderRadius};
  padding: 5px;
  justify-content: space-around;
`;
const Element = external_styled_components_default()(FavoriteContainer)`
  right: 8px;
  top: 195px;
  width: 60px;
`;
const Wrapper = (external_styled_components_default()).div`
  border-radius: ${p => p.theme.borderRadius};
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  width: 100%;
  min-height: 320px;
  color: ${p => p.theme.pageForeground};
  position: relative;

  transition: 0.25s ease;
  * {
    transition: 0.25s ease;
  }

  &:hover,
  &:focus {
    box-shadow: 0 0 0 4px
      ${p => (0,external_polished_.transparentize)(0.7, p.theme.primaryBackground)};
    outline: none;
    * {
      color: ${p => p.theme.primaryForeground};
    }

    ${Image} {
      height: 100%;
      border-radius: ${p => p.theme.borderRadius};
    }

    ${RatingContainer},
    ${Element} {
      text {
        color: ${p => p.theme.pageForeground};
      }
    }
  }
`;
const TitleContainer = (external_styled_components_default()).div`
  background-color: rgba(0, 0, 0, 0.5);
  color: #fff;
  text-align: center;
  right: 8px;
  top: 8px;
  top: 100px;
  width: 250px;
  line-height: 30px;
  height: 30px;
`;
const InfoContainer = (external_styled_components_default()).div`
  position: absolute;
  top: 69%;
  width: 65%;
  height: 30%;
  padding: 10px 10px;
  display: flex;
  flex-direction: column;
`;
const InfoAccomplishedContainer = (external_styled_components_default()).div`
  position: absolute;
  top: 88%;
  width: 65%;
  height: 30%;
  padding: 10px 10px;
  display: flex;
  flex-direction: column;
  gap: 10px;
`;
const ButtonAction = (external_styled_components_default()).button`
  background-color: ${p => p.theme.primaryBackground};
  border-radius: ${p => p.theme.borderRadius};
  cursor: pointer;
  padding: 8px;
  margin: 8px;
  border: none;
  color: #fff;

  .text {
    font: normal normal normal 14px/20px Poppins;
  }
`;
const Title = (external_styled_components_default()).text`
  text-align: left;
  font: normal normal 600 16px/14px Poppins;
  letter-spacing: 0.2px;
  line-height: 1.1;
  color: ${p => p.theme.pageForeground};
`;
const Text = external_styled_components_default()(Title)`
  font: normal normal normal 14px/14px Poppins;
  margin-top: 10px;
`;
const PriceContainer = external_styled_components_default()(InfoContainer)`
  width: 35%;
  right: 0;
  padding-left: 0;
`;
const ButtonGroup = (external_styled_components_default()).div`
  position: absolute;
  z-index: 1000;
  display: flex;
  flex-direction: column;
  gap: 5px;
  min-height: 320px;
  justify-content: center;
  margin-left: 8px;
`;
const ButtonConfig = (external_styled_components_default()).button`
  background-color: ${p => p.theme.pageBackground};
  border-radius: 4px;
  display: flex;
  justify-content: center;
  align-items: center;
  color: ${p => p.theme.primaryBackground};
  cursor: pointer;
  padding: 1px 10px;
  box-shadow: 0 3px 10px ${p => (0,external_polished_.transparentize)(0.9, p.theme.pageForeground)};
  width: 100%;
  height: 30px;
  font: normal normal normal 11px Poppins;

  :hover {
    background-color: ${p => p.theme.primaryBackground};
    color: ${p => p.theme.primaryForeground};
  }

  :active {
    opacity: 0.5;
  }

  :disabled {
    background-color: ${p => p.theme.inactiveElementBackground};
    color: ${p => p.theme.inactiveElementForeground};
    opacity: 1;
    cursor: no-drop;
    :active {
      opacity: 1;
    }
  }
`;
const InputGroup = (external_styled_components_default()).div`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${p => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/heart.tsx
var heart = __webpack_require__(488);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/star.tsx
var star = __webpack_require__(8409);
// EXTERNAL MODULE: ./src/app/components/SvgIcons/fullHeart.tsx
var fullHeart = __webpack_require__(4605);
// EXTERNAL MODULE: external "react-intl"
var external_react_intl_ = __webpack_require__(1687);
// EXTERNAL MODULE: ./src/core/contexts/UserContext.tsx
var UserContext = __webpack_require__(9263);
// EXTERNAL MODULE: ./src/app/components/WithAuthModal/index.tsx + 1 modules
var WithAuthModal = __webpack_require__(1629);
// EXTERNAL MODULE: ./src/app/components/ElementTag/index.tsx
var ElementTag = __webpack_require__(2175);
// EXTERNAL MODULE: ./src/core/hooks/useAdventure.ts
var useAdventure = __webpack_require__(3802);
// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(8475);
// EXTERNAL MODULE: external "primereact/dialog"
var dialog_ = __webpack_require__(3601);
// EXTERNAL MODULE: ./src/app/components/Button/index.tsx
var Button = __webpack_require__(4017);
// EXTERNAL MODULE: external "primereact/toast"
var toast_ = __webpack_require__(5439);
// EXTERNAL MODULE: ./src/core/utils/util.ts + 1 modules
var util = __webpack_require__(27);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(6731);
var router_default = /*#__PURE__*/__webpack_require__.n(router_);
;// CONCATENATED MODULE: ./src/app/components/CardAdventure/index.tsx





















function CardAdventure({
  timers,
  supplierId,
  adventure,
  setAuthModal,
  isEditCrew = false
}) {
  var _adventure$avaliacao, _adventure$data;

  const {
    0: _,
    1: forceUpdate
  } = (0,external_react_.useReducer)(x => x + 1, 0);
  const {
    t
  } = (0,external_next_i18next_.useTranslation)('common');
  const {
    favoriteAdventure,
    desfavoriteAdventure,
    deleteDataAventure
  } = (0,useAdventure/* default */.Z)();
  const userContext = (0,UserContext/* useUserContext */.SE)();
  const {
    0: visibleModalDelete,
    1: setVisibleModalDelete
  } = (0,external_react_.useState)(false);
  const toast = (0,external_react_.useRef)(null);

  const handleFavoriteOrDesfavorite = async event => {
    event.preventDefault();

    if (!userContext.isAuthenticated) {
      setAuthModal(true);
      return;
    }

    if (adventure.id) if (adventure.seFavorita === 'N') {
      await favoriteAdventure(adventure === null || adventure === void 0 ? void 0 : adventure.id).then(() => {
        adventure.seFavorita = 'S';
      }).catch(() => {});
    } else {
      await desfavoriteAdventure(adventure === null || adventure === void 0 ? void 0 : adventure.id).then(() => {
        adventure.seFavorita = 'N';
      }).catch(() => {});
    }
    forceUpdate();
  };

  const deleteAdventureOk = async adventureId => {
    const response = await deleteDataAventure(adventureId);

    if (response.status === 200) {
      setVisibleModalDelete(!visibleModalDelete);
      util/* Util.showSucessToast */.Z.showSucessToast(toast, "Aventura excluida com sucesso");
      location.reload();
    } else {
      util/* Util.showErrorToast */.Z.showErrorToast(toast, "Erro ao excluir aventura");
    }
  };

  return /*#__PURE__*/(0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
    children: [/*#__PURE__*/jsx_runtime_.jsx(toast_.Toast, {
      ref: toast,
      position: "top-center"
    }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(dialog_.Dialog, {
      header: "Aten\xE7\xE3o",
      visible: visibleModalDelete,
      style: {
        width: '50vw'
      },
      onHide: () => setVisibleModalDelete(!visibleModalDelete),
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        children: "Deseja excluir aventura selecionada ?"
      }), /*#__PURE__*/jsx_runtime_.jsx("br", {}), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InputGroup, {
        inputs: 2,
        children: [/*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          color: "#495057a3",
          onClick: () => setVisibleModalDelete(!visibleModalDelete),
          text: "N\xE3o"
        }), /*#__PURE__*/jsx_runtime_.jsx(Button/* default */.Z, {
          type: "button",
          text: "Sim",
          onClick: () => deleteAdventureOk(adventure.id)
        })]
      })]
    }), isEditCrew && /*#__PURE__*/(0,jsx_runtime_.jsxs)(ButtonGroup, {
      children: [/*#__PURE__*/jsx_runtime_.jsx(ButtonConfig, {
        onClick: () => setVisibleModalDelete(!visibleModalDelete),
        children: "Excluir"
      }), /*#__PURE__*/jsx_runtime_.jsx(ButtonConfig, {
        onClick: () => location.href = `/profiles/supplier/crews/${adventure.id}`,
        children: "Turmas"
      }), /*#__PURE__*/jsx_runtime_.jsx(ButtonConfig, {
        onClick: () => location.href = `/profiles/supplier/adventures/edit/${adventure.id}`,
        children: "Editar"
      })]
    }), /*#__PURE__*/jsx_runtime_.jsx(next_link.default, {
      href: `/adventure-details/${adventure === null || adventure === void 0 ? void 0 : adventure.id}/${adventure === null || adventure === void 0 ? void 0 : adventure.slug}`,
      passHref: true,
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Wrapper, {
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)(Image, {
          url: adventure === null || adventure === void 0 ? void 0 : adventure.urlFoto,
          onClick: () => router_default().push(`/adventure-details/${adventure === null || adventure === void 0 ? void 0 : adventure.id}/${adventure === null || adventure === void 0 ? void 0 : adventure.slug}`),
          children: [/*#__PURE__*/jsx_runtime_.jsx(FavoriteContainer, {
            onClick: event => handleFavoriteOrDesfavorite(event),
            children: (adventure === null || adventure === void 0 ? void 0 : adventure.seFavorita) === 'S' ? /*#__PURE__*/jsx_runtime_.jsx(fullHeart/* default */.Z, {
              width: 24,
              height: 26
            }) : /*#__PURE__*/jsx_runtime_.jsx(heart/* default */.Z, {
              fill: '#FFFFFF',
              width: 24,
              height: 26
            })
          }), (adventure === null || adventure === void 0 ? void 0 : adventure.avaliacao) && !isNaN(adventure === null || adventure === void 0 ? void 0 : adventure.avaliacao) && /*#__PURE__*/(0,jsx_runtime_.jsxs)(RatingContainer, {
            children: [/*#__PURE__*/jsx_runtime_.jsx(star/* default */.Z, {}), /*#__PURE__*/jsx_runtime_.jsx(Text, {
              children: parseFloat(adventure === null || adventure === void 0 ? void 0 : (_adventure$avaliacao = adventure.avaliacao) === null || _adventure$avaliacao === void 0 ? void 0 : _adventure$avaliacao.toString()).toFixed(1)
            })]
          }), /*#__PURE__*/jsx_runtime_.jsx(Element, {
            children: /*#__PURE__*/jsx_runtime_.jsx(ElementTag/* default */.ZP, {
              adventureType: adventure === null || adventure === void 0 ? void 0 : adventure.tipo
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(Element, {
            children: /*#__PURE__*/jsx_runtime_.jsx(ElementTag/* default */.ZP, {
              adventureType: adventure === null || adventure === void 0 ? void 0 : adventure.tipo
            })
          })]
        }), timers && /*#__PURE__*/jsx_runtime_.jsx(ButtonAction, {
          onClick: () => {
            location.href = `/profiles/admin/supplier/${supplierId}/schedules-adventures/${adventure.id}`;
          },
          children: "Ver hor\xE1rios"
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(InfoContainer, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Title, {
            children: adventure === null || adventure === void 0 ? void 0 : adventure.titulo
          }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            children: [t('where'), ": ", adventure === null || adventure === void 0 ? void 0 : adventure.local]
          })]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)(PriceContainer, {
          children: [/*#__PURE__*/jsx_runtime_.jsx(Title, {
            children: /*#__PURE__*/jsx_runtime_.jsx(external_react_intl_.FormattedNumber, {
              value: adventure === null || adventure === void 0 ? void 0 : adventure.valor,
              style: "currency",
              currency: "BRL"
            })
          }), /*#__PURE__*/jsx_runtime_.jsx(Text, {
            children: t('perPerson')
          })]
        }), (adventure === null || adventure === void 0 ? void 0 : adventure.data) && (adventure === null || adventure === void 0 ? void 0 : adventure.hora) && /*#__PURE__*/jsx_runtime_.jsx(InfoAccomplishedContainer, {
          children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(Text, {
            children: [adventure === null || adventure === void 0 ? void 0 : (_adventure$data = adventure.data) === null || _adventure$data === void 0 ? void 0 : _adventure$data.split('-').reverse().join('/'), " - ", ' ', adventure === null || adventure === void 0 ? void 0 : adventure.hora]
          })
        })]
      })
    })]
  });
}

/* harmony default export */ const components_CardAdventure = (/*#__PURE__*/external_react_default().memo((0,WithAuthModal/* default */.Z)(CardAdventure)));

/***/ })

};
;